/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.Dialog;
import com.sun.hadb.comm.DialogManager;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.MsgInfo;
import com.sun.hadb.comm.SepFrame;
import com.sun.hadb.comm.SepInitThread;
import com.sun.hadb.comm.SepManager;
import com.sun.hadb.comm.SepPingThread;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SepChannel {
    public static final int OPT_NONE = 0;
    public static final int OPT_VAR_HEADER = 1;
    public static final int OPT_SERVER_LIST = 2;
    public static final int RPC_CONNECT_CODE = 160;
    public static final int RPC_CONN_REPLY_CODE = 161;
    public static final int RPC_DATA_CODE = 162;
    public static final int RPC_CLOSE_CODE = 163;
    public static final int RPC_SUBSERVER_CODE = 164;
    public static final int RPC_PING_CODE = 165;
    public static final int RPC_NULL = 0;
    public static final int RPC_I_WANT_YOU = 1;
    public static final int RPC_I_AM_FREE = 2;
    public static final int RPC_I_LOVE_YOU = 3;
    public static final int RPC_TAKE_ME = 5;
    public static final int RPC_RECONNECT_AT = 7;
    public static final int RPC_BUZZ_OFF = 4;
    public static final int RPC_CLIENT_KNOWS = 6;
    private static final int SEP_CONNECT_TIMEOUT = 10000;
    private static final int SEP_CONNECT_WAIT_RETRY = 2000;
    private static final int SEP_QUERY_TIMEOUT = 0;
    private static final int SEP_PING_TIMEOUT = 4000;
    private static final int SEP_DISCONNECT_TIMEOUT = 1000;
    public static final int MSG_ADDR_IPV4 = 1;
    public static final int MSG_ADDR_IPV6 = 2;
    private Logger logger = CommLogFactory.getCommLogger();
    private long timeout = 0L;
    private long message_key;
    private EndPoint my_endpoint;
    private Dialog my_dialog;
    private boolean ready_flag;
    private SepPingThread pingThread;
    private boolean pingReceived = false;

    public SepChannel(EndPoint[] endpoints) {
        this(endpoints, 10000L);
    }

    public SepChannel(EndPoint[] endpoints, long timeout) {
        if (timeout == 0L) {
            this.connect(endpoints, 10000L);
        } else {
            this.connect(endpoints, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(EndPoint[] endpoints, long timeout) {
        DialogManager dlgman = DialogManager.getInstance();
        long timelimit = 0L;
        if (timeout != 0L) {
            timelimit = System.currentTimeMillis() + timeout;
        }
        do {
            this.my_dialog = null;
            this.my_endpoint = null;
            this.ready_flag = false;
            int nServers = endpoints.length;
            int startServer = (int)(Math.random() * (double)nServers);
            String myname = Thread.currentThread().getName();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("starting " + myname);
            }
            SepInitThread[] sits = new SepInitThread[nServers];
            for (int i = 0; i < nServers; ++i) {
                SepInitThread sit;
                int server = (i + startServer) % nServers;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Creating init thread for: " + endpoints[server].toString());
                }
                sits[server] = sit = new SepInitThread(this, endpoints[server], myname);
                Thread t = new Thread((Runnable)sit, "SEP INIT-" + i);
                t.setDaemon(true);
                t.start();
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception e) {
                // empty catch block
            }
            do {
                SepChannel e = this;
                synchronized (e) {
                    if (this.my_endpoint != null) {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer("Recceived positive answer from: " + this.my_endpoint.toString());
                        }
                        break;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            } while (timelimit == 0L || timelimit > System.currentTimeMillis());
            for (int i = 0; i < nServers; ++i) {
                sits[i].setRunning(false);
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(myname + " stopped SepInitThreads");
            }
            if (this.my_endpoint == null) {
                this.logger.fine("Timed out waiting for reply from database server");
                return;
            }
            try {
                int state = 3;
                Dialog dlg = null;
                block23: while (state != 255) {
                    switch (state) {
                        case 3: {
                            dlg = dlgman.open(this.my_endpoint, true, this.message_key);
                            if (dlg == null) {
                                this.logger.finest("SepInitThread.run() : DialogManager returned null dialog");
                                return;
                            }
                            EndPoint[] server_list = new EndPoint[]{this.my_endpoint};
                            SepFrame frame = new SepFrame(160, 3, null);
                            frame.setServerList(server_list);
                            frame.send(dlg, true);
                            break;
                        }
                        case 5: {
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Connection success with endpoint: " + this.my_endpoint.toString());
                            }
                            this.my_dialog = dlgman.open(this.my_endpoint, true, this.message_key);
                            SepManager.getInstance().register(this, this.my_endpoint);
                            this.ready_flag = true;
                            return;
                        }
                        default: {
                            if (this.logger.isLoggable(Level.FINER)) {
                                this.logger.finer("Connection error with endpoint: " + this.my_endpoint.toString());
                            }
                            return;
                        }
                    }
                    int type = this.receiveConnect(dlg);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine(myname + " state " + state + " type " + type);
                    }
                    switch (type) {
                        case 7: {
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.fine(myname + " ep:" + this.my_endpoint.toString());
                            }
                            dlg.close();
                            state = 3;
                            continue block23;
                        }
                        case 2: {
                            dlg.close();
                            state = 3;
                            continue block23;
                        }
                        case 5: {
                            dlg.close();
                            state = 5;
                            continue block23;
                        }
                        case 4: {
                            this.logger.finer("Received stand-by request from server");
                            Thread.sleep(200L);
                        }
                    }
                    dlg.close();
                    this.logger.finer("Connection error (on receive) with endpoint: " + this.my_endpoint.toString());
                    if (timelimit != 0L && timelimit < System.currentTimeMillis()) {
                        this.logger.finer("SEP Timeout");
                        return;
                    }
                    state = 255;
                }
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Exception caught during SEP connect negotiation", e);
            }
        } while (this.my_dialog == null);
        this.logger.finer("SEP timed out");
        this.ready_flag = false;
    }

    private int receiveConnect(Dialog dlg) throws CommException {
        MsgInfo msg = null;
        int retries = 0;
        while (msg == null && ++retries <= 4) {
            msg = dlg.receive(500L);
        }
        if (msg != null) {
            EndPoint[] serverlist;
            SepFrame frame = new SepFrame(msg);
            if (frame.getComCode() != 161) {
                this.logger.fine("Illegal comcode received : code = " + frame.getComCode());
                frame.close();
                return 255;
            }
            if (frame.getType() == 7 && (serverlist = frame.getServerList()).length > 0) {
                this.my_endpoint = serverlist[0];
                this.logger.finer("SEP reconnect to server at " + this.my_endpoint.toString());
            }
            this.message_key = frame.getMessageKey();
            int type = frame.getType();
            frame.close();
            return type;
        }
        return 255;
    }

    public void disconnect() {
        this.logger.finer("SEP Disconnect initiated");
        SepManager.getInstance().unregister(this);
        if (this.pingThread != null) {
            this.pingThread.stopRunning();
            this.pingThread = null;
        }
        if (this.ready_flag) {
            try {
                this.send(163, 0, 0, null, new MessageBuffer());
            }
            catch (CommException e) {
                this.logger.log(Level.FINE, "SEP disconnect call failed", e);
            }
            SepFrame frame = this.receive(1000L);
            if (frame != null) {
                frame.close();
            } else {
                this.logger.finer("Timed out waiting for server disconnect reply");
            }
        }
    }

    public synchronized void close() {
        this.logger.finer("SEP close initiated");
        SepManager.getInstance().unregister(this);
        if (this.my_dialog != null) {
            this.my_dialog.close();
            this.my_dialog = null;
        }
        if (this.pingThread != null) {
            this.pingThread.stopRunning();
            this.pingThread = null;
        }
    }

    public void sendRPCData(MessageBuffer buffer) throws CommException {
        this.send(162, 0, 0, null, buffer);
    }

    public void send(int comcode, int type, int options, byte[] attributes, MessageBuffer buffer) throws CommException {
        if (!this.ready_flag) {
            this.logger.finest("send() called while SEP channel was not open");
            throw new CommException(17);
        }
        MessageChunkByteArray chunk = new MessageChunkByteArray();
        ((MessageChunk)chunk).appendUInt8(comcode);
        ((MessageChunk)chunk).appendUInt8(type);
        options = 0;
        chunk.appendUInt16(options);
        if ((options & 1) <= 0 || (options & 2) > 0) {
            // empty if block
        }
        buffer.prepend(chunk);
        if (comcode == 163) {
            this.my_dialog.send(buffer, true);
        } else {
            this.my_dialog.send(buffer);
        }
    }

    public void sendRaw(MessageBuffer buffer) throws CommException {
        this.my_dialog.send(buffer);
    }

    public MessageBuffer receive() throws CommException {
        long currentTime = System.currentTimeMillis();
        long timelimit = 0L;
        if (this.timeout != 0L) {
            timelimit = currentTime + this.timeout;
        }
        SepFrame frame = null;
        do {
            long blockTime = 0L;
            if (timelimit == 0L || timelimit - currentTime > 4000L) {
                blockTime = 4000L;
            } else if (timelimit - currentTime > 0L) {
                blockTime = timelimit - currentTime;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("SEP receive lock time: " + blockTime);
            }
            int retries = 0;
            while (frame == null && ++retries <= 4) {
                frame = this.receive(blockTime / 4L);
            }
            if (frame != null) continue;
            if (!this.pingWasReceived()) {
                this.ready_flag = false;
                if (this.my_dialog == null) {
                    throw new CommException(17);
                }
                throw new CommException(18);
            }
            this.pingReceived = false;
            currentTime = System.currentTimeMillis();
            if (timelimit == 0L || currentTime < timelimit) continue;
            this.my_dialog.ignoreReply();
            this.logger.finest("SEP receive() timed out");
            return null;
        } while (frame == null);
        return frame.getBody();
    }

    private SepFrame receive(long timeout) {
        MsgInfo msg = this.my_dialog.receive(timeout);
        if (msg == null) {
            this.logger.finest("SepChannel.receive: timeout");
            return null;
        }
        SepFrame frame = new SepFrame(msg);
        switch (frame.getComCode()) {
            case 162: {
                this.logger.finest("SepChannel.receive() : RPC_DATA_CODE received");
                break;
            }
            case 163: {
                this.logger.finest("SepChannel.receive() : RPC_CLOSE_CODE received");
                break;
            }
            case 165: {
                this.logger.finest("SepChannel.receive() : RPC_PING_CODE received");
                break;
            }
            default: {
                this.logger.finest("SepChannel.receive() : Unknown com code " + frame.getComCode());
            }
        }
        return frame;
    }

    public boolean isReady() {
        return this.ready_flag;
    }

    void setEndPoint(EndPoint endpoint, long msgkey) {
        if (this.my_endpoint == null) {
            this.my_endpoint = endpoint;
            this.message_key = msgkey;
        }
    }

    public EndPoint getEndPoint() {
        return this.my_endpoint;
    }

    public void callback(int dialog_id, int round, int flags, MsgInfo msginfo) {
        if (this.pingThread == null) {
            try {
                this.pingThread = new SepPingThread(msginfo.getEndPoint(), dialog_id, msginfo.getMessageKey(), this);
                Thread t = new Thread((Runnable)this.pingThread, "SEP PING");
                t.setDaemon(true);
                t.start();
            }
            catch (CommException e) {
                this.logger.log(Level.FINE, "ping thread returned with exception", e);
            }
        } else {
            this.logger.finest("ping thread already exists");
        }
    }

    public synchronized void receivePing() {
        this.logger.fine("RPC_PING_CODE received");
        this.pingReceived = true;
    }

    public synchronized boolean pingWasReceived() {
        return this.pingReceived;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Dialog getDialog() {
        return this.my_dialog;
    }

    public void finalize() {
        if (this.my_dialog != null) {
            this.close();
        }
    }
}

