/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.Dialog;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.MsgInfo;
import java.net.InetAddress;

class SepFrame {
    private EndPoint endpoint;
    private long message_key;
    private int comcode;
    private int type;
    private int options;
    private byte[] optarr;
    private EndPoint[] server_list;
    private MessageBuffer body;

    public SepFrame(MsgInfo buffer) {
        this.dissect(buffer);
    }

    public SepFrame(Dialog dialog) throws CommException {
        this.dissect(dialog.receive());
    }

    public SepFrame(int comcode, int type, MessageBuffer body) {
        this.comcode = comcode;
        this.type = type;
        this.body = body;
        this.server_list = null;
        this.optarr = null;
    }

    public void close() {
        if (this.body != null) {
            this.body.close();
            this.body = null;
        }
    }

    public void setComCode(int comcode) {
        this.comcode = comcode;
    }

    public int getComCode() {
        return this.comcode;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public EndPoint[] getServerList() {
        return this.server_list;
    }

    public byte[] getOptions() {
        return this.optarr;
    }

    public void setServerList(EndPoint[] endpoints) {
        this.server_list = endpoints;
    }

    public void setOptions(byte[] opts) {
        this.optarr = opts;
    }

    public void setBody(MessageBuffer buffer) {
        this.body = buffer;
    }

    public MessageBuffer getBody() {
        return this.body;
    }

    public long getMessageKey() {
        return this.message_key;
    }

    public void send(Dialog dialog) throws CommException {
        this.send(dialog, false);
    }

    public void send(Dialog dialog, boolean is_last) throws CommException {
        MessageChunkByteArray chunk = new MessageChunkByteArray();
        ((MessageChunk)chunk).appendUInt8(this.comcode);
        ((MessageChunk)chunk).appendUInt8(this.type);
        if (this.server_list != null || this.optarr != null) {
            if (this.server_list != null) {
                byte[] barr;
                int i;
                chunk.appendUInt16(3);
                int addchars = 0;
                int terminator = 0;
                int addrsize = 2;
                int endpointcount = this.server_list.length;
                for (i = 0; i < endpointcount; ++i) {
                    InetAddress inet = this.server_list[i].getAddress();
                    barr = inet.getAddress();
                    ++addrsize;
                    ++addrsize;
                    addrsize += barr.length;
                }
                chunk.appendUInt16(addrsize);
                for (i = 0; i < endpointcount; ++i) {
                    InetAddress remote = this.server_list[i].getAddress();
                    barr = remote.getAddress();
                    ((MessageChunk)chunk).appendUInt8(1);
                    ((MessageChunk)chunk).appendUInt8(addchars);
                    for (int j = 0; j < barr.length; ++j) {
                        ((MessageChunk)chunk).appendUInt8(barr[j]);
                    }
                }
                chunk.appendUInt16(terminator);
            } else {
                chunk.appendUInt16(1);
                chunk.appendUInt16(0);
            }
        } else {
            chunk.appendUInt16(0);
        }
        if (this.body == null) {
            this.body = new MessageBuffer();
        }
        this.body.prepend(chunk);
        dialog.send(this.body, is_last);
        this.body = null;
    }

    private void dissect(MsgInfo frame) {
        MessageBuffer buffer = frame.getMessageBuffer();
        this.endpoint = frame.getEndPoint();
        this.message_key = frame.getMessageKey();
        this.comcode = buffer.getUInt8();
        this.type = buffer.getUInt8();
        this.options = buffer.getUInt16();
        this.body = buffer;
        if ((this.options & 1) != 0) {
            if ((this.options & 2) != 0) {
                this.server_list = this.decodeServerList(buffer);
                this.optarr = null;
            } else {
                this.optarr = this.decodeOptArr(buffer);
                this.server_list = null;
            }
        } else {
            this.optarr = null;
            this.server_list = null;
        }
    }

    private EndPoint[] decodeServerList(MessageBuffer buffer) {
        int len;
        if (buffer.size() > 0 && (len = buffer.getUInt16()) > 0) {
            int address_type = buffer.getUInt8();
            int address_option = buffer.getUInt8();
            int a = buffer.getUInt8();
            int b = buffer.getUInt8();
            int c = buffer.getUInt8();
            int d = buffer.getUInt8();
            int port = buffer.getUInt16();
            String addr = "" + a + '.' + b + '.' + c + '.' + d;
            EndPoint[] arr = new EndPoint[]{new EndPoint(addr, port)};
            return arr;
        }
        return null;
    }

    private byte[] decodeOptArr(MessageBuffer buffer) {
        int len;
        while ((len = buffer.getUInt16()) > 0) {
            for (int i = 2; i < len; ++i) {
                buffer.getUInt8();
            }
        }
        return null;
    }

    public String toString() {
        return "Comcode=" + this.comcode + ", type=" + this.type + ", options=" + this.options;
    }
}

