/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.SQLException;

class BinaryColumn
extends Column {
    int length;
    int padMode = 0;

    BinaryColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
        if (att != null) {
            this.length = att.getLength();
        }
    }

    int getLength() {
        return this.length + 1;
    }

    int getColumnDisplaySize() {
        return this.length * 2;
    }

    int getColumnType() {
        return -2;
    }

    String getColumnTypeName() {
        return "BINARY(" + this.length + ")";
    }

    final boolean isCaseSensitive() {
        return true;
    }

    Object getObject(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getFieldAsBytes(this.fieldNo);
    }

    String getClassName() throws SQLException {
        return "[B";
    }

    byte[] getBytes(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getFieldAsBytes(this.fieldNo);
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getBinaryFieldAsString(this.fieldNo);
    }

    InputStream getAsciiStream(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getFieldAsAsciiStream(this.fieldNo);
    }

    InputStream getBinaryStream(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getFieldAsAsciiStream(this.fieldNo);
    }

    BigDecimal getBigDecimal(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    BigDecimal getBigDecimal(Tuple r, int scale) throws SQLException {
        throw new DbException(5);
    }

    void setBytes(ParameterTuple r, byte[] parm2) throws SQLException {
        r.setCluBinary(this.fieldNo, this.length, parm2, this.padMode);
    }

    void setString(ParameterTuple r, String parm2) throws SQLException {
        r.setCluBinary(this.fieldNo, this.length, parm2, this.padMode);
    }

    void setAsciiStream(ParameterTuple r, InputStream parm2, int alen) throws SQLException {
        r.setStream(this.fieldNo, this.length, parm2, alen, this.padMode, 1);
    }

    void setBinaryStream(ParameterTuple r, InputStream parm2, int alen) throws SQLException {
        r.setStream(this.fieldNo, this.length, parm2, alen, this.padMode, 3);
    }

    void setUnicodeStream(ParameterTuple r, InputStream parm2, int alen) throws SQLException {
        r.setStream(this.fieldNo, this.length, parm2, alen, this.padMode, 2);
    }

    InputStream getUnicodeStream(Tuple r) throws SQLException {
        return r.getFieldAsUnicodeStream(this.fieldNo);
    }

    Reader getCharacterStream(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return new InputStreamReader(this.getAsciiStream(r));
    }

    void setCharacterStream(ParameterTuple r, Reader val, int arraylen) throws SQLException {
        r.setReader(this.fieldNo, this.length, val, arraylen, this.padMode);
    }
}

