/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.ByteArrayWrapper;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.LobWrapper;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.RBlobImpl;
import com.sun.hadb.jdbc.StreamWrapper;
import com.sun.hadb.jdbc.Tuple;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

class BlobColumn
extends Column {
    private LobWrapper blobWrapper;

    BlobColumn(RPCAttrDescr att, int fieldNo) {
        super(att, fieldNo);
    }

    int getColumnType() {
        return 2004;
    }

    String getColumnTypeName() {
        return "BLOB";
    }

    int getColumnDisplaySize() {
        return 6;
    }

    Object getObject(Tuple r) throws SQLException {
        return this.getBlob(r);
    }

    String getClassName() {
        return "java.sql.Blob";
    }

    void setBytes(ParameterTuple r, byte[] parm2) throws SQLException {
        if (parm2 != null) {
            this.blobWrapper = new ByteArrayWrapper(parm2);
            this.setInternalValue(r);
        } else {
            this.localSetNull(r);
        }
    }

    void setBinaryStream(ParameterTuple r, InputStream parm2, int alen) throws SQLException {
        this.blobWrapper = new StreamWrapper(parm2, alen);
        this.setInternalValue(r);
    }

    void setBlob(ParameterTuple r, Blob b) throws SQLException {
        if (b != null) {
            this.setBinaryStream(r, b.getBinaryStream(), (int)b.length());
        } else {
            this.localSetNull(r);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setObject(ParameterTuple r, Object obj) throws SQLException {
        if (obj != null) {
            if (obj instanceof Blob) {
                this.setBlob(r, (Blob)obj);
                return;
            } else {
                if (!(obj instanceof byte[])) throw new DbException(5);
                this.setBytes(r, (byte[])obj);
            }
            return;
        } else {
            this.localSetNull(r);
        }
    }

    boolean isCaseSensitive() {
        return true;
    }

    Blob getBlob(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        RBlobImpl rb = new RBlobImpl(r, this.fieldNo);
        return rb;
    }

    private void setInternalValue(ParameterTuple r) {
        ExtData p = r.allocField(this.fieldNo, 8);
        p.putInt64(this.getStreamLength(), 0);
    }

    public InputStream getStream() {
        return this.blobWrapper == null ? null : this.blobWrapper.getStream();
    }

    public long getStreamLength() {
        return this.blobWrapper == null ? 0L : this.blobWrapper.getLength();
    }

    void setNull(ParameterTuple r, int parm2) throws SQLException {
        if (!this.isNullable()) {
            throw new DbException(10);
        }
        r.setCluNull(this.fieldNo);
        this.blobWrapper = null;
    }

    private void localSetNull(ParameterTuple r) throws SQLException {
        this.setNull(r, 2004);
    }
}

