/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.LobInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobImpl
implements Blob {
    private ResultSet rs;
    private long size;
    private byte[] data;

    public InputStream getBinaryStream() throws SQLException {
        return new LobInputStream(this.rs, this.size);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] barr;
        int count;
        if (pos < 1L) {
            throw new IndexOutOfBoundsException("pos < 1");
        }
        LobInputStream in = (LobInputStream)this.getBinaryStream();
        long l = in.skipBytes(pos - 1L);
        if (l != pos - 1L) {
            throw new DbException(59);
        }
        long our_len = this.length();
        if (our_len - pos + 1L < (long)length) {
            length = (int)(our_len - pos + 1L);
        }
        if (length < 0) {
            length = 0;
        }
        if ((count = in.readArray(barr = new byte[length], 0, length)) != length) {
            throw new DbException(59);
        }
        return barr;
    }

    public long length() throws SQLException {
        if (this.size > -1L) {
            return this.size;
        }
        if (this.data != null) {
            return this.data.length;
        }
        return 0L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new DbException(2);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new DbException(2);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new DbException(2);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new DbException(2);
    }

    public void truncate(long len) throws SQLException {
        if (len < this.length()) {
            byte[] tmp = new byte[(int)len];
            System.arraycopy(this.data, 0, tmp, 0, (int)len);
            this.data = tmp;
        }
    }

    protected BlobImpl(ResultSet rs, long size) throws SQLException {
        this.size = size;
        this.rs = rs;
    }
}

