/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

class CharacterColumn
extends Column {
    protected int length;
    int padMode;

    public CharacterColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
        if (att != null) {
            this.length = att.getLength();
        }
        this.padMode = 1;
    }

    int getLength() {
        return this.length + 1;
    }

    int getColumnDisplaySize() {
        return this.length;
    }

    int getColumnType() {
        return 1;
    }

    String getColumnTypeName() {
        return "CHAR(" + this.length + ")";
    }

    Object getObject(Tuple r) throws SQLException {
        return this.getString(r);
    }

    String getClassName() throws SQLException {
        return "java.lang.String";
    }

    Number getNumber(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return new Integer(0);
        }
        Number n = null;
        try {
            String s = this.getString(r);
            s = s.trim();
            n = s.indexOf(46) == -1 ? (Number)new Long(s) : (Number)new Double(s);
        }
        catch (NumberFormatException e) {
            throw new DbException(6);
        }
        return n;
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getFieldAsString(this.fieldNo);
    }

    String getStringFromInput(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getFieldAsString(this.fieldNo);
    }

    Date getDate(Tuple r) throws SQLException {
        String str = this.getString(r);
        if (str == null) {
            return null;
        }
        str = str.trim();
        try {
            return Date.valueOf(str);
        }
        catch (IllegalArgumentException e1) {
            Timestamp ts;
            try {
                ts = Timestamp.valueOf(str);
            }
            catch (IllegalArgumentException e2) {
                throw new DbException(6);
            }
            if (str.length() < 19) {
                throw new DbException(6);
            }
            if (!str.substring(11, 19).equals("00:00:00") || ts.getNanos() != 0) {
                this.accessor.addWarning(new DataTruncation(this.fieldNo + 1, false, true, str.length(), 10));
            }
            return Date.valueOf(str.substring(0, 10));
        }
    }

    Time getTime(Tuple r) throws SQLException {
        String str = this.getString(r);
        if (str == null) {
            return null;
        }
        str = str.trim();
        try {
            if (str.length() > 8 && str.length() < 19) {
                if (str.charAt(8) != '.') {
                    throw new DbException(6);
                }
                String scale = str.substring(9, str.length());
                if (Integer.valueOf(scale) != 0) {
                    this.accessor.addWarning(new DataTruncation(this.fieldNo + 1, false, true, str.length(), 8));
                }
                return Time.valueOf(str.substring(0, 8));
            }
            return Time.valueOf(str);
        }
        catch (IllegalArgumentException e1) {
            Timestamp ts;
            try {
                ts = Timestamp.valueOf(str);
            }
            catch (IllegalArgumentException e2) {
                throw new DbException(6);
            }
            if (str.length() < 19) {
                throw new DbException(6);
            }
            if (ts.getNanos() != 0) {
                this.accessor.addWarning(new DataTruncation(this.fieldNo + 1, false, true, str.length(), 8));
            }
            return Time.valueOf(str.substring(11, 19));
        }
    }

    Timestamp getTimestamp(Tuple r) throws SQLException {
        String str = this.getString(r);
        if (str == null) {
            return null;
        }
        str = str.trim();
        try {
            return Timestamp.valueOf(str);
        }
        catch (IllegalArgumentException e1) {
            try {
                Date.valueOf(str);
                if (str.length() != 10) {
                    throw new DbException(6);
                }
                return Timestamp.valueOf(str + " 00:00:00");
            }
            catch (IllegalArgumentException e2) {
                Date current_date = new Date(System.currentTimeMillis());
                try {
                    return Timestamp.valueOf("1970-01-01 " + str);
                }
                catch (IllegalArgumentException e3) {
                    throw new DbException(6);
                }
            }
        }
    }

    InputStream getAsciiStream(Tuple r) throws SQLException {
        return r.getFieldAsAsciiStream(this.fieldNo);
    }

    boolean getBoolean(Tuple r) throws SQLException {
        String str = this.getString(r);
        if (str == null) {
            return false;
        }
        return Boolean.valueOf(str.trim());
    }

    boolean isCaseSensitive() {
        return true;
    }

    void setString(ParameterTuple r, String parm2) throws SQLException {
        r.setCluChar(this.fieldNo, this.length, parm2, this.padMode);
    }

    void setDate(ParameterTuple r, Date val) throws SQLException {
        if (val == null) {
            r.setCluNull(this.fieldNo);
            return;
        }
        this.setString(r, this.correctDate(val.toString()));
    }

    void setTime(ParameterTuple r, Time val) throws SQLException {
        if (val == null) {
            r.setCluNull(this.fieldNo);
            return;
        }
        this.setString(r, val.toString());
    }

    void setTimestamp(ParameterTuple r, Timestamp val) throws SQLException {
        if (val == null) {
            r.setCluNull(this.fieldNo);
            return;
        }
        this.setString(r, this.correctTimestamp(val.toString()));
    }

    void setAsciiStream(ParameterTuple r, InputStream val, int arraylen) throws SQLException {
        r.setStream(this.fieldNo, this.length, val, arraylen, this.padMode, 1);
    }

    void setNumber(ParameterTuple r, Number n) throws SQLException {
        if (n == null) {
            r.setCluNull(this.fieldNo);
        } else {
            this.setString(r, n.toString());
        }
    }

    void setBoolean(ParameterTuple r, boolean v) throws SQLException {
        this.setString(r, new Boolean(v).toString());
    }

    InputStream getUnicodeStream(Tuple r) throws SQLException {
        return r.getFieldAsUnicodeStream(this.fieldNo);
    }

    void setUnicodeStream(ParameterTuple r, InputStream val, int arraylen) throws SQLException {
        r.setStream(this.fieldNo, this.length, val, arraylen, this.padMode, 2);
    }

    Reader getCharacterStream(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return new InputStreamReader(this.getAsciiStream(r));
    }

    void setCharacterStream(ParameterTuple r, Reader val, int arraylen) throws SQLException {
        r.setReader(this.fieldNo, this.length, val, arraylen, this.padMode);
    }
}

