/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.ByteArrayWrapper;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.LobWrapper;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.RClobImpl;
import com.sun.hadb.jdbc.StreamWrapper;
import com.sun.hadb.jdbc.Tuple;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.SQLException;

class ClobColumn
extends Column {
    private LobWrapper clobWrapper = null;

    ClobColumn(RPCAttrDescr att, int fieldNo) {
        super(att, fieldNo);
    }

    int getColumnType() {
        return 2005;
    }

    String getColumnTypeName() {
        return "CLOB";
    }

    int getColumnDisplaySize() {
        return 8;
    }

    Object getObject(Tuple r) throws SQLException {
        return this.getClob(r);
    }

    String getClassName() {
        return "java.sql.Clob";
    }

    Clob getClob(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        RClobImpl rc = new RClobImpl(r, this.fieldNo);
        return rc;
    }

    void setString(ParameterTuple r, String parm2) throws SQLException {
        if (parm2 != null) {
            this.clobWrapper = new ByteArrayWrapper(parm2.getBytes());
            this.setInternalValue(r);
        } else {
            this.localSetNull(r);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setObject(ParameterTuple r, Object o) throws SQLException {
        if (o != null) {
            if (o instanceof Clob) {
                this.setClob(r, (Clob)o);
                return;
            } else {
                if (!(o instanceof byte[])) throw new DbException(5);
                this.setBytes(r, (byte[])o);
            }
            return;
        } else {
            this.localSetNull(r);
        }
    }

    void setClob(ParameterTuple r, Clob clob) throws SQLException {
        if (clob != null) {
            this.clobWrapper = new StreamWrapper(clob.getAsciiStream(), clob.length());
            this.setInternalValue(r);
        } else {
            this.localSetNull(r);
        }
    }

    void setBytes(ParameterTuple r, byte[] parm2) throws SQLException {
        if (parm2 != null) {
            this.clobWrapper = new ByteArrayWrapper(parm2);
            this.setInternalValue(r);
        } else {
            this.localSetNull(r);
        }
    }

    void setAsciiStream(ParameterTuple r, InputStream parm2, int alen) throws SQLException {
        if (parm2 != null) {
            this.clobWrapper = new StreamWrapper(parm2, alen);
            this.setInternalValue(r);
        } else {
            this.localSetNull(r);
        }
    }

    void setNull(ParameterTuple r, int parm2) throws SQLException {
        if (!this.isNullable()) {
            throw new DbException(10);
        }
        r.setCluNull(this.fieldNo);
        this.clobWrapper = null;
    }

    public InputStream getStream() {
        return this.clobWrapper == null ? null : this.clobWrapper.getStream();
    }

    public long getStreamLength() {
        return this.clobWrapper == null ? 0L : this.clobWrapper.getLength();
    }

    private void setInternalValue(ParameterTuple r) {
        ExtData p = r.allocField(this.fieldNo, 8);
        p.putInt64(this.getStreamLength(), 0);
    }

    private void localSetNull(ParameterTuple r) throws SQLException {
        this.setNull(r, 2005);
    }
}

