/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.ColumnAccessor;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

abstract class Column {
    protected int fieldNo;
    protected ColumnAccessor accessor = null;
    protected RPCAttrDescr att = null;

    Column(RPCAttrDescr att, int fieldNo) {
        this.fieldNo = fieldNo;
        this.att = att;
    }

    void setColumnAccessor(ColumnAccessor a) {
        this.accessor = a;
    }

    public String toString() {
        String columnTypeName;
        try {
            columnTypeName = this.getColumnTypeName();
        }
        catch (Exception e) {
            columnTypeName = "ERROR!";
        }
        return "Column \nColumn type name:" + columnTypeName + "\nField number    :" + this.fieldNo + "\nattribute descr.:" + this.att.toString();
    }

    abstract int getColumnDisplaySize() throws SQLException;

    abstract int getColumnType() throws SQLException;

    abstract String getColumnTypeName() throws SQLException;

    abstract Object getObject(Tuple var1) throws SQLException;

    abstract String getClassName() throws SQLException;

    boolean isNullable() {
        return this.att.isNulls();
    }

    boolean isCaseSensitive() {
        return false;
    }

    final boolean isSearchable() {
        return true;
    }

    boolean isSigned() {
        return false;
    }

    final boolean isReadOnly() {
        return this.att.isReadOnly();
    }

    final boolean isWritable() {
        return !this.att.isReadOnly();
    }

    final boolean isDefinitelyWritable() {
        return false;
    }

    protected boolean checkCluNull(Tuple r) throws SQLException {
        boolean isNull = r.checkCluNull(this.fieldNo);
        if (this.accessor != null) {
            this.accessor.setWasNull(isNull);
        }
        return isNull;
    }

    InputStream getAsciiStream(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    BigDecimal getBigDecimal(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        Number n = this.getNumber(r);
        if (n instanceof Double || n instanceof Float) {
            return new BigDecimal(n.doubleValue());
        }
        return new BigDecimal(n.toString());
    }

    private BigDecimal applyBigDecimalScale(BigDecimal val, int scale) throws SQLException {
        if (val.scale() > scale) {
            this.accessor.addWarning(new DataTruncation(this.fieldNo + 1, false, true, val.scale(), scale));
        }
        return val.setScale(scale, 6);
    }

    BigDecimal getBigDecimal(Tuple r, int scale) throws SQLException {
        BigDecimal val = this.getBigDecimal(r);
        if (val != null) {
            val = this.applyBigDecimalScale(val, scale);
        }
        return val;
    }

    InputStream getBinaryStream(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    boolean getBoolean(Tuple r) throws SQLException {
        long l = this.getLong(r);
        return l != 0L;
    }

    byte getByte(Tuple r) throws SQLException {
        return this.getNumber(r).byteValue();
    }

    byte[] getBytes(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Date getDate(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    float getFloat(Tuple r) throws SQLException {
        return this.getNumber(r).floatValue();
    }

    double getDouble(Tuple r) throws SQLException {
        return this.getNumber(r).doubleValue();
    }

    int getInt(Tuple r) throws SQLException {
        return this.getNumber(r).intValue();
    }

    Number getNumber(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    long getLong(Tuple r) throws SQLException {
        return this.getNumber(r).longValue();
    }

    short getShort(Tuple r) throws SQLException {
        return this.getNumber(r).shortValue();
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        Object obj = this.getObject(r);
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    String getStringFromInput(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Time getTime(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Timestamp getTimestamp(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    InputStream getUnicodeStream(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    ExtData allocFieldSpace(ParameterTuple r, int size) {
        if (r.getFieldSize(this.fieldNo) != size) {
            return r.allocField(this.fieldNo, size);
        }
        return r.getField(this.fieldNo);
    }

    void setAsciiStream(ParameterTuple r, InputStream v, int parm3) throws SQLException {
        throw new DbException(5);
    }

    void setBigDecimal(ParameterTuple r, BigDecimal v) throws SQLException {
        this.setNumber(r, v);
    }

    void setBinaryStream(ParameterTuple r, InputStream v, int parm3) throws SQLException {
        throw new DbException(5);
    }

    void setBoolean(ParameterTuple r, boolean v) throws SQLException {
        throw new DbException(5);
    }

    void setByte(ParameterTuple r, byte v) throws SQLException {
        this.setLong(r, v);
    }

    void setBytes(ParameterTuple r, byte[] v) throws SQLException {
        throw new DbException(5);
    }

    void setCharacterStream(ParameterTuple r, Reader v, int parm3) throws SQLException {
        throw new DbException(5);
    }

    void setDate(ParameterTuple r, Date v) throws SQLException {
        throw new DbException(5);
    }

    void setDouble(ParameterTuple r, double v) throws SQLException {
        this.setNumber(r, new Double(v));
    }

    void setFloat(ParameterTuple r, float v) throws SQLException {
        this.setNumber(r, new Float(v));
    }

    void setInt(ParameterTuple r, int v) throws SQLException {
        this.setNumber(r, new Integer(v));
    }

    void setLong(ParameterTuple r, long v) throws SQLException {
        this.setNumber(r, new Long(v));
    }

    void setNumber(ParameterTuple r, Number v) throws SQLException {
        throw new DbException(5);
    }

    void setNull(ParameterTuple r, int parm2) throws SQLException {
        if (!this.isNullable()) {
            throw new DbException(10);
        }
        r.setCluNull(this.fieldNo);
    }

    void setNull(ParameterTuple r, int parm2, String parm3) throws SQLException {
        this.setNull(r, parm2);
    }

    void setObject(ParameterTuple r, Object v) throws SQLException {
        if (v == null) {
            this.setNull(r, this.getColumnType());
        } else if (v instanceof String) {
            this.setString(r, (String)v);
        } else if (v instanceof BigDecimal) {
            this.setBigDecimal(r, (BigDecimal)v);
        } else if (v instanceof Boolean) {
            this.setBoolean(r, (Boolean)v);
        } else if (v instanceof Number) {
            this.setNumber(r, (Number)v);
        } else if (v instanceof byte[]) {
            this.setBytes(r, (byte[])v);
        } else if (v instanceof Date) {
            this.setDate(r, (Date)v);
        } else if (v instanceof Time) {
            this.setTime(r, (Time)v);
        } else if (v instanceof Timestamp) {
            this.setTimestamp(r, (Timestamp)v);
        } else {
            throw new DbException(5);
        }
    }

    void setObject(ParameterTuple r, Object v, int parm3) throws SQLException {
        this.setObject(r, v);
    }

    void setObject(ParameterTuple r, Object v, int parm3, int scale) throws SQLException {
        this.setObject(r, v);
    }

    void setShort(ParameterTuple r, short v) throws SQLException {
        this.setLong(r, v);
    }

    void setString(ParameterTuple r, String v) throws SQLException {
        throw new DbException(5);
    }

    void setTime(ParameterTuple r, Time v) throws SQLException {
        throw new DbException(5);
    }

    void setTimestamp(ParameterTuple r, Timestamp v) throws SQLException {
        throw new DbException(5);
    }

    void setUnicodeStream(ParameterTuple r, InputStream v, int parm3) throws SQLException {
        throw new DbException(5);
    }

    Array getArray(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Blob getBlob(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Reader getCharacterStream(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Clob getClob(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Date getDate(Tuple r, Calendar parm2) throws SQLException {
        Date dbDate = this.getDate(r);
        int tzOffset = parm2.get(15);
        int dstOffset = parm2.get(16);
        long msDate = dbDate.getTime();
        dbDate.setTime(msDate + (long)tzOffset + (long)dstOffset);
        return dbDate;
    }

    Object getObject(Tuple r, Map parm2) throws SQLException {
        throw new DbException(5);
    }

    Ref getRef(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    Time getTime(Tuple r, Calendar parm2) throws SQLException {
        Time dbTime = this.getTime(r);
        int tzOffset = parm2.get(15);
        int dstOffset = parm2.get(16);
        long msTime = dbTime.getTime();
        dbTime.setTime(msTime + (long)tzOffset + (long)dstOffset);
        return dbTime;
    }

    Timestamp getTimestamp(Tuple r, Calendar parm2) throws SQLException {
        Timestamp dbTimestamp = this.getTimestamp(r);
        int tzOffset = parm2.get(15);
        int dstOffset = parm2.get(16);
        long msTimestamp = dbTimestamp.getTime();
        dbTimestamp.setTime(msTimestamp + (long)tzOffset + (long)dstOffset);
        return dbTimestamp;
    }

    void setArray(ParameterTuple r, Array v) throws SQLException {
        throw new DbException(5);
    }

    void setBlob(ParameterTuple r, Blob v) throws SQLException {
        throw new DbException(5);
    }

    void setClob(ParameterTuple r, Clob v) throws SQLException {
        throw new DbException(5);
    }

    void setDate(ParameterTuple r, Date v, Calendar parm3) throws SQLException {
        if (v == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        Date val = new Date(v.getTime());
        int tzOffset = parm3.get(15);
        int dstOffset = parm3.get(16);
        long msDate = val.getTime();
        val.setTime(msDate - (long)tzOffset - (long)dstOffset);
        this.setDate(r, val);
    }

    void setRef(ParameterTuple r, Ref v) throws SQLException {
        throw new DbException(5);
    }

    void setTime(ParameterTuple r, Time v, Calendar parm3) throws SQLException {
        if (v == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        Time val = new Time(v.getTime());
        int tzOffset = parm3.get(15);
        int dstOffset = parm3.get(16);
        long msDate = val.getTime();
        val.setTime(msDate - (long)tzOffset - (long)dstOffset);
        this.setTime(r, val);
    }

    void setTimestamp(ParameterTuple r, Timestamp v, Calendar parm3) throws SQLException {
        if (v == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        Timestamp val = new Timestamp(v.getTime());
        int tzOffset = parm3.get(15);
        int dstOffset = parm3.get(16);
        long msDate = val.getTime();
        val.setTime(msDate - (long)tzOffset - (long)dstOffset);
        this.setTimestamp(r, val);
    }

    protected Date getCurrentDate() {
        return new Date(0L);
    }

    String correctDate(String str) {
        if (str.length() < 10) {
            return Column.repeatChar('0', 10 - str.length()) + str;
        }
        return str;
    }

    String correctTimestamp(String str) {
        int len = str.lastIndexOf(46);
        if (len < 19) {
            return Column.repeatChar('0', 19 - len) + str;
        }
        return str;
    }

    protected void conversions(int conversionid, Tuple t) {
        try {
            switch (conversionid) {
                case 0: {
                    System.out.print(" (object)   =");
                    Object obj = this.getObject(t);
                    if (obj == null) {
                        System.out.print("null");
                        break;
                    }
                    System.out.print(obj.toString());
                    break;
                }
                case 1: {
                    System.out.print(" string     =");
                    System.out.print(this.getString(t));
                    break;
                }
                case 2: {
                    System.out.print(" byte       =");
                    System.out.print(this.getByte(t));
                    break;
                }
                case 3: {
                    System.out.print(" short      =");
                    System.out.print(this.getShort(t));
                    break;
                }
                case 4: {
                    System.out.print(" int        =");
                    System.out.print(this.getInt(t));
                    break;
                }
                case 5: {
                    System.out.print(" long       =");
                    System.out.print(this.getLong(t));
                    break;
                }
                case 6: {
                    System.out.print(" float      =");
                    System.out.print(this.getFloat(t));
                    break;
                }
                case 7: {
                    System.out.print(" double     =");
                    System.out.print(this.getDouble(t));
                    break;
                }
                case 8: {
                    System.out.print(" bigdecimal =");
                    System.out.print(this.getBigDecimal(t));
                    break;
                }
                case 9: {
                    System.out.print(" boolean    =");
                    System.out.print(this.getBoolean(t));
                    break;
                }
                case 10: {
                    System.out.print(" date       =");
                    System.out.print(this.getDate(t));
                    break;
                }
                case 11: {
                    System.out.print(" time       =");
                    System.out.print(this.getTime(t));
                    break;
                }
                case 12: {
                    System.out.print(" timestamp  =");
                    System.out.print(this.getTimestamp(t));
                }
            }
        }
        catch (Exception e) {
            System.out.print("(error): " + e.getMessage());
        }
    }

    URL getURL(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    void setURL(Tuple r, URL x) throws SQLException {
        throw new DbException(5);
    }

    int getPrecision() throws SQLException {
        return this.att.getPrecision();
    }

    int getScale() throws SQLException {
        return this.att.getScale();
    }

    int getColumnMode() throws SQLException {
        return 1;
    }

    protected static String repeatChar(char c, int n) {
        if (n > 0) {
            StringBuffer sb = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                sb.append(c);
            }
            return sb.toString();
        }
        return "";
    }
}

