/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.CliChannel;
import com.sun.hadb.comm.CliDatabase;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.SepChannel;
import com.sun.hadb.jdbc.CallableStatementImpl;
import com.sun.hadb.jdbc.DatabaseMetaDataImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.Driver;
import com.sun.hadb.jdbc.JdbcLogFactory;
import com.sun.hadb.jdbc.LOBDescr;
import com.sun.hadb.jdbc.LobConnection;
import com.sun.hadb.jdbc.LobPrepStatement;
import com.sun.hadb.jdbc.PreparedStatementImpl;
import com.sun.hadb.jdbc.ServerInformation;
import com.sun.hadb.jdbc.StatementImpl;
import com.sun.hadb.jdbc.StatementPool;
import com.sun.hadb.jdbc.Statistics;
import java.net.InetSocketAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConnectionImpl
implements Connection,
LobConnection {
    static final int DEFAULT_RS_TYPE = 1003;
    static final int DEFAULT_CONCURRENCY = 1007;
    static final int DEFAULT_HOLDABILITY = 2;
    private int no_of_hosts = 0;
    private String hostlist;
    private Properties hosts = null;
    private String user = "";
    private String password = "";
    private EndPoint[] endpoints = null;
    private CliChannel channel = null;
    private CliDatabase database = null;
    private boolean checkBufferedActions = false;
    private boolean readOnly;
    private boolean autoCommit = false;
    private int isolation;
    private SQLWarning warnings = null;
    private DatabaseMetaDataImpl metaData;
    private int protocolVersion;
    private int userId;
    private int login_timeout;
    private Statistics stats;
    protected Hashtable cursors;
    private boolean reconnect;
    private WeakHashMap pstmtmap;
    private WeakHashMap dirtymap;
    private StatementPool pstmtpool = null;
    private boolean dirty;
    private int maxtransidle = 0;
    private int locktimeout = 0;
    private boolean clusteredblob = true;
    private boolean pingWhenGetMetaData = false;
    private long currentSchema = 0L;
    private boolean eliminateRedundantEndTransaction = false;
    private boolean user_close = false;
    private Logger logger = JdbcLogFactory.getJDBCLogger();
    private ServerInformation serverInfo = null;
    private Map typeMap = null;
    private static final String BlobTableSuffix = "#0";

    public String toString() {
        return "ConnectionImpl to " + this.getURL();
    }

    public Object[] getPerf(int[] bsi) throws SQLException {
        throw new DbException(2, "Statistics");
    }

    ConnectionImpl(Properties info) throws SQLException {
        this(null, null, null, info);
    }

    public ConnectionImpl(String hostList, String userName, String password) throws SQLException {
        this(hostList, userName, password, null);
    }

    public ConnectionImpl(String hostList, String userName, String password, Properties info) throws SQLException {
        try {
            int i;
            this.user = userName;
            this.hostlist = hostList;
            if (info != null) {
                String cacheMD;
                String endTrans;
                String pool;
                String ptb;
                String lto;
                String mti;
                if (this.hostlist == null) {
                    this.hostlist = info.getProperty("hostlist");
                }
                if (this.user == null) {
                    this.user = info.getProperty("user");
                }
                if (this.user == null) {
                    this.user = info.getProperty("username");
                }
                if (password == null) {
                    password = info.getProperty("password");
                }
                if ((mti = info.getProperty("maxtransidle")) != null) {
                    try {
                        this.maxtransidle = Integer.parseInt(mti);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((lto = info.getProperty("locktimeout")) != null) {
                    try {
                        this.locktimeout = Integer.parseInt(lto);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((ptb = info.getProperty("clusteredblob")) != null) {
                    this.clusteredblob = Boolean.valueOf(ptb);
                }
                if ((pool = info.getProperty("statementpool")) != null) {
                    try {
                        this.initializeStatementPool(Integer.parseInt(pool));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((endTrans = info.getProperty("eliminateredundantendtransaction")) != null) {
                    try {
                        this.eliminateRedundantEndTransaction = Boolean.valueOf(endTrans);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((cacheMD = info.getProperty("cachedatabasemetadata")) != null) {
                    try {
                        this.pingWhenGetMetaData = Boolean.valueOf(cacheMD) == false;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (this.hostlist == null) {
                throw new DbException(46);
            }
            if (this.user == null) {
                throw new DbException(44);
            }
            if (password == null) {
                throw new DbException(45);
            }
            this.password = password;
            if (this.logger.isLoggable(Level.CONFIG)) {
                StringBuffer sb = new StringBuffer();
                sb.append("hostlist=").append(this.hostlist).append(" user=").append(this.user).append(" maxtransidle=").append(this.maxtransidle).append(" locktimeout=").append(this.locktimeout).append(" eliminateredundantendtransaction=").append(this.eliminateRedundantEndTransaction);
                if (this.pstmtpool != null) {
                    sb.append(" statementpool=").append(this.pstmtpool.getPoolSize());
                }
                this.logger.config(sb.toString());
            }
            Properties hosts = ConnectionImpl.parseHostlist(this.hostlist);
            this.no_of_hosts = Integer.parseInt(hosts.getProperty("noofhosts"));
            Vector<EndPoint> evec = new Vector<EndPoint>();
            for (i = 0; i < this.no_of_hosts; ++i) {
                EndPoint ep = new EndPoint(hosts.getProperty("host" + i), Integer.parseInt(hosts.getProperty("port" + i)));
                if (ep.getAddress() == null) continue;
                evec.addElement(ep);
            }
            if (evec.size() == 0) {
                throw new DbException(51, this.hostlist);
            }
            this.endpoints = new EndPoint[evec.size()];
            for (i = 0; i < evec.size(); ++i) {
                this.endpoints[i] = (EndPoint)evec.elementAt(i);
            }
            int ltim = 0;
            this.reconnect = false;
            if (info != null) {
                String t_o = info.getProperty("logintimeout");
                if (t_o != null) {
                    try {
                        ltim = Integer.parseInt(t_o);
                    }
                    catch (NumberFormatException e) {
                        ltim = 0;
                    }
                } else {
                    ltim = DriverManager.getLoginTimeout();
                }
                if ((t_o = info.getProperty("reconnect")) != null) {
                    this.reconnect = Boolean.valueOf(t_o);
                }
            }
            this.login_timeout = ltim;
            this.pstmtmap = new WeakHashMap();
            this.dirtymap = new WeakHashMap();
            this.autoCommit = true;
            this.readOnly = false;
            this.isolation = 2;
            this.reconnect(this.endpoints, ltim * 1000, this.user, password);
            this.stats = new Statistics();
            this.cursors = new Hashtable();
            this.metaData = new DatabaseMetaDataImpl(this);
        }
        catch (SQLException e) {
            this.closeAndDisconnect();
            throw e;
        }
        catch (CommException e) {
            this.closeAndDisconnect();
            if (e.getRPCStatus() != null) {
                throw new DbException(e.getRPCStatus(), e);
            }
            throw new DbException(e);
        }
    }

    private synchronized void closeAndDisconnect() {
        if (this.poolStatements()) {
            this.pstmtpool.clearPool(true);
        }
        this.pstmtpool = null;
        if (this.database != null) {
            this.database.close();
            this.database = null;
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        this.endpoints = null;
    }

    synchronized ServerInformation acquireServerInfo() throws SQLException {
        if (this.serverInfo == null) {
            this.serverInfo = new ServerInformation(this);
        }
        return this.serverInfo;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public synchronized void close() throws SQLException {
        this.logger.fine("Connection closed by application");
        this.user_close = true;
        if (!this.isClosed()) {
            this.closeAndDisconnect();
        }
    }

    public synchronized void commit() throws SQLException {
        this.logger.fine("Transaction commit");
        this.checkOpen();
        try {
            this.database.commit();
        }
        catch (CommException e) {
            this.markDirty(e);
            RPCStatus rpcstat = e.getRPCStatus();
            if (rpcstat != null) {
                throw new DbException(rpcstat, e);
            }
            throw new DbException(e);
        }
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return null;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        if (this.pingWhenGetMetaData) {
            try {
                this.database.ping();
            }
            catch (CommException e) {
                throw new DbException(e);
            }
        }
        return this.metaData;
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.isolation;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.database == null;
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.readOnly;
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new DbException(2, "CallableStatement");
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    public synchronized void rollback() throws SQLException {
        this.logger.fine("Transaction rollback");
        this.checkOpen();
        try {
            this.database.rollback();
        }
        catch (CommException e) {
            this.markDirty(e);
            RPCStatus stat = e.getRPCStatus();
            if (stat != null) {
                throw new DbException(stat, e);
            }
            throw new DbException(e);
        }
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Setting auto-commit: " + autoCommit);
        }
        try {
            if (autoCommit) {
                this.database.setExecutionMode(1, 1L);
                this.setInternalAutoCommit(true);
            } else {
                this.database.setExecutionMode(1, 0L);
                this.setInternalAutoCommit(false);
            }
        }
        catch (CommException e) {
            this.markDirty(e);
            RPCStatus stat = e.getRPCStatus();
            if (stat != null) {
                throw new DbException(stat, e);
            }
            throw new DbException(e);
        }
    }

    void setInternalAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
    }

    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        try {
            if (readOnly) {
                this.logger.fine("Setting connection to read-only mode");
                this.database.setExecutionMode(2, 1L);
                this.readOnly = true;
            } else {
                this.logger.fine("Setting connection to read/write mode");
                this.database.setExecutionMode(2, 2L);
                this.readOnly = false;
            }
        }
        catch (CommException e) {
            this.markDirty(e);
            RPCStatus stat = e.getRPCStatus();
            if (stat != null) {
                throw new DbException(stat, e);
            }
            throw new DbException(e);
        }
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Setting transaction isolation level to " + level);
        }
        this.commit();
        try {
            switch (level) {
                default: {
                    throw new DbException(3, "" + level);
                }
                case 0: {
                    throw new DbException(3, "TRANSACTION_NONE");
                }
                case 1: {
                    this.database.setExecutionMode(3, 1L);
                    break;
                }
                case 2: {
                    this.database.setExecutionMode(3, 2L);
                    break;
                }
                case 4: {
                    this.database.setExecutionMode(3, 3L);
                    break;
                }
                case 8: {
                    throw new DbException(3, "TRANSACTION_SERIALIZABLE");
                }
            }
            this.isolation = level;
        }
        catch (CommException e) {
            this.markDirty(e);
            RPCStatus stat = e.getRPCStatus();
            if (stat != null) {
                throw new DbException(stat, e);
            }
            throw new DbException(e);
        }
    }

    synchronized void addWarning(SQLWarning w) {
        if (this.warnings == null) {
            this.warnings = w;
        } else {
            this.warnings.setNextWarning(w);
        }
    }

    void addWarning(RPCStatus status) {
        SQLWarning w = DbException.toWarning(status);
        if (w != null) {
            this.addWarning(w);
        }
    }

    String getURL() {
        return "jdbc:sun:hadb:" + this.user + "@" + this.hostlist;
    }

    protected void checkOpen() throws SQLException {
        if (this.user_close) {
            this.logger.fine("Operation attempted after application has called close");
            throw new DbException(4);
        }
        if (this.dirty) {
            this.logger.fine("Physical connection has been closed, initiating reconnect procedure");
            try {
                this.reconnect(this.endpoints, this.login_timeout, this.user, this.password);
            }
            catch (CommException e) {
                this.logger.fine("reconnect failed due to " + e.getErrorCode());
                RPCStatus stat = e.getRPCStatus();
                if (stat != null) {
                    throw new DbException(stat, e);
                }
                throw new DbException(e);
            }
            this.logger.fine("reconnect succeeded");
        }
        if (this.isClosed()) {
            throw new DbException(4);
        }
    }

    protected String getCurrentUser() throws SQLException {
        return this.user;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void markDirty(CommException e) {
        if (e != null) {
            switch (e.getErrorCode()) {
                case 25017: 
                case 25018: 
                case 25019: {
                    this.logger.log(Level.FINE, "dirty connection", e);
                    this.sigpstmtdirty();
                    this.dirty = true;
                    for (int retries = 0; this.dirty && retries < 1; ++retries) {
                        try {
                            this.logger.fine("reconnect due to " + e.getErrorCode());
                            this.reconnect(this.endpoints, this.login_timeout, this.user, this.password);
                            this.logger.fine("reconnect #" + retries + " succeeded");
                            continue;
                        }
                        catch (Exception a) {
                            this.logger.log(Level.FINE, "reconnect #" + retries + " failed", a);
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sigpstmtdirty() {
        WeakHashMap weakHashMap = this.pstmtmap;
        synchronized (weakHashMap) {
            Iterator it = this.pstmtmap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object obj = entry.getKey();
                if (obj == null) continue;
                this.markDirty((Statement)obj, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDirty(Statement stmt) {
        WeakHashMap weakHashMap = this.dirtymap;
        synchronized (weakHashMap) {
            boolean b = this.dirtymap.containsKey(stmt);
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markDirty(Statement stmt, boolean dirty_flag) {
        if (stmt != null) {
            WeakHashMap weakHashMap = this.dirtymap;
            synchronized (weakHashMap) {
                if (dirty_flag) {
                    this.dirtymap.put(stmt, new Object());
                } else {
                    this.dirtymap.remove(stmt);
                }
            }
        } else {
            this.logger.fine("ConnectionImpl.markDirty: was called with 'null' stmt");
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return new CallableStatementImpl(this, sql, resultSetType, resultSetConcurrency);
    }

    public synchronized Map getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    static Properties parseHostlist(String hostlist) throws SQLException {
        try {
            if (hostlist == null) {
                throw new DbException(18);
            }
            Properties p = new Properties();
            StringTokenizer t = new StringTokenizer(hostlist, ":,", false);
            int i = 0;
            while (t.hasMoreTokens()) {
                p.setProperty("host" + i, t.nextToken());
                String pns = t.nextToken();
                try {
                    int pn = Integer.parseInt(pns);
                }
                catch (NumberFormatException e) {
                    throw new DbException(18);
                }
                p.setProperty("port" + i, pns);
                ++i;
            }
            p.setProperty("noofhosts", "" + i);
            return p;
        }
        catch (NoSuchElementException e) {
            throw new DbException(18);
        }
    }

    public static String concatHostList(String server_name, int port_number, String server_list) {
        StringBuffer hostlist = new StringBuffer();
        if (server_list != null) {
            hostlist.append(server_list);
        }
        if (server_name != null && server_name.length() > 0) {
            if (server_list != null) {
                hostlist.append(',');
            }
            hostlist.append(server_name);
            hostlist.append(':');
            hostlist.append(port_number);
        }
        return hostlist.toString();
    }

    private synchronized void closeATreconnect() {
        if (this.poolStatements()) {
            this.pstmtpool.clearPool(false);
        }
        try {
            if (this.database != null) {
                this.database.close();
            }
        }
        catch (Exception e) {
            this.logger.fine("database.close() failed: " + e.toString());
        }
        this.database = null;
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            this.logger.fine("channel.close() failed: " + e.toString());
        }
        this.channel = null;
    }

    private void setConnectionAttributes() throws CommException, SQLException {
        try {
            long curschema;
            this.setReadOnly(this.readOnly);
            this.setTransactionIsolation(this.isolation);
            this.setAutoCommit(this.autoCommit);
            if (this.maxtransidle > 0) {
                this.database.setExecutionMode(12, this.maxtransidle);
            }
            if (this.locktimeout > 0) {
                this.database.setExecutionMode(13, this.locktimeout);
            }
            if ((curschema = this.getCurrentSchema()) != 0L) {
                String schema = this.database.getPathName(curschema);
                this.setSchema(schema);
            }
        }
        catch (CommException ce) {
            this.logger.fine("failed due to " + ce.getErrorCode());
            throw ce;
        }
    }

    private boolean reconnect(EndPoint[] endpoints, long timeout, String user, String password) throws CommException, SQLException {
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            sb.append("(Re)connect procedure started for user=").append(user).append("  hosts:");
            for (int i = 0; i < endpoints.length; ++i) {
                sb.append(endpoints[i].toString());
            }
            this.logger.fine(sb.toString());
        }
        this.closeATreconnect();
        try {
            this.channel = new CliChannel(endpoints, timeout);
        }
        catch (CommException e) {
            this.logger.fine("new CliChannel failed due to " + e.toString());
            throw e;
        }
        this.logger.fine("new CliChannel");
        InetSocketAddress isa = this.getServerAddress();
        if (isa != null) {
            this.logger.config("Connection established to node " + isa.toString());
        }
        try {
            this.database = this.channel.openDatabase(user, password, "", Driver.driverVersion);
            this.database.setEliminateRedundantEndTransaction(this.eliminateRedundantEndTransaction);
            this.database.setConnection(this);
        }
        catch (CommException ce) {
            this.logger.fine("reconnect failed due to " + ce.getErrorCode());
            this.closeATreconnect();
            this.dirty = true;
            RPCStatus status = ce.getRPCStatus();
            if (status != null) {
                DbException dbe = new DbException(status, ce);
                throw dbe;
            }
            throw ce;
        }
        this.logger.fine("openDatabase");
        this.dirty = false;
        try {
            this.setConnectionAttributes();
        }
        catch (CommException ce) {
            this.logger.fine("reconnect failed due to " + ce.getErrorCode());
            this.closeATreconnect();
            this.dirty = true;
            RPCStatus status = ce.getRPCStatus();
            if (status != null) {
                DbException dbe = new DbException(status, ce);
                throw dbe;
            }
            throw ce;
        }
        return true;
    }

    public CliDatabase getDatabase() throws SQLException {
        this.checkOpen();
        return this.database;
    }

    public CliChannel getCliChannel() throws SQLException {
        this.checkOpen();
        return this.channel;
    }

    public InetSocketAddress getServerAddress() {
        EndPoint end;
        SepChannel sep;
        RPCChannel rpc;
        if (this.channel != null && (rpc = this.channel.getRPCChannel()) != null && (sep = rpc.getSepChannel()) != null && (end = sep.getEndPoint()) != null) {
            InetSocketAddress sock = new InetSocketAddress(end.getAddress(), end.getPort());
            return sock;
        }
        return null;
    }

    private void setLogging(String loglevel, String logfile) {
        this.logger.warning("The loglevel/logfile properties are deprecated. Use Java Logging API instead.");
    }

    public void setHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 2: {
                break;
            }
            default: {
                throw new DbException(52);
            }
        }
    }

    public int getHoldability() throws SQLException {
        return 2;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new DbException(53);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw new DbException(53);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new DbException(53);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new DbException(53);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int holdability) throws SQLException {
        this.checkOpen();
        StatementImpl si = new StatementImpl(this, resultSetType, resultSetConcurrency, holdability);
        WeakHashMap weakHashMap = this.pstmtmap;
        synchronized (weakHashMap) {
            this.pstmtmap.put(si, new Object());
        }
        return si;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PreparedStatement prepareStatement(String query, int resultSetType, int resultSetConcurrency, int holdability) throws SQLException {
        boolean log = this.logger.isLoggable(Level.FINER);
        if (log) {
            this.logger.finer("SQL: " + query);
        }
        this.checkOpen();
        PreparedStatementImpl p = null;
        if (this.poolStatements()) {
            p = (PreparedStatementImpl)this.pstmtpool.getPooledStatement(query, this.getCurrentSchema());
        }
        if (p == null) {
            p = new PreparedStatementImpl(this, query, resultSetType, resultSetConcurrency, holdability);
            WeakHashMap weakHashMap = this.pstmtmap;
            synchronized (weakHashMap) {
                this.pstmtmap.put(p, new Object());
            }
        } else {
            if (log) {
                this.logger.finer("PreparedStatement found in statement cache");
            }
            p.fixAttributes(resultSetType, resultSetConcurrency, holdability);
        }
        return p;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.logger.finer("SQL: " + sql);
        DbException dbe = new DbException(2, "CallableStatement");
        this.logger.log(Level.FINE, "Method not implemented", dbe);
        throw dbe;
    }

    public PreparedStatement prepareStatement(String sql, int autogeneratedkeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    public void createLobTable(String schema, String mTable) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ");
        if (schema != null) {
            sb.append(schema);
            sb.append('.');
        }
        sb.append(mTable);
        sb.append(BlobTableSuffix);
        sb.append(" (");
        String[] pks = this.getPrimaryKeyString(schema, mTable);
        sb.append(pks[0]);
        sb.append(", ");
        sb.append("lob_seq_no INTEGER NOT NULL, lob_data VARBINARY(8000) ");
        sb.append(", CONSTRAINT pk PRIMARY KEY (");
        sb.append(pks[1]);
        sb.append(", lob_seq_no)");
        sb.append(")");
        if (this.clusteredblob) {
            sb.append(" PARTITIONKEYS ");
            sb.append(pks[2]);
        }
        this.logger.finer("createLobTable: " + sb.toString());
        Statement stmt = this.createStatement();
        stmt.executeUpdate(sb.toString());
        stmt.close();
    }

    public void dropLobTable(String schema, String mTable) throws SQLException {
        StringBuffer dropqry = new StringBuffer();
        dropqry.append("DROP TABLE ");
        if (schema != null) {
            dropqry.append(schema);
            dropqry.append('.');
        }
        dropqry.append(mTable);
        dropqry.append(BlobTableSuffix);
        this.logger.fine("dropLobTable: " + dropqry.toString());
        Statement stmt = this.createStatement();
        stmt.executeUpdate(dropqry.toString());
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareLobStatement(String query, LOBDescr lob_descr) throws SQLException {
        LobPrepStatement clpp = new LobPrepStatement(this, query, lob_descr);
        WeakHashMap weakHashMap = this.pstmtmap;
        synchronized (weakHashMap) {
            this.pstmtmap.put(clpp, new Object());
        }
        return clpp;
    }

    private String[] getPrimaryKeyString(String schema, String table) throws SQLException {
        DatabaseMetaDataImpl mdmd = this.metaData;
        ResultSet rs = mdmd.getExPrimaryKeys(null, schema, table);
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int keycount = 0;
        if (rs.next()) {
            sb.append(this.getColumnString(rs));
            sb2.append(rs.getString("column_name"));
            ++keycount;
            while (rs.next()) {
                sb.append(", ");
                sb.append(this.getColumnString(rs));
                sb2.append(", ");
                sb2.append(rs.getString("column_name"));
                ++keycount;
            }
        } else {
            throw new DbException(54, schema + '.' + table);
        }
        rs.close();
        mdmd = null;
        String[] sarr = new String[]{sb.toString(), sb2.toString(), "" + keycount};
        return sarr;
    }

    private String getColumnString(ResultSet rs) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append(rs.getString("column_name"));
        sb.append(' ');
        sb.append(rs.getString("type_name"));
        switch (rs.getInt("data_type")) {
            case -3: 
            case 1: 
            case 12: {
                sb.append('(');
                sb.append(rs.getInt("column_size"));
                sb.append(") ");
                break;
            }
            case 2: 
            case 3: {
                sb.append('(');
                sb.append(rs.getInt("column_size"));
                sb.append(", ");
                sb.append(rs.getInt("decimal_digits"));
                sb.append(") ");
            }
        }
        if (rs.getInt("nullable") == 0) {
            sb.append("NOT NULL ");
        }
        return sb.toString();
    }

    private void setSchema(String schema_name) throws SQLException {
        if (schema_name != null) {
            Statement stmt = this.createStatement();
            stmt.executeUpdate("SET SCHEMA " + schema_name);
            stmt.close();
        }
    }

    synchronized void setCurrentSchema(long schema) {
        this.currentSchema = schema;
    }

    synchronized long getCurrentSchema() {
        return this.currentSchema;
    }

    public synchronized void initializeStatementPool(int size) throws SQLException {
        if (this.pstmtpool == null && size > 0) {
            this.pstmtpool = new StatementPool(size);
        }
    }

    boolean poolStatements() {
        return this.pstmtpool != null;
    }

    void poolStatement(StatementImpl pstmt, String sql, long schema) throws SQLException {
        this.pstmtpool.addToPool(pstmt, sql, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePrepStatement(PreparedStatementImpl child) {
        if (this.pstmtmap != null) {
            WeakHashMap weakHashMap = this.pstmtmap;
            synchronized (weakHashMap) {
                this.pstmtmap.remove(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllCursors() {
        if (this.pstmtmap != null) {
            WeakHashMap weakHashMap = this.pstmtmap;
            synchronized (weakHashMap) {
                Set set = this.pstmtmap.entrySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Statement stmt = (Statement)entry.getKey();
                    if (!(stmt instanceof StatementImpl)) continue;
                    ((StatementImpl)stmt).closeCursor();
                }
            }
        }
    }
}

