/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.JdbcLogFactory;
import com.sun.hadb.jdbc.NumberParser;
import com.sun.hadb.jdbc.NumericColumn;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DecimalColumn
extends NumericColumn {
    protected int precision = 7;
    protected int scale = 1;
    private Logger logger = JdbcLogFactory.getJDBCLogger();
    boolean decimal;

    DecimalColumn(RPCAttrDescr att, int fieldNo, boolean decimal) throws SQLException {
        super(att, fieldNo);
        this.decimal = decimal;
        if (att != null) {
            this.precision = att.getPrecision();
            this.scale = att.getScale();
        }
    }

    int getExtSize() {
        return this.precision + 1;
    }

    int getColumnDisplaySize() {
        return this.precision + 2;
    }

    int getColumnType() {
        return this.decimal ? 3 : 2;
    }

    String getColumnTypeName() {
        return this.decimal ? "DECIMAL(" + this.precision + "," + this.scale + ")" : "NUMERIC";
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getField(this.fieldNo).getDecimal(0, r.getFieldSize(this.fieldNo), this.scale);
    }

    long getLong(Tuple r) throws SQLException {
        return (long)this.getDouble(r);
    }

    BigDecimal getBigDecimal(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return new BigDecimal(this.getString(r));
    }

    Number getNumber(Tuple r) throws SQLException {
        return this.checkCluNull(r) ? new BigDecimal(0.0) : this.getBigDecimal(r);
    }

    String getClassName() throws SQLException {
        return "java.math.BigDecimal";
    }

    void setNumber(ParameterTuple r, String s) throws SQLException {
        try {
            char[] buf = NumberParser.parse(s, this.precision, this.scale);
            int blen = buf.length;
            ExtData p = r.allocField(this.fieldNo, blen / 2);
            int offset = 0;
            for (int i = 0; i < blen; i += 2) {
                int val1 = buf[i] - 48;
                int val2 = buf[i + 1] - 48;
                if (val1 < 0 || val1 > 9 || val2 < 0 || val2 > 15) {
                    this.logger.finer("DecimalColumn.setNumber: '" + s + "' could not pass as decimal");
                    throw new DbException(8);
                }
                int nval = (val1 << 4) + val2;
                p.putUInt8(nval, offset++);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer("Putted hexString = " + p.toHexString());
            }
        }
        catch (NumberFormatException nfe) {
            DbException dbe = new DbException(8);
            dbe.initCause(nfe);
            throw dbe;
        }
        catch (ArithmeticException ae) {
            DbException dbe = new DbException(8);
            dbe.initCause(ae);
            throw dbe;
        }
    }

    void setNumber(ParameterTuple r, Number v) throws SQLException {
        if (v == null) {
            this.setNull(r, this.getColumnType());
        } else {
            this.setNumber(r, v.toString());
        }
    }

    public void setString(ParameterTuple r, String v) throws SQLException {
        if (v == null) {
            this.setNull(r, this.getColumnType());
        } else {
            this.setNumber(r, v);
        }
    }
}

