/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.MetaDataDump;
import com.sun.hadb.jdbc.Release;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Driver
implements java.sql.Driver {
    static Driver driver;
    private static final String URL_HEAD = "jdbc:sun:hadb:";
    static final int majorVersion;
    static final int minorVersion;
    static final String driverVersion;
    static final String driverName = "Sun Java System(tm) HADB JDBC 3.0 Type 4 Driver";
    protected static final int streamAscii = 1;
    protected static final int streamUnicode = 2;
    protected static final int streamBinary = 3;

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties p = Driver.parseURL(url, info);
        return new ConnectionImpl(p);
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.toLowerCase().startsWith(URL_HEAD);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties p = Driver.parseURL(url, info);
        DriverPropertyInfo hostList = new DriverPropertyInfo("hostlist", p.getProperty("hostlist"));
        hostList.required = true;
        hostList.description = "Comma-separated list of host:port, e.g. ahost:1234,bhost:1235";
        DriverPropertyInfo user = new DriverPropertyInfo("user", p.getProperty("user"));
        user.required = true;
        user.description = "Database user name";
        DriverPropertyInfo password = new DriverPropertyInfo("password", p.getProperty("password"));
        password.required = true;
        password.description = "Password for authentication";
        DriverPropertyInfo reconnect = new DriverPropertyInfo("reconnect", p.getProperty("reconnect"));
        reconnect.required = false;
        reconnect.description = "Automatic reconnection";
        String[] choices = new String[]{new String("false"), new String("true")};
        reconnect.choices = choices;
        DriverPropertyInfo maxtransidle = new DriverPropertyInfo("maxtransidle", p.getProperty("maxtransidle"));
        maxtransidle.required = false;
        maxtransidle.description = "Transaction timeout";
        DriverPropertyInfo locktimeout = new DriverPropertyInfo("locktimeout", p.getProperty("locktimeout"));
        locktimeout.required = false;
        locktimeout.description = "Lock timeout";
        DriverPropertyInfo loglevel = new DriverPropertyInfo("loglevel", p.getProperty("loglevel"));
        loglevel.required = false;
        loglevel.description = "Trace level. values= OFF, SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST, ALL";
        DriverPropertyInfo logfile = new DriverPropertyInfo("loglevel", p.getProperty("logfile"));
        loglevel.required = false;
        loglevel.description = "File name for logging output";
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[]{hostList, user, password, reconnect, maxtransidle, locktimeout, loglevel, logfile};
        return dpi;
    }

    public int getMajorVersion() {
        return majorVersion;
    }

    public int getMinorVersion() {
        return minorVersion;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    private static Properties parseURL(String url, Properties info) throws SQLException {
        try {
            Properties p = new Properties(info);
            String rest_of_url = url.substring(URL_HEAD.length());
            if (rest_of_url.length() > 0) {
                StringTokenizer t = new StringTokenizer(rest_of_url, "@", true);
                String hostpart = null;
                String userpart = null;
                switch (t.countTokens()) {
                    case 1: {
                        if (rest_of_url.equals("@")) break;
                        hostpart = rest_of_url;
                        break;
                    }
                    case 2: {
                        String first = t.nextToken();
                        if (first.equals("@")) {
                            hostpart = t.nextToken();
                            break;
                        }
                        userpart = first;
                        break;
                    }
                    case 3: {
                        userpart = t.nextToken();
                        t.nextToken();
                        hostpart = t.nextToken();
                        break;
                    }
                    default: {
                        throw new DbException(18);
                    }
                }
                if (userpart != null) {
                    t = new StringTokenizer(userpart, "+", false);
                    switch (t.countTokens()) {
                        case 1: {
                            p.setProperty("user", t.nextToken());
                            break;
                        }
                        case 2: {
                            p.setProperty("user", t.nextToken());
                            p.setProperty("password", t.nextToken());
                            break;
                        }
                        default: {
                            throw new DbException(18);
                        }
                    }
                }
                if (hostpart != null) {
                    StringTokenizer ht = new StringTokenizer(hostpart, ";=", true);
                    if (ht.countTokens() == 1) {
                        p.setProperty("hostlist", hostpart);
                    } else {
                        String n = ht.nextToken();
                        if (!n.equals(";")) {
                            p.setProperty("hostlist", n);
                            n = ht.nextToken();
                        }
                        while (ht.hasMoreTokens()) {
                            if (!n.equals(";")) {
                                throw new DbException(18);
                            }
                            String name = ht.nextToken().toLowerCase();
                            if (!ht.nextToken().equals("=")) {
                                throw new DbException(18);
                            }
                            String value = ht.nextToken().toLowerCase();
                            p.setProperty(name, value);
                            if (!ht.hasMoreTokens()) continue;
                            n = ht.nextToken();
                        }
                    }
                }
            }
            return p;
        }
        catch (NoSuchElementException e) {
            throw new DbException(18, e);
        }
    }

    private static void usageAndExit() {
        System.out.println("Usage: com.sun.hadb.jdbc.Driver -options");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -version     Display driver version");
        System.out.println("    -sysprop     Display all system properties");
        System.out.println("    -errors      List all JDBC error codes");
        System.out.println("    -parse url   Parse the specified url");
        System.out.println("    -metadata url Display metadata");
        System.exit(0);
    }

    private static void parse(String url) {
        try {
            if (!driver.acceptsURL(url)) {
                throw new DbException(18);
            }
            Properties p = Driver.parseURL(url, null);
            p.list(System.out);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void metaPrint(PrintWriter printWrt, String url) {
        MetaDataDump metaDump = new MetaDataDump(url);
        metaDump.dumpMeta(printWrt);
    }

    static String repeatChar(char c, int n) {
        if (n > 0) {
            StringBuffer sb = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                sb.append(c);
            }
            return sb.toString();
        }
        return "";
    }

    static String padString(String str, int len) {
        return Driver.repeatChar(' ', len - str.length()) + str;
    }

    static String fixedLengthString(String str, int len) {
        int slen = str.length();
        if (slen == len) {
            return str;
        }
        if (slen > len) {
            return str.substring(0, len);
        }
        return str + Driver.repeatChar(' ', len - slen);
    }

    static String getSWLZ(long l, int len) {
        String str = Long.toString(l);
        if (str.length() < len) {
            int pads = len - str.length();
            char[] pad = new char[pads];
            for (int i = 0; i < pads; ++i) {
                pad[i] = 48;
            }
            str = new String(pad) + str;
        }
        return str;
    }

    static int nrOfWords(int nrOfBytes) {
        return (nrOfBytes + 3) / 4;
    }

    static int nrOfBytes(int nrOfWords) {
        return nrOfWords * 4;
    }

    static void printVersion(PrintStream s) {
        s.println(driverName);
        s.println("Version " + driverVersion + " (" + majorVersion + "." + minorVersion + "/" + Release.getReleaseComment() + ")");
        s.println("        " + Release.getReleaseData());
        s.println();
        s.println(Release.getCopyright());
    }

    static void mimerGetBytes(String str, int srcBegin, int srcEnd, byte[] dst, int dstBegin) throws SQLException {
        int len = srcEnd - srcBegin;
        char[] c = new char[len];
        int cm = 65280;
        str.getChars(srcBegin, srcEnd, c, 0);
        for (int i = 0; i < len; ++i) {
            if ((c[i] & cm) != 0) {
                throw new DbException(35);
            }
            dst[dstBegin + i] = (byte)c[i];
        }
    }

    static byte[] mimerGetBytes(String str) throws SQLException {
        int slen = str.length();
        byte[] b = new byte[slen];
        Driver.mimerGetBytes(str, 0, slen, b, 0);
        return b;
    }

    public static void main(String[] arg) {
        boolean version = false;
        boolean errors = false;
        boolean sysprop = false;
        String parseUrl = "";
        String metaDataUrl = "";
        for (int a = 0; a < arg.length; ++a) {
            if (arg[a].equalsIgnoreCase("-version")) {
                version = true;
                continue;
            }
            if (arg[a].equalsIgnoreCase("-sysprop")) {
                sysprop = true;
                continue;
            }
            if (arg[a].equalsIgnoreCase("-errors")) {
                errors = true;
                continue;
            }
            if (arg[a].equalsIgnoreCase("-parse")) {
                if (++a < arg.length) {
                    parseUrl = arg[a];
                    continue;
                }
                System.out.println("-parse: missing url argument");
                Driver.usageAndExit();
                continue;
            }
            if (arg[a].equalsIgnoreCase("-metadata")) {
                if (++a < arg.length) {
                    metaDataUrl = arg[a];
                    continue;
                }
                System.out.println("-metadata: missing url argument");
                Driver.usageAndExit();
                continue;
            }
            System.out.println(arg[a] + ": illegal argument");
            Driver.usageAndExit();
        }
        if (!(version || errors || sysprop || parseUrl.length() != 0 || metaDataUrl.length() != 0)) {
            Driver.usageAndExit();
        }
        if (version) {
            Driver.printVersion(System.out);
        }
        if (sysprop) {
            System.getProperties().list(System.out);
        }
        if (errors) {
            DbException.listExceptions(System.out);
        }
        if (parseUrl.length() > 0) {
            Driver.parse(parseUrl);
        }
        if (metaDataUrl.length() > 0) {
            Driver.metaPrint(new PrintWriter(System.out), metaDataUrl);
        }
    }

    static {
        DriverManager.println("Driver class loaded");
        driver = new Driver();
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException ex) {
            DriverManager.println("Unable to register driver: " + ex.getMessage());
        }
        majorVersion = Release.getReleaseN1();
        minorVersion = Release.getReleaseN4() + Release.getReleaseN3() * 100 + Release.getReleaseN2() * 10000;
        driverVersion = majorVersion + "." + Release.getReleaseN2() + "." + Release.getReleaseN3() + "." + Release.getReleaseN4();
    }
}

