/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.NumericColumn;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class IntervalColumn
extends NumericColumn {
    private int type;
    private static final int TRAIL_SECOND = 1;
    private static final int TRAIL_MINUTE = 2;
    private static final int TRAIL_HOUR = 3;
    private static final int TRAIL_DAY = 4;
    private static long MAXVALUE;

    IntervalColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
        this.type = att.getDateTimeType();
        MAXVALUE = 0L;
    }

    public String toString() {
        return super.toString() + "\nLeading prec.   : " + this.att.getIntervalLeadingPrecision() + "\nMAXVALUE        : " + MAXVALUE;
    }

    private void calcMaxValue() throws SQLException {
        int prec = this.att.getIntervalLeadingPrecision();
        long lead = 0L;
        MAXVALUE = 0L;
        for (int i = 0; i < prec; ++i) {
            lead += 9L * (long)Math.pow(10.0, i);
        }
        switch (this.type) {
            case 15872: 
            case 16128: {
                MAXVALUE = lead * 12L + 11L;
                break;
            }
            case 13824: {
                MAXVALUE = lead;
                break;
            }
            case 10752: {
                MAXVALUE = 59999999L;
            }
            case 11008: {
                MAXVALUE += 3540000000L;
            }
            case 11264: {
                MAXVALUE += 82800000000L;
            }
            case 11520: {
                MAXVALUE += lead * 1000000L * 60L * 60L * 24L;
                break;
            }
            case 8704: {
                MAXVALUE = 59999999L;
            }
            case 8960: {
                MAXVALUE += 3540000000L;
            }
            case 9216: {
                MAXVALUE += lead * 1000000L * 60L * 60L;
                break;
            }
            case 4608: {
                MAXVALUE = lead * 1000000L + 999999L;
                break;
            }
            case 6656: {
                MAXVALUE = 59999999L;
            }
            case 6912: {
                MAXVALUE += lead * 1000000L * 60L;
                break;
            }
            default: {
                throw new DbException(1, "Invalid interval type");
            }
        }
    }

    int getExtSize() {
        switch (this.type) {
            case 13824: 
            case 15872: 
            case 16128: {
                return 4;
            }
        }
        return 8;
    }

    int getColumnDisplaySize() throws SQLException {
        boolean cds = false;
        switch (this.type) {
            case 15872: {
                return 7;
            }
            case 11264: {
                return 5;
            }
            case 11008: {
                return 8;
            }
            case 10752: {
                return 19;
            }
            case 8960: {
                return 5;
            }
            case 8704: {
                return 16;
            }
            case 6656: {
                return 13;
            }
            case 4608: {
                return 9;
            }
        }
        return 4;
    }

    private String getSeconds(long val) {
        long seconds = val / 1000000L;
        long microseconds = val % 1000000L;
        if (microseconds == 0L) {
            return Long.toString(seconds);
        }
        String m = Long.toString(microseconds);
        int i = 0;
        while (m.length() < 6) {
            m = "0" + m;
            ++i;
        }
        return seconds > 9L ? Long.toString(seconds) + "." + m : "0" + Long.toString(seconds) + "." + m;
    }

    private String getMinutes(long val, int trail) {
        long tot_seconds = val / 1000000L;
        long minutes = tot_seconds / 60L;
        String m = minutes > 9L ? Long.toString(minutes) : "0" + Long.toString(minutes);
        return trail < 2 ? m + ":" + this.getSeconds(val - minutes * 60L * 1000000L) : m;
    }

    private String getHours(long val, int trail) {
        long tot_minutes = val / 60000000L;
        long hours = tot_minutes / 60L;
        String m = hours > 9L ? Long.toString(hours) : "0" + Long.toString(hours);
        return trail < 3 ? m + ":" + this.getMinutes(val - hours * 60L * 60L * 1000000L, trail) : m;
    }

    private String getDays(long val, int trail) {
        long tot_hours = val / 3600000000L;
        long days = tot_hours / 24L;
        String m = Long.toString(days);
        return trail < 4 ? m + " " + this.getHours(val - days * 24L * 60L * 60L * 1000000L, trail) : m;
    }

    private long getIntervalValue(String str) throws SQLException {
        String[] retstr = new String[7];
        StringTokenizer st = new StringTokenizer(str, " -:.", true);
        try {
            String s1 = st.nextToken();
            switch (this.type) {
                case 16128: {
                    retstr[0] = s1;
                    break;
                }
                case 13824: {
                    retstr[1] = s1;
                    break;
                }
                case 11520: {
                    retstr[2] = s1;
                    break;
                }
                case 9216: {
                    retstr[3] = s1;
                    break;
                }
                case 6912: {
                    retstr[4] = s1;
                    break;
                }
                case 4608: {
                    if (!st.hasMoreTokens()) break;
                    if (!st.nextToken().equals(".")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[5] = s1;
                    retstr[6] = st.nextToken();
                    break;
                }
                case 15872: {
                    if (!st.nextToken().equals("-")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[0] = s1;
                    retstr[1] = st.nextToken();
                    break;
                }
                case 11264: {
                    if (!st.nextToken().equals(" ")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[2] = s1;
                    retstr[3] = st.nextToken();
                    break;
                }
                case 11008: {
                    if (!st.nextToken().equals(" ")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[2] = s1;
                    retstr[3] = st.nextToken();
                    if (!st.nextToken().equals(":")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[4] = st.nextToken();
                    break;
                }
                case 10752: {
                    if (!st.nextToken().equals(" ")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[2] = s1;
                    retstr[3] = st.nextToken();
                    if (!st.nextToken().equals(":")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[4] = st.nextToken();
                    if (!st.nextToken().equals(":")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[5] = st.nextToken();
                    if (!st.hasMoreTokens()) break;
                    if (!st.nextToken().equals(".")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[6] = st.nextToken();
                    break;
                }
                case 8960: {
                    if (!st.nextToken().equals(":")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[3] = s1;
                    retstr[4] = st.nextToken();
                    break;
                }
                case 8704: {
                    if (!st.nextToken().equals(":")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[3] = s1;
                    retstr[4] = st.nextToken();
                    if (!st.nextToken().equals(":")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[5] = st.nextToken();
                    if (!st.hasMoreTokens()) break;
                    if (!st.nextToken().equals(".")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[6] = st.nextToken();
                    break;
                }
                case 6656: {
                    if (!st.nextToken().equals(":")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[4] = s1;
                    retstr[5] = st.nextToken();
                    if (!st.hasMoreTokens()) break;
                    if (!st.nextToken().equals(".")) {
                        throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
                    }
                    retstr[6] = st.nextToken();
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
        }
        if (st.hasMoreTokens()) {
            throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
        }
        long value = 0L;
        value += retstr[0] != null ? new Long(retstr[0]) * 12L : 0L;
        value += retstr[1] != null ? new Long(retstr[1]) : 0L;
        value += retstr[2] != null ? new Long(retstr[2]) * 1000000L * 60L * 60L * 24L : 0L;
        value += retstr[3] != null ? new Long(retstr[3]) * 1000000L * 60L * 60L : 0L;
        value += retstr[4] != null ? new Long(retstr[4]) * 1000000L * 60L : 0L;
        value += retstr[5] != null ? new Long(retstr[5]) * 1000000L : 0L;
        return value += retstr[6] != null ? new Long(retstr[6]) : 0L;
    }

    private String getIntervalString(long val) throws SQLException {
        switch (this.type) {
            case 16128: {
                return Long.toString(val / 12L);
            }
            case 15872: {
                return Long.toString(val / 12L) + "-" + Long.toString(val % 12L);
            }
            case 13824: {
                return Long.toString(val);
            }
            case 11520: {
                long day = val / 86400000000L;
                return Long.toString(day);
            }
            case 11264: {
                return this.getDays(val, 3);
            }
            case 11008: {
                return this.getDays(val, 2);
            }
            case 10752: {
                return this.getDays(val, 1);
            }
            case 9216: {
                return Long.toString(val / 3600000000L);
            }
            case 8960: {
                return this.getHours(val, 2);
            }
            case 8704: {
                return this.getHours(val, 1);
            }
            case 6912: {
                return Long.toString(val / 60000000L);
            }
            case 6656: {
                return this.getMinutes(val, 1);
            }
            case 4608: {
                return this.getSeconds(val);
            }
        }
        throw new DbException(1, "Invalid interval type");
    }

    int getColumnType() throws SQLException {
        switch (this.type) {
            case 16128: {
                return 101;
            }
            case 13824: {
                return 102;
            }
            case 11520: {
                return 103;
            }
            case 9216: {
                return 104;
            }
            case 6912: {
                return 105;
            }
            case 4608: {
                return 106;
            }
            case 15872: {
                return 107;
            }
            case 11264: {
                return 108;
            }
            case 11008: {
                return 109;
            }
            case 10752: {
                return 110;
            }
            case 8960: {
                return 111;
            }
            case 8704: {
                return 112;
            }
            case 6656: {
                return 113;
            }
        }
        throw new DbException(1, "type value = " + this.type);
    }

    String getColumnTypeName() throws SQLException {
        String str = "INTERVAL ";
        switch (this.type) {
            case 16128: {
                str = str + "YEAR";
                break;
            }
            case 13824: {
                str = str + "MONTH";
                break;
            }
            case 11520: {
                str = str + "DAY";
                break;
            }
            case 9216: {
                str = str + "HOUR";
                break;
            }
            case 6912: {
                str = str + "MINUTE";
                break;
            }
            case 4608: {
                str = str + "SECOND";
                break;
            }
            case 15872: {
                str = str + "YEAR TO MONTH";
                break;
            }
            case 11264: {
                str = str + "DAY TO HOUR";
                break;
            }
            case 11008: {
                str = str + "DAY TO MINUTE";
                break;
            }
            case 10752: {
                str = str + "DAY TO SECOND";
                break;
            }
            case 8960: {
                str = str + "HOUR TO MINUTE";
                break;
            }
            case 8704: {
                str = str + "HOUR TO SECOND";
                break;
            }
            case 6656: {
                str = str + "MINUTE TO SECOND";
                break;
            }
            default: {
                throw new DbException(1, "Invalid interval type (type=" + this.type + ")");
            }
        }
        return str;
    }

    Object getObject(Tuple r) throws SQLException {
        return this.getString(r);
    }

    String getClassName() throws SQLException {
        return "java.lang.String";
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return this.getIntervalString(this.getLong(r));
    }

    void setObject(ParameterTuple r, Object obj) throws SQLException {
        if (obj == null) {
            this.setNull(r, this.getColumnType());
        } else if (obj instanceof Number) {
            this.setNumber(r, (Number)obj);
        } else {
            this.setString(r, obj.toString());
        }
    }

    void setNumber(ParameterTuple r, Number s) throws SQLException {
        if (s == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        if (MAXVALUE == 0L) {
            this.calcMaxValue();
        }
        if (Math.abs(s.longValue()) > MAXVALUE) {
            throw new DbException(34);
        }
        super.setNumber(r, s);
    }

    public void setString(ParameterTuple r, String str) throws SQLException {
        if (str == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        long value = this.getIntervalValue(str);
        String comparestr = this.getIntervalString(value);
        long comparevalue = this.getIntervalValue(comparestr);
        if (comparevalue != value) {
            throw new DbException(6, "'" + str + "' not a valid " + this.getColumnTypeName());
        }
        this.setNumber(r, new Long(value));
    }

    public static void main(String[] args) {
        try {
            IntervalColumn c1 = new IntervalColumn(null, 0);
            IntervalColumn c2 = new IntervalColumn(null, 1);
            ExtData p = new ExtData(new MessageBuffer(20));
            p.putInt8((byte)-1, 0);
            p.putInt8((byte)0, 1);
            p.putInt16((short)8, 2);
            p.putInt16((short)16, 4);
            p.putInt16((short)20, 6);
            long val = 288007530999999L;
            p.putInt64(val, 8);
            p.putInt32(21611, 16);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

