/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunkByteArray;

class LobFragment {
    public static final int FRG_UNDEFINED = 0;
    public static final int FRG_DATA = 1;
    public static final int FRG_LOCATOR = 2;
    public static final int FRG_ENDOFLOB = 240;
    private static final int OFF_FRAGTYPE = 0;
    private static final int OFF_LOBNO = 4;
    private static final int OFF_FRAGSIZE = 8;
    private static final int HDR_HEADERSIZE = 12;
    private ExtData p = null;
    private int lobno;
    private byte[] fragdata;
    private int fragtype;

    public LobFragment(ExtData ed) {
        this.p = ed;
    }

    public LobFragment(int lobno, byte[] barr) {
        this.lobno = lobno;
        this.fragdata = barr;
    }

    public long size() {
        return this.dataSize() + this.headerSize();
    }

    public int headerSize() {
        return 12;
    }

    public int dataSize() {
        if (this.p != null) {
            return this.p.getInt32(8);
        }
        return this.fragdata.length;
    }

    public int getLobNo() {
        if (this.p != null) {
            return this.p.getInt32(4);
        }
        return this.lobno;
    }

    public int getFragType() {
        if (this.p != null) {
            return this.p.getInt32(0);
        }
        return this.fragtype;
    }

    public boolean isEOL() {
        return (this.getFragType() & 0xF0) != 0;
    }

    public void setEOL() {
        this.fragtype |= 0xF0;
    }

    public boolean isLocator() {
        return (this.getFragType() & 2) != 0;
    }

    public void setLocator() {
        this.fragtype |= 2;
    }

    public boolean isData() {
        return (this.getFragType() & 1) != 0;
    }

    public void setData() {
        this.fragtype |= 1;
    }

    public byte[] getData() {
        if (this.p != null) {
            int ds = this.dataSize();
            byte[] out = this.p.getBytes(12, ds);
            return out;
        }
        return this.fragdata;
    }

    public MessageBuffer asMessageBuffer() {
        MessageBuffer buf = new MessageBuffer();
        MessageChunkByteArray chunk = new MessageChunkByteArray();
        chunk.appendUInt32(0L);
        chunk.appendUInt32(0L);
        chunk.appendUInt32(0L);
        ExtData e = chunk.getAsExtData();
        e.putInt32(this.getFragType(), 0);
        e.putInt32(this.getLobNo(), 4);
        e.putInt32(this.dataSize(), 8);
        buf.append(chunk);
        buf.append(new MessageChunkByteArray(this.getData()));
        return buf;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("lobno=").append(this.getLobNo());
        sb.append(" fragtype=").append(this.getFragType()).append(' ');
        if (this.isLocator()) {
            sb.append("LOCATOR ");
        }
        if (this.isData()) {
            sb.append("DATA ");
        }
        if (this.isEOL()) {
            sb.append("EOL ");
        }
        sb.append(" datasize=").append(this.dataSize());
        return sb.toString();
    }
}

