/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.jdbc.LobFragment;
import java.util.Vector;

public class LobFrame {
    private static final int FRAME_HEADER_SIZE = 8;
    private int fragment_count;
    private Vector fragments;
    private int frame_size;
    private ExtData p;

    public LobFrame(ExtData p) {
        this.p = p;
        this.fragments = new Vector();
        long totfrag = p.getInt32(4);
        int acc_size = 4;
        while ((long)acc_size < totfrag) {
            ExtData fa = new ExtData(p, acc_size + 4);
            LobFragment fragment = new LobFragment(fa);
            acc_size = (int)((long)acc_size + fragment.size());
            this.fragments.add(fragment);
        }
    }

    public LobFrame() {
        this.p = null;
        this.fragments = new Vector();
    }

    public int size() {
        if (this.p != null) {
            return this.p.getInt32(4) + 4;
        }
        int fsize = 8;
        for (int i = 0; i < this.getFragmentCount(); ++i) {
            LobFragment frag = this.getFragment(i);
            fsize = (int)((long)fsize + frag.size());
        }
        return fsize;
    }

    public int getFragmentCount() {
        return this.fragments.size();
    }

    public LobFragment getFragment(int index) {
        if (index < 0 || index >= this.fragments.size()) {
            return null;
        }
        return (LobFragment)this.fragments.elementAt(index);
    }

    public MessageBuffer asMessageBuffer() {
        MessageBuffer buf = new MessageBuffer();
        MessageChunkByteArray chunk = new MessageChunkByteArray();
        long fragsize = 0L;
        for (int i = 0; i < this.fragments.size(); ++i) {
            LobFragment frag = (LobFragment)this.fragments.elementAt(i);
            fragsize += frag.size();
        }
        chunk.appendUInt32(fragsize + 4L);
        chunk.appendUInt32(0L);
        ExtData p = chunk.getAsExtData();
        buf.append(chunk);
        for (int i = 0; i < this.fragments.size(); ++i) {
            LobFragment frag = (LobFragment)this.fragments.elementAt(i);
            buf.append(frag.asMessageBuffer());
        }
        p.putInt32((int)fragsize + 4, 4);
        return buf;
    }

    public void addFragment(LobFragment frag) {
        this.fragments.add(frag);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LobFrame: fragment count=").append(this.getFragmentCount());
        sb.append(" size=").append(this.size()).append('\n');
        for (int i = 0; i < this.getFragmentCount(); ++i) {
            sb.append("  Frag.").append(i).append(' ');
            sb.append(this.getFragment(i).toString());
            sb.append('\n');
        }
        return sb.toString();
    }
}

