/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.KeyDescr;
import com.sun.hadb.jdbc.LOBDescr;
import com.sun.hadb.jdbc.LobResultSet;
import com.sun.hadb.jdbc.PreparedStatementImpl;
import com.sun.hadb.jdbc.StatementImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class LobPrepStatement
implements PreparedStatement {
    private static final int MAXBATCHSIZE = StatementImpl.MAX_BATCHED_DATA_SIZE;
    private static final int VARBINSIZE = 7000;
    private static final int BATCHELECOUNT = MAXBATCHSIZE / 7000;
    private static final int MAX_NUMBER_OF_PARAMETERS = 30;
    private PreparedStatementImpl mps;
    private PreparedStatement ins_lpstmt;
    private PreparedStatement del_lpstmt;
    private PreparedStatement sel_lpstmt;
    private PreparedStatement upd_lpstmt;
    private PreparedStatement ins_lpstmt_long;
    private PreparedStatement upd_lpstmt_long;
    private ConnectionImpl con;
    private LOBDescr lob_descr;
    private int lob_column_index;
    private Object[] par_array;
    private Query query;
    private int query_type;
    private boolean running_optimized = false;
    private LobExecutor sourceobj;

    public LobPrepStatement(ConnectionImpl con, String querystr, LOBDescr lob_descr) throws SQLException {
        this.con = con;
        this.lob_descr = lob_descr;
        this.query = new Query(querystr);
        this.par_array = new Object[30];
        for (int i = 0; i < this.par_array.length; ++i) {
            this.par_array[i] = null;
        }
        if (!this.query.isMultipleStatements()) {
            int qtype = this.query.getQueryType();
            if (qtype == 2) {
                this.prepareOptimized();
            } else if (qtype == 4) {
                this.prepareOptimized();
            } else {
                this.prepareSimple();
            }
        } else {
            this.prepareSimple();
        }
    }

    private void prepareSimple() throws SQLException {
        String ins_query = null;
        String del_query = null;
        String sel_query = null;
        String upd_query = null;
        Object valuestr = null;
        this.mps = (PreparedStatementImpl)this.con.prepareStatement(this.query.getQuery());
        this.query_type = this.mps.getPrepareDescr().getPrep(0).getQryType();
        switch (this.query_type) {
            case 1: {
                sel_query = LobPrepStatement.getSelectQuery(this.lob_descr);
                break;
            }
            case 2: {
                ins_query = LobPrepStatement.getInsertQuery(this.lob_descr);
                upd_query = LobPrepStatement.getUpdateQuery(this.lob_descr);
                break;
            }
            case 3: {
                del_query = LobPrepStatement.getDeleteQuery(this.lob_descr);
                break;
            }
            case 4: {
                del_query = LobPrepStatement.getDeleteQuery(this.lob_descr);
                ins_query = LobPrepStatement.getInsertQuery(this.lob_descr);
                break;
            }
        }
        this.upd_lpstmt = null;
        this.sel_lpstmt = null;
        this.del_lpstmt = null;
        this.ins_lpstmt = null;
        if (sel_query != null) {
            this.sel_lpstmt = this.con.prepareStatement(sel_query);
        }
        if (del_query != null) {
            this.del_lpstmt = this.con.prepareStatement(del_query);
        }
        if (ins_query != null) {
            this.ins_lpstmt = this.con.prepareStatement(ins_query);
        }
        if (upd_query != null) {
            this.upd_lpstmt = this.con.prepareStatement(upd_query);
        }
    }

    private void prepareOptimized() throws SQLException {
        int qtype;
        this.running_optimized = true;
        StringBuffer sb = new StringBuffer();
        this.query_type = qtype = this.query.getQueryType();
        switch (qtype) {
            case 2: {
                sb.append(this.query.toString());
                sb.append("; ");
                sb.append(LobPrepStatement.getInsertQuery(this.lob_descr));
                this.mps = (PreparedStatementImpl)this.con.prepareStatement(sb.toString());
                break;
            }
            case 4: {
                sb.append(this.query.toString());
                sb.append("; ");
                sb.append(LobPrepStatement.getDeleteQuery(this.lob_descr));
                sb.append("; ");
                sb.append(LobPrepStatement.getInsertQuery(this.lob_descr));
                this.mps = (PreparedStatementImpl)this.con.prepareStatement(sb.toString());
                break;
            }
            default: {
                this.prepareSimple();
            }
        }
    }

    public void close() throws SQLException {
        if (this.ins_lpstmt != null) {
            this.ins_lpstmt.close();
        }
        if (this.del_lpstmt != null) {
            this.del_lpstmt.close();
        }
        if (this.sel_lpstmt != null) {
            this.sel_lpstmt.close();
        }
        if (this.upd_lpstmt != null) {
            this.upd_lpstmt.close();
        }
        if (this.ins_lpstmt_long != null) {
            this.ins_lpstmt_long.close();
        }
        if (this.upd_lpstmt_long != null) {
            this.upd_lpstmt_long.close();
        }
        if (this.mps != null) {
            this.mps.close();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.mps.getMaxFieldSize();
    }

    public void setMaxFieldSize(int size) throws SQLException {
        this.mps.setMaxFieldSize(size);
    }

    public void addBatch(String query) throws SQLException {
        throw new DbException(57);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkLobConState();
        ResultSet rs = this.mps.executeQuery();
        if (rs == null) {
            return null;
        }
        LobResultSet clrs = new LobResultSet(rs, this.lob_descr, this.sel_lpstmt);
        return clrs;
    }

    public synchronized int executeUpdate() throws SQLException {
        long size;
        block11: {
            block10: {
                size = 0L;
                this.checkLobConState();
                if (!this.running_optimized) break block10;
                switch (this.query_type) {
                    case 4: {
                        size = this.doUpdateOpt(this.lob_descr);
                        break block11;
                    }
                    case 3: {
                        size = this.doDeleteOpt(this.lob_descr);
                        break block11;
                    }
                    case 2: {
                        size = this.doInsertOpt(this.lob_descr);
                        break block11;
                    }
                    default: {
                        throw new DbException(57);
                    }
                }
            }
            switch (this.query_type) {
                case 4: {
                    size = this.doUpdate(this.lob_descr);
                    break;
                }
                case 3: {
                    size = this.doDelete(this.lob_descr);
                    break;
                }
                case 2: {
                    size = this.doInsert(this.lob_descr);
                    break;
                }
                default: {
                    throw new DbException(57);
                }
            }
        }
        return (int)size;
    }

    public int executeUpdate(String query) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public ResultSet executeQuery(String query) throws SQLException {
        this.checkLobConState();
        throw new DbException(57);
    }

    public void addBatch() throws SQLException {
        this.checkLobConState();
        throw new DbException(55);
    }

    public synchronized void clearParameters() throws SQLException {
        this.sourceobj = null;
        this.mps.clearParameters();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.mps.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.mps.getParameterMetaData();
    }

    public void setArray(int i, Array x) throws SQLException {
        if (this.isLobColumn(i)) {
            throw new DbException(56);
        }
        this.mps.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.sourceobj = new LobAsciiStream(x, length);
        } else {
            this.mps.setAsciiStream(parameterIndex, x, length);
        }
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setBigDecimal(parameterIndex, x);
    }

    public synchronized void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.sourceobj = new LobBinaryStream(x, length);
        } else {
            this.mps.setBinaryStream(parameterIndex, x, length);
        }
    }

    public synchronized void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.sourceobj = new LobBlob(x);
        } else {
            this.mps.setBlob(parameterIndex, x);
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            byte[] a = new byte[]{x};
            this.setBytes(parameterIndex, a);
        } else {
            this.mps.setByte(parameterIndex, x);
        }
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(x), x.length);
        } else {
            this.mps.setBytes(parameterIndex, x);
        }
    }

    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.sourceobj = new LobCharacterStream(reader, length);
        } else {
            this.mps.setCharacterStream(parameterIndex, reader, length);
        }
    }

    public synchronized void setClob(int i, Clob x) throws SQLException {
        if (this.isLobColumn(i)) {
            this.sourceobj = new LobClob(x);
        } else {
            this.mps.setClob(i, x);
        }
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setDouble(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setInt(parameterIndex, x);
        this.par_array[parameterIndex - 1] = new Integer(x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setLong(parameterIndex, x);
        this.par_array[parameterIndex - 1] = new Long(x);
    }

    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.sourceobj = null;
        } else {
            this.mps.setNull(parameterIndex, sqlType);
            this.par_array[parameterIndex - 1] = null;
        }
    }

    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.sourceobj = null;
        } else {
            this.mps.setNull(parameterIndex, sqlType, typeName);
            this.par_array[parameterIndex - 1] = null;
        }
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setObject(parameterIndex, x);
        this.par_array[parameterIndex - 1] = x;
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setObject(parameterIndex, x, targetSqlType);
        this.par_array[parameterIndex - 1] = x;
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setObject(parameterIndex, x, targetSqlType, scale);
        this.par_array[parameterIndex - 1] = x;
    }

    public void setRef(int i, Ref x) throws SQLException {
        if (this.isLobColumn(i)) {
            throw new DbException(56);
        }
        this.mps.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setString(parameterIndex, x);
        this.par_array[parameterIndex - 1] = x;
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setTimestamp(parameterIndex, x);
    }

    public int[] executeBatch() throws SQLException {
        throw new DbException(57);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setTimestamp(parameterIndex, x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            this.setBinaryStream(parameterIndex, x, length);
        } else {
            this.mps.setUnicodeStream(parameterIndex, x, length);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.isLobColumn(parameterIndex)) {
            throw new DbException(56);
        }
        this.mps.setURL(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        throw new DbException(2);
    }

    public boolean execute(String query) throws SQLException {
        throw new DbException(2);
    }

    public void cancel() throws SQLException {
        this.mps.cancel();
    }

    public void clearBatch() throws SQLException {
        this.mps.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        this.mps.clearWarnings();
    }

    public Connection getConnection() throws SQLException {
        return this.mps.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.mps.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.mps.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.mps.getGeneratedKeys();
    }

    public int getMaxRows() throws SQLException {
        return this.mps.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.mps.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.mps.getMoreResults(current);
    }

    public int getQueryTimeout() throws SQLException {
        return this.mps.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.mps.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.mps.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.mps.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.mps.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.mps.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.mps.getWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.mps.setCursorName(name);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.mps.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.mps.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.mps.setFetchSize(rows);
    }

    public void setMaxRows(int max) throws SQLException {
        this.mps.setMaxRows(max);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.mps.setQueryTimeout(seconds);
    }

    void markDirty() {
        if (this.mps != null) {
            this.mps.markDirty();
        }
        if (this.ins_lpstmt != null) {
            ((PreparedStatementImpl)this.ins_lpstmt).markDirty();
        }
        if (this.del_lpstmt != null) {
            ((PreparedStatementImpl)this.del_lpstmt).markDirty();
        }
        if (this.sel_lpstmt != null) {
            ((PreparedStatementImpl)this.sel_lpstmt).markDirty();
        }
    }

    private static String buildWhere(KeyDescr primary_keys) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < primary_keys.size(); ++i) {
            sb.append(primary_keys.getColumnName(i));
            sb.append(" = ? ");
            if (i >= primary_keys.size() - 1) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    private static String getPrimaryKeysString(KeyDescr primary_keys) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < primary_keys.size(); ++i) {
            sb.append(primary_keys.getColumnName(i));
            if (i >= primary_keys.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static String getPrimaryKeysAsQuestionMarks(KeyDescr primary_keys) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < primary_keys.size(); ++i) {
            sb.append('?');
            if (i >= primary_keys.size() - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private boolean isLobColumn(int parameterIndex) {
        return parameterIndex == this.lob_descr.getLOBColumn();
    }

    private long doInsert(LOBDescr lob_descr) throws SQLException {
        int i;
        this.ins_lpstmt.clearParameters();
        KeyDescr kd = lob_descr.getKeyDescr();
        ParameterMetaData pmd = this.ins_lpstmt.getParameterMetaData();
        this.mps.setLong(lob_descr.getLOBColumn(), 0L);
        this.mps.executeUpdate();
        for (i = 0; i < kd.size(); ++i) {
            int index = kd.getColumnPos(i);
            String name = kd.getColumnName(i);
            int type = pmd.getParameterType(index);
            this.ins_lpstmt.setObject(i + 1, this.par_array[index - 1], type);
            this.upd_lpstmt.setObject(i + 2, this.par_array[index - 1], type);
        }
        long len = this.doTheActualInsert(this.ins_lpstmt, i);
        this.upd_lpstmt.setLong(1, len);
        this.upd_lpstmt.executeUpdate();
        return 1L;
    }

    private long doTheActualInsert(PreparedStatement pstmt, int offset) throws SQLException {
        int batchcount = 0;
        int updatecount = 0;
        int seq = 0;
        if (this.sourceobj == null) {
            return 0L;
        }
        long loblen = this.sourceobj.remaining();
        while (true) {
            if (this.sourceobj.remaining() > 0L && batchcount < 4) {
                pstmt.setInt(offset + 1, seq);
                this.sourceobj.execute(pstmt, offset + 2);
                pstmt.addBatch();
                ++seq;
                ++batchcount;
                continue;
            }
            if (batchcount <= 0) break;
            int[] updatecounts = this.ins_lpstmt.executeBatch();
            for (int j = 0; j < updatecounts.length; ++j) {
                updatecount += updatecounts[j];
            }
            batchcount = 0;
        }
        return loblen;
    }

    private static int getLowestKeyIndex(LOBDescr ld) {
        KeyDescr kd = ld.getKeyDescr();
        int high = 10000;
        for (int i = 0; i < kd.size(); ++i) {
            int index = kd.getColumnPos(i);
            if (index >= high) continue;
            high = index;
        }
        return high;
    }

    private static LOBDescr getUpdateDeleteDescriptor(LOBDescr ld) {
        if (ld == null) {
            return null;
        }
        LOBDescr lob_descr = new LOBDescr();
        KeyDescr kd = ld.getKeyDescr();
        int high = 10000;
        for (int i = 0; i < kd.size(); ++i) {
            int index = kd.getColumnPos(i);
            if (index >= high) continue;
            high = index;
        }
        lob_descr.setTableName(ld.getTableName());
        lob_descr.setLOBColumn(ld.getLOBColumnName(), ld.getLOBColumn());
        return lob_descr;
    }

    private int doDelete(LOBDescr lob_descr) throws SQLException {
        this.del_lpstmt.clearParameters();
        KeyDescr kd = lob_descr.getKeyDescr();
        ParameterMetaData pmd = this.del_lpstmt.getParameterMetaData();
        int high = LobPrepStatement.getLowestKeyIndex(lob_descr);
        for (int i = 0; i < kd.size(); ++i) {
            int index = kd.getColumnPos(i);
            String name = kd.getColumnName(i);
            int index2 = index - high + 1;
            int type = pmd.getParameterType(index2);
            this.del_lpstmt.setObject(i + 1, this.par_array[index - 1], type);
        }
        int a = this.mps.executeUpdate();
        int b = this.del_lpstmt.executeUpdate();
        return a;
    }

    private int doUpdate(LOBDescr lob_descr) throws SQLException {
        int i;
        this.del_lpstmt.clearParameters();
        this.ins_lpstmt.clearParameters();
        KeyDescr kd = lob_descr.getKeyDescr();
        ParameterMetaData pmd_mps = this.mps.getParameterMetaData();
        this.mps.setInt(lob_descr.getLOBColumn(), 0);
        this.mps.executeUpdate();
        for (i = 0; i < kd.size(); ++i) {
            int index = kd.getColumnPos(i);
            String name = kd.getColumnName(i);
            int type = pmd_mps.getParameterType(index);
            this.del_lpstmt.setObject(i + 1, this.par_array[index - 1], type);
            this.ins_lpstmt.setObject(i + 1, this.par_array[index - 1], type);
        }
        int a = this.del_lpstmt.executeUpdate();
        long len = this.doTheActualInsert(this.ins_lpstmt, i);
        this.mps.setLong(lob_descr.getLOBColumn(), len);
        this.mps.executeUpdate();
        return 1;
    }

    private int doDeleteOpt(LOBDescr lob_descr) {
        return 0;
    }

    private int doInsertOpt(LOBDescr lob_descr) throws SQLException {
        long len = this.sourceobj.remaining();
        int pcount = this.query.getParamCount();
        ParameterMetaData pmd_mps = this.mps.getParameterMetaData();
        this.mps.setLong(lob_descr.getLOBColumn(), len);
        KeyDescr kd = lob_descr.getKeyDescr();
        int kdsize = kd.size();
        for (int i = 0; i < kdsize; ++i) {
            int index = kd.getColumnPos(i);
            String name = kd.getColumnName(i);
            int type = pmd_mps.getParameterType(index);
            this.mps.setObject(pcount + i + 1, this.par_array[index - 1], type);
        }
        int ins_offset = kdsize + pcount + 1;
        this.mps.setInt(ins_offset, 0);
        this.sourceobj.execute(this.mps, ins_offset + 1);
        this.mps.executeUpdate();
        if (this.sourceobj.remaining() > 0L) {
            if (this.ins_lpstmt == null) {
                String ins_qry = LobPrepStatement.getInsertQuery(lob_descr);
                this.ins_lpstmt = this.con.prepareStatement(ins_qry);
            }
            this.updateLobLoop(this.ins_lpstmt, lob_descr, this.sourceobj);
        }
        return 1;
    }

    private int doUpdateOpt(LOBDescr lob_descr) throws SQLException {
        int i;
        long len = this.sourceobj.remaining();
        int pcount = this.query.getParamCount();
        ParameterMetaData pmd_mps = this.mps.getParameterMetaData();
        this.mps.setLong(lob_descr.getLOBColumn(), len);
        KeyDescr kd = lob_descr.getKeyDescr();
        int kdsize = kd.size();
        for (i = 0; i < kdsize; ++i) {
            int index = kd.getColumnPos(i);
            int type = pmd_mps.getParameterType(index);
            this.mps.setObject(pcount + i + 1, this.par_array[index - 1], type);
            this.mps.setObject(kdsize + pcount + i + 1, this.par_array[index - 1], type);
        }
        int ins_offset = kdsize + pcount + i + 1;
        this.mps.setInt(ins_offset, 0);
        this.sourceobj.execute(this.mps, ins_offset + 1);
        int update_count = this.mps.executeUpdate();
        if (update_count == 0) {
            String del_qry = LobPrepStatement.getDeleteQuery(lob_descr);
            PreparedStatement pstmt = this.con.prepareStatement(del_qry);
            for (i = 0; i < kdsize; ++i) {
                int index = kd.getColumnPos(i);
                int type = pmd_mps.getParameterType(index);
                pstmt.setObject(i + 1, this.par_array[index - 1], type);
            }
            pstmt.executeUpdate();
        } else if (this.sourceobj.remaining() > 0L) {
            if (this.ins_lpstmt == null) {
                String ins_qry = LobPrepStatement.getInsertQuery(lob_descr);
                this.ins_lpstmt = this.con.prepareStatement(ins_qry);
            }
            this.updateLobLoop(this.ins_lpstmt, lob_descr, this.sourceobj);
        }
        return update_count;
    }

    private int updateLobLoop(PreparedStatement pstmt, LOBDescr ld, LobExecutor lobobj) throws SQLException {
        KeyDescr kd = ld.getKeyDescr();
        ParameterMetaData pmd_mps = this.mps.getParameterMetaData();
        int kdsize = kd.size();
        for (int i = 0; i < kdsize; ++i) {
            int index = kd.getColumnPos(i);
            String name = kd.getColumnName(i);
            int type = pmd_mps.getParameterType(index);
            pstmt.setObject(i + 1, this.par_array[index - 1], type);
        }
        long loblen = lobobj.remaining();
        int seq = 1;
        int batchcount = 0;
        int updatecount = 0;
        int offset = kdsize;
        while (true) {
            if (lobobj.remaining() > 0L && batchcount < 4) {
                this.ins_lpstmt.setInt(offset + 1, seq);
                lobobj.execute(this.ins_lpstmt, offset + 2);
                this.ins_lpstmt.addBatch();
                ++seq;
                ++batchcount;
                continue;
            }
            if (batchcount <= 0) break;
            int[] updatecounts = this.ins_lpstmt.executeBatch();
            for (int j = 0; j < updatecounts.length; ++j) {
                updatecount += updatecounts[j];
            }
            batchcount = 0;
        }
        return 0;
    }

    private void checkLobConState() throws SQLException {
        int transiso = this.con.getTransactionIsolation();
        boolean autocommit = this.con.getAutoCommit();
        if (autocommit || transiso != 4 && transiso != 8) {
            throw new DbException(60);
        }
    }

    private static String getSupportingTable(LOBDescr lob_descr) {
        StringBuffer sb = new StringBuffer(lob_descr.getTableName());
        sb.append("#0");
        return sb.toString();
    }

    private static String getSelectQuery(LOBDescr lob_descr) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT * FROM ");
        sb.append(LobPrepStatement.getSupportingTable(lob_descr));
        sb.append(" WHERE ");
        sb.append(LobPrepStatement.buildWhere(lob_descr.getKeyDescr()));
        sb.append(" ORDER BY ");
        sb.append(LobPrepStatement.getPrimaryKeysString(lob_descr.getKeyDescr()));
        sb.append(", lob_seq_no");
        return sb.toString();
    }

    private static String getInsertQuery(LOBDescr lob_descr) {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(LobPrepStatement.getSupportingTable(lob_descr));
        sb.append(" (");
        sb.append(LobPrepStatement.getPrimaryKeysString(lob_descr.getKeyDescr()));
        sb.append(", lob_seq_no, lob_data) VALUES (");
        sb.append(LobPrepStatement.getPrimaryKeysAsQuestionMarks(lob_descr.getKeyDescr()));
        sb.append(", ?, ?)");
        return sb.toString();
    }

    private static String getDeleteQuery(LOBDescr lob_descr) {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ");
        sb.append(LobPrepStatement.getSupportingTable(lob_descr));
        sb.append(" WHERE ");
        sb.append(LobPrepStatement.buildWhere(lob_descr.getKeyDescr()));
        return sb.toString();
    }

    private static String getUpdateQuery(LOBDescr lob_descr) {
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(lob_descr.getTableName());
        sb.append(" SET ");
        sb.append(lob_descr.getLOBColumnName());
        sb.append(" = ? WHERE ");
        sb.append(LobPrepStatement.buildWhere(lob_descr.getKeyDescr()));
        return sb.toString();
    }

    class LobClob
    implements LobExecutor {
        private Clob clob;
        private InputStream in;
        private long remains;

        public LobClob(Clob c) {
            this.clob = c;
            if (c != null) {
                try {
                    this.remains = c.length();
                    this.in = c.getAsciiStream();
                }
                catch (SQLException e) {
                    this.remains = 0L;
                }
            } else {
                this.remains = 0L;
            }
        }

        public long remaining() {
            return this.remains;
        }

        public int execute(PreparedStatement pstmt, int offset) throws SQLException {
            int len = this.remains > 7000L ? 7000 : (int)this.remains;
            pstmt.setAsciiStream(offset, this.in, len);
            this.remains -= (long)len;
            return 0;
        }
    }

    class LobBlob
    implements LobExecutor {
        private Blob blob;
        private InputStream in;
        private long remains;

        public LobBlob(Blob b) {
            this.blob = b;
            if (b != null) {
                try {
                    this.remains = b.length();
                    this.in = b.getBinaryStream();
                }
                catch (SQLException e) {
                    this.remains = 0L;
                }
            } else {
                this.remains = 0L;
            }
        }

        public long remaining() {
            return this.remains;
        }

        public int execute(PreparedStatement pstmt, int offset) throws SQLException {
            int len = this.remains > 7000L ? 7000 : (int)this.remains;
            pstmt.setBinaryStream(offset, this.in, len);
            this.remains -= (long)len;
            return 0;
        }
    }

    class LobCharacterStream
    implements LobExecutor {
        private long remains;
        private Reader ds;

        public LobCharacterStream(Reader ds, int length) {
            this.remains = length;
            this.ds = ds;
        }

        public long remaining() {
            return this.remains;
        }

        public int execute(PreparedStatement pstmt, int offset) throws SQLException {
            int len = this.remains > 3000L ? 3000 : (int)this.remains;
            pstmt.setCharacterStream(offset, this.ds, len);
            this.remains -= (long)len;
            return 0;
        }
    }

    class LobAsciiStream
    implements LobExecutor {
        private long remains;
        private InputStream ds;

        public LobAsciiStream(InputStream ds, int length) {
            this.remains = length;
            this.ds = ds;
        }

        public long remaining() {
            return this.remains;
        }

        public int execute(PreparedStatement pstmt, int offset) throws SQLException {
            int len = this.remains > 7000L ? 7000 : (int)this.remains;
            pstmt.setAsciiStream(offset, this.ds, len);
            this.remains -= (long)len;
            return 0;
        }
    }

    class LobBinaryStream
    implements LobExecutor {
        private long remains;
        private InputStream ds;

        public LobBinaryStream(InputStream ds, int length) {
            this.remains = length;
            this.ds = ds;
        }

        public long remaining() {
            return this.remains;
        }

        public int execute(PreparedStatement pstmt, int offset) throws SQLException {
            int len = this.remains > 7000L ? 7000 : (int)this.remains;
            pstmt.setBinaryStream(offset, this.ds, len);
            this.remains -= (long)len;
            return 0;
        }
    }

    static interface LobExecutor {
        public static final int VARBINSIZE = 7000;
        public static final int VARCHARSIZE = 3000;

        public long remaining();

        public int execute(PreparedStatement var1, int var2) throws SQLException;
    }

    static class Query {
        private String qry;
        private int param_count = 0;
        private int statement_count = 1;

        public Query(String query) {
            this.qry = query;
            this.parse();
        }

        public int getQueryType() {
            if (this.qry != null) {
                this.qry = this.qry.trim();
                if (this.qry.regionMatches(true, 0, "SELECT", 0, 6)) {
                    return 1;
                }
                if (this.qry.regionMatches(true, 0, "UPDATE", 0, 6)) {
                    return 4;
                }
                if (this.qry.regionMatches(true, 0, "INSERT", 0, 6)) {
                    return 2;
                }
            }
            return 0;
        }

        public int getParamCount() {
            return this.param_count;
        }

        public boolean isMultipleStatements() {
            return this.statement_count != 1;
        }

        private void parse() {
            boolean instring = false;
            if (this.qry != null) {
                for (int i = 0; i < this.qry.length(); ++i) {
                    char c = this.qry.charAt(i);
                    if (c == '\"') {
                        instring = !instring;
                        continue;
                    }
                    if (instring) continue;
                    if (c == '?') {
                        ++this.param_count;
                        continue;
                    }
                    if (c != ';') continue;
                    ++this.statement_count;
                }
            }
        }

        public String getQuery() {
            return this.qry;
        }

        public String toString() {
            return this.getQuery();
        }
    }
}

