/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.sql.SQLException;

abstract class NumericColumn
extends Column {
    private static final int SIZE_LONG = 8;
    private static final int SIZE_INT = 4;
    private static final int SIZE_SHORT = 2;
    private static final int SIZE_BYTE = 1;

    NumericColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
    }

    public String toString() {
        return super.toString() + "\nPrecision       : " + this.att.getPrecision() + "\nScale           : " + this.att.getScale();
    }

    Number getNumber(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return new Long(0L);
        }
        int fieldSize = r.getFieldSize(this.fieldNo);
        switch (fieldSize) {
            case 1: {
                return new Integer(r.getField(this.fieldNo).getInt8(0));
            }
            case 2: {
                return new Integer(r.getField(this.fieldNo).getInt16(0));
            }
            case 4: {
                return new Integer(r.getField(this.fieldNo).getInt32(0));
            }
            case 8: {
                return new Long(r.getField(this.fieldNo).getInt64(0));
            }
        }
        throw new DbException(1, "Invalid field size in tuple (" + fieldSize + ")");
    }

    Object getObject(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return this.getNumber(r);
    }

    abstract int getExtSize() throws SQLException;

    void setBoolean(ParameterTuple r, boolean v) throws SQLException {
        if (v) {
            this.setNumber(r, new Integer(1));
        } else {
            this.setNumber(r, new Integer(0));
        }
    }

    private void truncationCheck(ParameterTuple r, Number input) throws SQLException {
        int fieldSize = this.getExtSize();
        if (fieldSize == 8 ? this.getNumber(r).longValue() != input.longValue() : this.getNumber(r).intValue() != input.intValue()) {
            throw new DbException(8);
        }
    }

    void setNumber(ParameterTuple r, Number v) throws SQLException {
        if (v == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        int fieldSize = this.getExtSize();
        ExtData p = r.allocField(this.fieldNo, fieldSize);
        switch (fieldSize) {
            case 1: {
                p.putInt8(v.byteValue(), 0);
                break;
            }
            case 2: {
                p.putInt16(v.shortValue(), 0);
                break;
            }
            case 4: {
                p.putInt32(v.intValue(), 0);
                break;
            }
            case 8: {
                p.putInt64(v.longValue(), 0);
                break;
            }
            default: {
                throw new DbException(1, "Invalid field size in tuple (" + fieldSize + ")");
            }
        }
        this.truncationCheck(r, v);
    }

    void setString(ParameterTuple r, String s) throws SQLException {
        try {
            if (s == null) {
                this.setNull(r, this.getColumnType());
                return;
            }
            this.setNumber(r, new Double(s));
        }
        catch (NumberFormatException e) {
            throw new DbException(6, "Could not convert the string '" + s + "' to a numeric values");
        }
    }

    final boolean isSigned() {
        return true;
    }

    int getPrecision() throws SQLException {
        return this.att.getPrecision();
    }

    int getScale() throws SQLException {
        return this.att.getScale();
    }
}

