/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.comm.RPCExeDescr;
import com.sun.hadb.comm.RPCPrepDescr;
import com.sun.hadb.comm.RPCQueryDescr;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTableTypeDescr;
import com.sun.hadb.jdbc.BatchStore;
import com.sun.hadb.jdbc.BlobColumn;
import com.sun.hadb.jdbc.ClobColumn;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.ColumnAccessor;
import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.JdbcLogFactory;
import com.sun.hadb.jdbc.LobFragment;
import com.sun.hadb.jdbc.LobFrame;
import com.sun.hadb.jdbc.ParameterMetaDataImpl;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.RLobDescr;
import com.sun.hadb.jdbc.ResultSetMetaDataImpl;
import com.sun.hadb.jdbc.StatementImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement,
ColumnAccessor {
    private static final int MAX_BATCH_EXECUTES = 256;
    static int MAX_BATCHED_DATA_SIZE = 32000;
    private static final int FRM_HIGH_WATER_MARK = 31000;
    private static final int FRM_LOW_WATER_MARK = 1000;
    private static final int FRG_MAX_SIZE = 7000;
    protected ParameterTuple prow = null;
    protected Column[] parameterColumns;
    protected boolean[] parameterFlag;
    private int executeCount = 0;
    private String ddlSQL;
    private boolean ddlNativeSQL;
    protected boolean rowPositioned;
    protected RPCQueryDescr prepareDescr;
    private Logger logger = JdbcLogFactory.getJDBCLogger();
    private String sql;
    private int lobCount = 0;
    private MessageChunk alignChunk = null;

    public PreparedStatementImpl(ConnectionImpl c, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(c, rsType, rsConcurrency, rsHoldability);
        this.sql = sql;
        this.prepareDescr = this.doPrepare(sql);
        this.init();
        this.alignChunk = new MessageChunkByteArray();
        this.alignChunk.appendUInt8(0);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('[');
        if (this.parameterColumns != null) {
            for (int i = 0; i < this.parameterColumns.length; ++i) {
                if (this.parameterColumns[i] == null || this.prow == null) {
                    b.append("NULL");
                } else {
                    try {
                        b.append(this.parameterColumns[i].getString(this.prow));
                    }
                    catch (SQLException e) {
                        b.append("ERROR - COULD NOT DECODE PARAMETER");
                    }
                }
                b.append(',');
            }
        } else {
            b.append("<NO PARAMETERS> ");
        }
        b.setCharAt(b.length() - 1, ']');
        return b.toString();
    }

    private void init() throws SQLException {
        RPCTableTypeDescr ttd = this.prepareDescr.getPDS();
        if (ttd != null) {
            int i;
            this.parameterFlag = new boolean[ttd.getAttcnt()];
            this.parameterColumns = new Column[ttd.getAttcnt()];
            this.lobCount = 0;
            if (ttd.getLobNo() > -1) {
                for (i = 0; i < ttd.getAttcnt(); ++i) {
                    RPCAttrDescr rad = ttd.getRPCAttrDescr(i);
                    if (!rad.isLOB()) continue;
                    ++this.lobCount;
                }
            }
            this.clearParameters();
            for (i = 0; i < this.parameterColumns.length; ++i) {
                this.parameterColumns[i] = ResultSetMetaDataImpl.newColumn(ttd.getRPCAttrDescr(i), i);
                this.parameterColumns[i].setColumnAccessor(this);
            }
        } else {
            this.prow = new ParameterTuple(0, 0);
        }
    }

    public synchronized void clearParameters() throws SQLException {
        if (this.prepareDescr.getPDS() == null) {
            return;
        }
        this.prow = new ParameterTuple(this.parameterFlag.length, this.lobCount);
        for (int i = 0; i < this.parameterFlag.length; ++i) {
            this.parameterFlag[i] = false;
        }
        this.rowPositioned = false;
    }

    public synchronized void close() throws SQLException {
        if (this.openState == 2) {
            if (this.con.poolStatements()) {
                super.doClose(true, this.sql, this.schema);
            } else {
                this.tearDown();
            }
        }
    }

    private void tearDown() throws SQLException {
        this.prow = null;
        this.parameterFlag = null;
        if (this.parameterColumns != null) {
            for (int i = 0; i < this.parameterColumns.length; ++i) {
                this.parameterColumns[i] = null;
            }
            this.parameterColumns = null;
        }
        this.con.removePrepStatement(this);
        this.prepareDescr.close();
        super.doClose(false, null, this.schema);
    }

    public synchronized boolean execute(String x) throws SQLException {
        this.checkOpen();
        throw new DbException(21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean execute() throws SQLException {
        this.checkOpen();
        if (this.isBatch) {
            throw new DbException(50);
        }
        this.checkDirty();
        if (this.prepareDescr.getPDS() != null) {
            this.checkParams();
        }
        this.params = this.prow != null ? this.prow.asMessageBuffer() : null;
        try {
            if (this.prepareDescr.getPrep(0).getQryType() == 1) {
                this.rs = this.executeQuery();
                boolean bl = true;
                return bl;
            }
            this.executeUpdate();
            boolean bl = false;
            return bl;
        }
        finally {
            this.params = null;
        }
    }

    public synchronized ResultSet executeQuery(String x) throws SQLException {
        this.checkOpen();
        throw new DbException(21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        if (this.isBatch) {
            throw new DbException(50);
        }
        this.checkDirty();
        if (this.prepareDescr.getPDS() != null) {
            this.checkParams();
        }
        this.params = this.prow != null ? this.prow.asMessageBuffer() : null;
        try {
            if (this.prepareDescr.getPrep(0).getQryType() != 1) {
                throw new DbException(25);
            }
            ResultSet resultSet = this.doExecuteQuery(this.prepareDescr.getPrep(0));
            return resultSet;
        }
        finally {
            this.params = null;
        }
    }

    public synchronized int executeUpdate(String x) throws SQLException {
        this.checkOpen();
        throw new DbException(21);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate() throws SQLException {
        this.checkOpen();
        if (this.isBatch) {
            throw new DbException(50);
        }
        this.checkDirty();
        if (this.prepareDescr.getPDS() != null) {
            this.checkParams();
        }
        this.params = this.prow != null ? this.prow.asMessageBuffer() : null;
        RLobDescr[] rld = this.genRLobDescr();
        try {
            if (this.prepareDescr.getPrep(0).getQryType() == 1) {
                throw new DbException(24);
            }
            this.doExecuteUpdate(this.prepareDescr, 1, rld);
            int n = this.updateCount;
            return n;
        }
        finally {
            this.params = null;
        }
    }

    private RLobDescr[] genRLobDescr() throws SQLException {
        return this.genRLobDescr(1);
    }

    private RLobDescr[] genRLobDescr(int executecount) throws SQLException {
        if (this.lobCount > 0 && executecount > 0) {
            int cnt = 0;
            RLobDescr[] rld = new RLobDescr[this.lobCount * executecount];
            for (int j = 0; j < executecount; ++j) {
                BatchStore bs = null;
                InputStream[] pti = null;
                long[] ptl = null;
                if (this.isBatch) {
                    bs = (BatchStore)this.batchedData.get(j);
                    pti = bs.getLobStreams();
                    ptl = bs.getLobStreamLengths();
                }
                int lobcnt = -1;
                for (int i = 0; i < this.parameterColumns.length; ++i) {
                    int type = this.parameterColumns[i].getColumnType();
                    if (type != 2004 && type != 2005) continue;
                    rld[cnt] = new RLobDescr(i);
                    rld[cnt].setType(type);
                    ++lobcnt;
                    if (type == 2004) {
                        if (this.isBatch) {
                            rld[cnt].setBinaryStream(pti[lobcnt]);
                            rld[cnt].setLength(ptl[lobcnt]);
                        } else {
                            rld[cnt].setBinaryStream(((BlobColumn)this.parameterColumns[i]).getStream());
                            rld[cnt].setLength(((BlobColumn)this.parameterColumns[i]).getStreamLength());
                        }
                    } else if (type == 2005) {
                        if (this.isBatch) {
                            rld[cnt].setBinaryStream(pti[lobcnt]);
                            rld[cnt].setLength(ptl[lobcnt]);
                        } else {
                            rld[cnt].setBinaryStream(((ClobColumn)this.parameterColumns[i]).getStream());
                            rld[cnt].setLength(((ClobColumn)this.parameterColumns[i]).getStreamLength());
                        }
                    }
                    ++cnt;
                }
            }
            return rld;
        }
        return null;
    }

    public synchronized void setAsciiStream(int parm1, InputStream parm2, int parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setAsciiStream(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setBigDecimal(int parm1, BigDecimal parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setBigDecimal(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setBinaryStream(int parm1, InputStream parm2, int parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setBinaryStream(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setBoolean(int parm1, boolean parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setBoolean(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setByte(int parm1, byte parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setByte(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setBytes(int parm1, byte[] parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setBytes(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setDate(int parm1, Date parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setDate(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setDouble(int parm1, double parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setDouble(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setFloat(int parm1, float parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setFloat(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setInt(int parm1, int parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setInt(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setLong(int parm1, long parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setLong(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setNull(int parm1, int parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setNull(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setObject(int parm1, Object parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setObject(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setObject(int parm1, Object parm2, int parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setObject(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setObject(int parm1, Object parm2, int parm3, int parm4) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setObject(this.prow, parm2, parm3, parm4);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setShort(int parm1, short parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setShort(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setString(int parm1, String parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setString(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setTime(int parm1, Time parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setTime(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setTimestamp(int parm1, Timestamp parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setTimestamp(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public synchronized void setUnicodeStream(int parm1, InputStream parm2, int parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setUnicodeStream(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void addBatch(String x) throws SQLException {
        throw new DbException(21);
    }

    public synchronized void addBatch() throws SQLException {
        this.checkOpen();
        this.isBatch = true;
        this.checkParams();
        if (this.batchedData == null) {
            this.batchedData = new LinkedList();
        }
        if (this.prow != null) {
            int k = 0;
            for (int i = 0; i < this.parameterColumns.length; ++i) {
                int type = this.parameterColumns[i].getColumnType();
                if (type == 2004) {
                    this.prow.setLobStream(k, ((BlobColumn)this.parameterColumns[i]).getStream(), ((BlobColumn)this.parameterColumns[i]).getStreamLength());
                    ++k;
                    continue;
                }
                if (type != 2005) continue;
                this.prow.setLobStream(k, ((ClobColumn)this.parameterColumns[i]).getStream(), ((ClobColumn)this.parameterColumns[i]).getStreamLength());
                ++k;
            }
        }
        this.batchedData.add(new BatchStore(this.prow, this.prow.getLobStreams(), this.prow.getLobStreamLengths()));
        this.prow = (ParameterTuple)this.prow.clone();
        ++this.executeCount;
    }

    public synchronized int[] executeBatch() throws SQLException {
        this.checkOpen();
        this.checkDirty();
        int[] ret = new int[this.executeCount];
        try {
            for (int i = 0; i < this.prepareDescr.getPrepCount(); ++i) {
                if (this.prepareDescr.getPrep(i).getQryType() != 1) continue;
                throw new BatchUpdateException("SELECT not accepted in batched updates", new int[0]);
            }
            if (!this.isBatch) {
                int[] i = ret;
                return i;
            }
            this.currentBatchBase = 0;
            int executes = 0;
            int curSize = 0;
            int nextSize = 0;
            RLobDescr[] rld = this.genRLobDescr(this.executeCount);
            boolean skiptuple = false;
            boolean lob_size_error = false;
            long accum_lob_size = 0L;
            long current_lob_size = 0L;
            int frameno = 0;
            LobFrame frame = new LobFrame();
            RPCQueryDescr qd = null;
            while (this.batchedData.size() > 0) {
                BatchStore bs = (BatchStore)this.batchedData.removeFirst();
                ParameterTuple curTup = bs.getParameterTuple();
                if (this.params == null) {
                    this.params = curTup.asMessageBuffer();
                } else {
                    curTup.appendToMessageBuffer(this.params);
                }
                ++executes;
                curSize += nextSize == 0 ? curTup.size() + 2 : nextSize + 2;
                if (rld == null) {
                    int n = nextSize = this.batchedData.size() > 0 ? ((BatchStore)this.batchedData.getFirst()).getParameterTuple().size() : 0;
                    if (curSize + 2 + nextSize <= MAX_BATCHED_DATA_SIZE && executes < 256 && this.batchedData.size() != 0) continue;
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("Sends batch to server:\ncurrent batch base = " + this.currentBatchBase + "\ncurrent size  = " + curSize + "\nexecutes = " + executes);
                    }
                    int[] execarr = this.doExecuteUpdate(this.prepareDescr, this.executeCount, null);
                    System.arraycopy(execarr, 0, ret, this.currentBatchBase, executes);
                    this.currentBatchBase += executes;
                    curSize = 0;
                    executes = 0;
                    this.params = null;
                    continue;
                }
                InputStream[] lobstreams = bs.getLobStreams();
                long[] lobsizes = bs.getLobStreamLengths();
                int size = this.params.size();
                int remainder = 31000 - size;
                boolean eol = false;
                LobFragment frag = null;
                byte[] barr = new byte[7000];
                RPCTableTypeDescr ttd = this.prepareDescr.getPDS();
                for (int i = 0; i < ttd.getAttcnt(); ++i) {
                    RPCAttrDescr ad = ttd.getRPCAttrDescr(i);
                    if (skiptuple) break;
                    if (!ad.isLOB()) continue;
                    int lobno = ad.getLobNo();
                    size = this.params.size();
                    remainder = 31000 - size;
                    accum_lob_size = 0L;
                    current_lob_size = lobsizes[lobno - 1];
                    eol = false;
                    while (!eol) {
                        int ucount;
                        RPCExeDescr exe;
                        int rlen = 0;
                        try {
                            long diff = current_lob_size - accum_lob_size;
                            int rsiz = Math.min(remainder, 7000);
                            if (diff < (long)rsiz) {
                                rsiz = (int)diff;
                            }
                            int offset = 0;
                            while (true) {
                                InputStream lstr;
                                int rcount;
                                if ((rcount = (lstr = lobstreams[lobno - 1]) != null ? lstr.read(barr, offset, rsiz) : -1) > 0) {
                                    accum_lob_size += (long)rcount;
                                }
                                if (rcount == -1) {
                                    eol = true;
                                    break;
                                }
                                if (accum_lob_size >= current_lob_size) {
                                    eol = true;
                                    rlen += rcount;
                                    break;
                                }
                                if (rcount == rsiz) {
                                    rlen += rcount;
                                    break;
                                }
                                if (rcount > rsiz) {
                                    throw new DbException(1, "rlen(" + rlen + ") > rsiz (" + rsiz + ")");
                                }
                                offset += rcount;
                                rsiz -= rcount;
                                rlen += rcount;
                            }
                        }
                        catch (IOException e) {
                            throw new DbException(1, e);
                        }
                        byte[] frr = new byte[rlen];
                        System.arraycopy(barr, 0, frr, 0, rlen);
                        frag = new LobFragment(lobno, frr);
                        if (eol) {
                            if (accum_lob_size < lobsizes[lobno - 1]) {
                                lob_size_error = true;
                                throw new DbException(59, "was " + accum_lob_size + " should have been " + current_lob_size);
                            }
                            frag.setEOL();
                        }
                        frag.setData();
                        frame.addFragment(frag);
                        remainder = 31000 - size - frame.size();
                        if (remainder >= 1000) continue;
                        this.logger.finest("Sending LOB frame - (1)");
                        try {
                            if (this.params == null) {
                                this.params = frame.asMessageBuffer();
                                if (frame.size() % 2 == 1) {
                                    this.params.append(this.alignChunk);
                                }
                            } else {
                                this.params.append(frame.asMessageBuffer());
                                if (frame.size() % 2 == 1) {
                                    this.params.append(this.alignChunk);
                                }
                            }
                            if (frameno == 0) {
                                if (qd != null) {
                                    qd.close();
                                }
                                qd = this.statement.prepareAndExecuteQuery(null, this.executeCount, 2, this.parameterCount, this.querymode, this.params, 0);
                            } else {
                                qd = this.statement.executeParams(this.params);
                            }
                            RPCStatus stat = qd.getRPCStatus();
                            if (stat.isError()) {
                                throw new DbException(stat);
                            }
                            this.addWarning(qd.getRPCStatus());
                            for (int j = 0; j < qd.getExeCount(); ++j) {
                                RPCExeDescr exe2 = qd.getExe(j);
                                int count = exe2.getCount();
                                ret[this.currentBatchBase++] = count;
                            }
                        }
                        catch (CommException e) {
                            this.con.markDirty(e);
                            if (e.getRPCStatus() != null) {
                                throw new DbException(e.getRPCStatus(), e);
                            }
                            throw new DbException(e);
                        }
                        if (frameno == 0 && qd != null && (qd.getQueryMode() | 4L) > 0L && (exe = qd.getExe(0)) != null && (ucount = exe.getCount()) == 0) {
                            eol = true;
                            skiptuple = true;
                        }
                        this.params = null;
                        frame = new LobFrame();
                        remainder = 31000;
                        size = 0;
                        ++frameno;
                    }
                }
                if (frame != null && frame.getFragmentCount() > 0) {
                    if (this.params == null) {
                        this.params = frame.asMessageBuffer();
                        if (frame.size() % 2 == 1) {
                            this.params.append(this.alignChunk);
                        }
                    } else {
                        this.params.append(frame.asMessageBuffer());
                        if (frame.size() % 2 == 1) {
                            this.params.append(this.alignChunk);
                        }
                    }
                }
                if (this.batchedData.size() == 0 && this.params != null) {
                    try {
                        if (frameno == 0) {
                            if (qd != null) {
                                qd.close();
                            }
                            qd = this.statement.prepareAndExecuteQuery(null, this.executeCount, 2, this.parameterCount, this.querymode, this.params, 0);
                        } else {
                            if (qd != null) {
                                qd.close();
                            }
                            qd = this.statement.executeParams(this.params);
                        }
                        RPCStatus stat = qd.getRPCStatus();
                        if (stat.isError()) {
                            throw new DbException(stat);
                        }
                        this.addWarning(qd.getRPCStatus());
                        for (int i = 0; i < qd.getExeCount(); ++i) {
                            RPCExeDescr exe = qd.getExe(i);
                            int count = exe.getCount();
                            ret[this.currentBatchBase++] = count;
                        }
                    }
                    catch (CommException e) {
                        this.con.markDirty(e);
                        if (e.getRPCStatus() != null) {
                            throw new DbException(e.getRPCStatus(), e);
                        }
                        throw new DbException(e);
                    }
                    this.currentBatchBase += executes;
                    this.params = null;
                    remainder = 31000;
                    size = 0;
                    ++frameno;
                }
                frame = new LobFrame();
            }
            int[] nArray = ret;
            return nArray;
        }
        catch (BatchUpdateException e) {
            if (this.currentBatchBase == 0) {
                throw e;
            }
            int[] updatecounts = new int[this.currentBatchBase + e.getUpdateCounts().length];
            System.arraycopy(ret, 0, updatecounts, 0, this.currentBatchBase);
            System.arraycopy(e.getUpdateCounts(), 0, updatecounts, this.currentBatchBase, e.getUpdateCounts().length);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), updatecounts);
        }
        finally {
            this.doClearBatch();
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        RPCTableTypeDescr pds;
        RPCPrepDescr rpd;
        if (this.prepareDescr != null && (rpd = this.prepareDescr.getPrep(0)) != null && (pds = rpd.getTTD()) != null) {
            ResultSetMetaDataImpl crsmd = new ResultSetMetaDataImpl(pds, this.con);
            return crsmd;
        }
        return null;
    }

    public void setArray(int parm1, Array parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setArray(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setBlob(int parm1, Blob parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setBlob(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setCharacterStream(int parm1, Reader parm2, int parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setCharacterStream(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setClob(int parm1, Clob parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setClob(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setDate(int parm1, Date parm2, Calendar parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setDate(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setNull(int parm1, int parm2, String parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setNull(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setRef(int parm1, Ref parm2) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setRef(this.prow, parm2);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setTime(int parm1, Time parm2, Calendar parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setTime(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    public void setTimestamp(int parm1, Timestamp parm2, Calendar parm3) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setTimestamp(this.prow, parm2, parm3);
        this.parameterFlag[parm1 - 1] = true;
    }

    protected void doClearBatch() {
        this.params = null;
        this.isBatch = false;
        this.executeCount = 0;
        if (this.batchedData != null) {
            this.batchedData.clear();
            this.batchedData = null;
        }
    }

    public void setURL(int parm1, URL x) throws SQLException {
        this.checkParameterIndex(parm1);
        this.parameterColumns[parm1 - 1].setURL(this.prow, x);
        this.parameterFlag[parm1 - 1] = true;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkOpen();
        ParameterMetaDataImpl cpm = new ParameterMetaDataImpl(this.parameterColumns);
        return cpm;
    }

    void checkParameterIndex(int parix) throws SQLException {
        this.checkOpen();
        if (this.parameterColumns == null) {
            throw new DbException(40);
        }
        if (parix < 1 || parix > this.parameterColumns.length) {
            throw new DbException(14, "" + parix + ", Valid is 1 to " + this.parameterColumns.length);
        }
    }

    void checkParams() throws SQLException {
        String notset = null;
        boolean test = true;
        this.checkOpen();
        if (this.prepareDescr.getPDS() == null) {
            this.parameterCount = 0;
            return;
        }
        for (int i = 0; i < this.parameterFlag.length; ++i) {
            if (this.parameterFlag[i]) continue;
            notset = notset == null ? new String("index " + (i + 1)) : notset + new String("," + (i + 1));
            test = false;
        }
        if (!test) {
            throw new DbException(41, notset);
        }
        this.parameterCount = this.prow.getFieldCount();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Parameter tuple:" + this.prow.toString());
        }
    }

    public void setWasNull(boolean wasNull) throws SQLException {
    }

    synchronized void markDirty() {
        this.statement = null;
        this.setDirty(true);
    }

    RPCQueryDescr getPrepareDescr() {
        return this.prepareDescr;
    }

    private void checkDirty() throws SQLException {
        if (this.isDirty()) {
            this.statement = null;
            this.prepareDescr = this.doPrepare(this.sql);
        }
    }

    protected Object getObject(int index) throws SQLException {
        this.checkParameterIndex(index);
        return this.parameterColumns[index - 1].getObject(this.prow);
    }

    protected void finalize() throws SQLException {
        if (this.openState == 2) {
            this.tearDown();
        }
    }
}

