/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.RLobInputStream;
import com.sun.hadb.jdbc.Tuple;
import com.sun.hadb.jdbc.TupleStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class RBlobImpl
implements Blob {
    private TupleStore tstore;
    private Tuple tuple;
    private int fieldNo;
    private long blength;

    public RBlobImpl(Tuple r, int fieldNo) {
        this.tstore = r.getTupleStore();
        this.tuple = r;
        this.fieldNo = fieldNo;
        this.blength = r.getField(fieldNo).getInt64(0);
    }

    public InputStream getBinaryStream() throws SQLException {
        RLobInputStream in = new RLobInputStream(this.tuple, this.tstore, this.fieldNo);
        return in;
    }

    public long length() throws SQLException {
        return this.blength;
    }

    public long position(byte[] pattern, long start) throws SQLException {
        throw new DbException(2);
    }

    public long position(Blob pattern, long start) throws SQLException {
        throw new DbException(2);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new IllegalArgumentException("pos < 1");
        }
        try {
            long l;
            int skipcnt;
            int siz = (int)(this.length() - (long)skipcnt);
            int cnt = Math.max(Math.min(length, siz), 0);
            byte[] barr = new byte[cnt];
            InputStream in = this.getBinaryStream();
            for (skipcnt = (int)Math.max(Math.min(this.length(), pos - 1L), 0L); skipcnt > 0 && (l = in.skip(skipcnt)) > 0L; skipcnt -= (int)l) {
            }
            int off = 0;
            while (cnt > 0) {
                int a = in.read(barr, off, cnt);
                if (a < 0) {
                    throw new DbException(59);
                }
                off += a;
                cnt -= a;
            }
            return barr;
        }
        catch (IOException e) {
            throw new DbException(e);
        }
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new DbException(2);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new DbException(2);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new DbException(2);
    }

    public void truncate(long len) throws SQLException {
        throw new DbException(2);
    }
}

