/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.Tuple;
import com.sun.hadb.jdbc.TupleStore;
import java.io.IOException;
import java.io.InputStream;

public class RLobInputStream
extends InputStream {
    private static final int S_OPEN = 1;
    private static final int S_CLOSED = 2;
    private int state = 1;
    private Tuple tuple;
    private TupleStore store;
    private int colno;
    private byte[] lobBuffer;
    private int bufferPtr;

    public RLobInputStream(Tuple r, TupleStore store, int colno) {
        this.tuple = r;
        this.store = store;
        this.colno = colno;
        this.lobBuffer = null;
        this.bufferPtr = 0;
    }

    public synchronized int read() throws IOException {
        if (this.isOpen()) {
            if (this.availInBuffer() < 1) {
                this.fetchData();
            }
            if (this.isOpen() && this.lobBuffer != null) {
                int val;
                if ((val = this.lobBuffer[this.bufferPtr++]) < 0) {
                    val = 256 + val;
                }
                return val;
            }
            return -1;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isOpen()) {
            if (this.availInBuffer() < 1) {
                this.fetchData();
            }
            if (this.isOpen() && this.lobBuffer != null) {
                int bytecount = Math.min(len, this.availInBuffer());
                System.arraycopy(this.lobBuffer, this.bufferPtr, b, off, bytecount);
                this.bufferPtr += bytecount;
                return bytecount;
            }
            return -1;
        }
        return -1;
    }

    public synchronized int available() throws IOException {
        return this.availInBuffer();
    }

    private int availInBuffer() {
        if (this.lobBuffer != null) {
            return this.lobBuffer.length - this.bufferPtr;
        }
        return 0;
    }

    public synchronized void close() {
        this.state = 2;
        this.lobBuffer = null;
    }

    private boolean fetchData() throws IOException {
        try {
            this.lobBuffer = this.store.getNextLobFragment(this.tuple, this.colno);
            this.bufferPtr = 0;
            return this.lobBuffer != null;
        }
        catch (DbException e) {
            IOException ioe = new IOException(e.toString());
            ioe.initCause(e);
            this.close();
            throw ioe;
        }
    }

    private boolean isOpen() {
        return this.state == 1;
    }
}

