/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.CliStatement;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCExeDescr;
import com.sun.hadb.jdbc.ColumnAccessor;
import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ResultSetMetaDataImpl;
import com.sun.hadb.jdbc.StatementImpl;
import com.sun.hadb.jdbc.Tuple;
import com.sun.hadb.jdbc.TupleStore;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class ResultSetImpl
implements ResultSet,
ColumnAccessor {
    protected ResultSetMetaDataImpl metadata;
    protected boolean lastGetWasNull = false;
    private TupleStore tupleStore;
    protected Tuple row;
    protected SQLWarning warnings = null;
    protected int fetchSize = 0;
    private int maxRows = 0;
    private boolean isOpen = true;
    private String cursorName;
    private StatementImpl statement;
    boolean isEof;
    protected ConnectionImpl con;
    protected int currentRowno = 0;
    private boolean cursorActive;
    int stmId;
    protected int resultSetConcurrency = 1007;

    public ResultSetImpl(StatementImpl statement, ConnectionImpl con, int stmId, ResultSetMetaDataImpl metadata, int fetchSize, int maxRows, RPCExeDescr exe, MessageBuffer buf, int offset) throws SQLException {
        this.statement = statement;
        if (statement == null) {
            throw new DbException(1);
        }
        this.con = con;
        this.metadata = metadata;
        this.stmId = stmId;
        this.fetchSize = fetchSize;
        this.maxRows = maxRows;
        this.resultSetConcurrency = statement.getResultSetConcurrency();
        this.cursorActive = true;
        if (statement.getCliStatement() == null || con == null || metadata == null || buf == null || exe == null) {
            throw new DbException(1);
        }
        this.isEof = exe.isEof();
        if (this.isEof) {
            this.eventEndOfResultSet();
        }
        metadata.setColumnAccessor(this);
        this.tupleStore = new TupleStore(con, statement, metadata, new ExtData(buf, offset), this.isEof, fetchSize);
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public synchronized void close() throws SQLException {
        if (this.isOpen) {
            this.eventEndOfResultSet();
            this.clearWarnings();
            this.metadata = null;
            this.statement = null;
            this.row = null;
            this.currentRowno = 0;
            this.isOpen = false;
            this.tupleStore.close();
            this.tupleStore = null;
        }
    }

    public int findColumn(String parm1) throws SQLException {
        this.checkOpen();
        return this.metadata.findColumn(parm1);
    }

    public synchronized InputStream getAsciiStream(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getAsciiStream(this.row);
    }

    public InputStream getAsciiStream(String parm1) throws SQLException {
        return this.getAsciiStream(this.findColumn(parm1));
    }

    public synchronized BigDecimal getBigDecimal(int parm1, int parm2) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getBigDecimal(this.row, parm2);
    }

    public BigDecimal getBigDecimal(String parm1, int parm2) throws SQLException {
        return this.getBigDecimal(this.findColumn(parm1), parm2);
    }

    public synchronized InputStream getBinaryStream(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getBinaryStream(this.row);
    }

    public InputStream getBinaryStream(String parm1) throws SQLException {
        return this.getBinaryStream(this.findColumn(parm1));
    }

    public synchronized boolean getBoolean(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getBoolean(this.row);
    }

    public boolean getBoolean(String parm1) throws SQLException {
        return this.getBoolean(this.findColumn(parm1));
    }

    public synchronized byte getByte(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getByte(this.row);
    }

    public byte getByte(String parm1) throws SQLException {
        return this.getByte(this.findColumn(parm1));
    }

    public synchronized byte[] getBytes(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getBytes(this.row);
    }

    public byte[] getBytes(String parm1) throws SQLException {
        return this.getBytes(this.findColumn(parm1));
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public synchronized Date getDate(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getDate(this.row);
    }

    public Date getDate(String parm1) throws SQLException {
        return this.getDate(this.findColumn(parm1));
    }

    public synchronized double getDouble(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getDouble(this.row);
    }

    public double getDouble(String parm1) throws SQLException {
        return this.getDouble(this.findColumn(parm1));
    }

    public synchronized float getFloat(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getFloat(this.row);
    }

    public float getFloat(String parm1) throws SQLException {
        return this.getFloat(this.findColumn(parm1));
    }

    public synchronized int getInt(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getInt(this.row);
    }

    public int getInt(String parm1) throws SQLException {
        return this.getInt(this.findColumn(parm1));
    }

    public synchronized long getLong(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getLong(this.row);
    }

    public long getLong(String parm1) throws SQLException {
        return this.getLong(this.findColumn(parm1));
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this.metadata;
    }

    public synchronized Object getObject(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getObject(this.row);
    }

    public Object getObject(String parm1) throws SQLException {
        return this.getObject(this.findColumn(parm1));
    }

    public synchronized short getShort(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getShort(this.row);
    }

    public short getShort(String parm1) throws SQLException {
        return this.getShort(this.findColumn(parm1));
    }

    public synchronized String getString(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getString(this.row);
    }

    public String getString(String parm1) throws SQLException {
        return this.getString(this.findColumn(parm1));
    }

    public synchronized Time getTime(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getTime(this.row);
    }

    public Time getTime(String parm1) throws SQLException {
        return this.getTime(this.findColumn(parm1));
    }

    public synchronized Timestamp getTimestamp(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getTimestamp(this.row);
    }

    public Timestamp getTimestamp(String parm1) throws SQLException {
        return this.getTimestamp(this.findColumn(parm1));
    }

    public synchronized InputStream getUnicodeStream(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getUnicodeStream(this.row);
    }

    public InputStream getUnicodeStream(String parm1) throws SQLException {
        return this.getUnicodeStream(this.findColumn(parm1));
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    private boolean isEof() {
        return this.isEof;
    }

    public synchronized boolean next() throws SQLException {
        this.checkOpen();
        this.clearWarnings();
        if (this.maxRows > 0 && this.currentRowno >= this.maxRows) {
            this.eventEndOfResultSet();
            return false;
        }
        this.row = this.tupleStore.nextTuple();
        if (this.row == null) {
            this.eventEndOfResultSet();
            return false;
        }
        ++this.currentRowno;
        return true;
    }

    protected void eventEndOfResultSet() throws SQLException {
        this.row = null;
        if (this.cursorActive) {
            try {
                this.cursorActive = false;
                CliStatement cstmt = this.statement.getCliStatement();
                if (cstmt != null) {
                    cstmt.closeCursor();
                }
            }
            catch (CommException e) {
                if (e.getRPCStatus() != null) {
                    throw new DbException(e.getRPCStatus(), e);
                }
                throw new DbException(e);
            }
        }
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.lastGetWasNull;
    }

    public boolean absolute(int parm1) throws SQLException {
        throw new DbException(9, "absolute()");
    }

    public void afterLast() throws SQLException {
        throw new DbException(9, "afterLast()");
    }

    public void beforeFirst() throws SQLException {
        throw new DbException(9, "beforeFirst()");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new DbException(2);
    }

    public void deleteRow() throws SQLException {
        throw new DbException(2);
    }

    public boolean first() throws SQLException {
        throw new DbException(9, "first()");
    }

    public synchronized Array getArray(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getArray(this.row);
    }

    public Array getArray(String parm1) throws SQLException {
        return this.getArray(this.findColumn(parm1));
    }

    public synchronized BigDecimal getBigDecimal(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getBigDecimal(this.row);
    }

    public BigDecimal getBigDecimal(String parm1) throws SQLException {
        return this.getBigDecimal(this.findColumn(parm1));
    }

    public synchronized Blob getBlob(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getBlob(this.row);
    }

    public Blob getBlob(String parm1) throws SQLException {
        return this.getBlob(this.findColumn(parm1));
    }

    public synchronized Reader getCharacterStream(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getCharacterStream(this.row);
    }

    public Reader getCharacterStream(String parm1) throws SQLException {
        return this.getCharacterStream(this.findColumn(parm1));
    }

    public synchronized Clob getClob(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getClob(this.row);
    }

    public Clob getClob(String parm1) throws SQLException {
        return this.getClob(this.findColumn(parm1));
    }

    public synchronized int getConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public synchronized Date getDate(int parm1, Calendar parm2) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getDate(this.row, parm2);
    }

    public Date getDate(String parm1, Calendar parm2) throws SQLException {
        return this.getDate(this.findColumn(parm1), parm2);
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized Object getObject(int parm1, Map parm2) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getObject(this.row, parm2);
    }

    public Object getObject(String parm1, Map parm2) throws SQLException {
        throw new DbException(2);
    }

    public synchronized Ref getRef(int parm1) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getRef(this.row);
    }

    public Ref getRef(String parm1) throws SQLException {
        return this.getRef(this.findColumn(parm1));
    }

    public synchronized int getRow() throws SQLException {
        return this.currentRowno;
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized Time getTime(int parm1, Calendar parm2) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getTime(this.row, parm2);
    }

    public Time getTime(String parm1, Calendar parm2) throws SQLException {
        return this.getTime(this.findColumn(parm1), parm2);
    }

    public synchronized Timestamp getTimestamp(int parm1, Calendar parm2) throws SQLException {
        this.checkAccess(parm1);
        return this.metadata.getColumn(parm1).getTimestamp(this.row, parm2);
    }

    public Timestamp getTimestamp(String parm1, Calendar parm2) throws SQLException {
        return this.getTimestamp(this.findColumn(parm1), parm2);
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void insertRow() throws SQLException {
        throw new DbException(2);
    }

    public synchronized boolean isAfterLast() throws SQLException {
        this.checkOpen();
        return this.getRow() > 0 && this.row == null;
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return this.getRow() == 0 && this.tupleStore.expectMoreTuples();
    }

    public synchronized boolean isFirst() throws SQLException {
        return !this.isBeforeFirst() && !this.isAfterLast() && this.getRow() == 1;
    }

    public synchronized boolean isLast() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            return false;
        }
        if (this.getRow() == 0) {
            return false;
        }
        if (this.maxRows > 0 && this.maxRows == this.getRow()) {
            return true;
        }
        return this.isEof() && !this.tupleStore.expectMoreTuples();
    }

    public boolean last() throws SQLException {
        throw new DbException(9, new String("last()"));
    }

    public void moveToCurrentRow() throws SQLException {
        throw new DbException(2);
    }

    public void moveToInsertRow() throws SQLException {
        throw new DbException(2);
    }

    public boolean previous() throws SQLException {
        throw new DbException(9, "previous()");
    }

    public void refreshRow() throws SQLException {
        throw new DbException(2);
    }

    public boolean relative(int parm1) throws SQLException {
        throw new DbException(9, "relative(n)");
    }

    public boolean rowDeleted() throws SQLException {
        throw new DbException(2);
    }

    public boolean rowInserted() throws SQLException {
        throw new DbException(2);
    }

    public boolean rowUpdated() throws SQLException {
        throw new DbException(2);
    }

    public void setFetchDirection(int parm1) throws SQLException {
        if (parm1 != 1000) {
            throw new DbException(36);
        }
    }

    public synchronized void setFetchSize(int parm1) throws SQLException {
        if (parm1 < 0) {
            throw new DbException(37, Integer.toString(parm1));
        }
        this.fetchSize = parm1;
    }

    public void updateAsciiStream(int parm1, InputStream parm2, int parm3) throws SQLException {
        throw new DbException(2);
    }

    public void updateAsciiStream(String parm1, InputStream parm2, int parm3) throws SQLException {
        this.updateAsciiStream(this.findColumn(parm1), parm2, parm3);
    }

    public void updateBigDecimal(int parm1, BigDecimal parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateBigDecimal(String parm1, BigDecimal parm2) throws SQLException {
        this.updateBigDecimal(this.findColumn(parm1), parm2);
    }

    public void updateBinaryStream(int parm1, InputStream parm2, int parm3) throws SQLException {
        throw new DbException(2);
    }

    public void updateBinaryStream(String parm1, InputStream parm2, int parm3) throws SQLException {
        this.updateBinaryStream(this.findColumn(parm1), parm2, parm3);
    }

    public void updateBoolean(int parm1, boolean parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateBoolean(String parm1, boolean parm2) throws SQLException {
        this.updateBoolean(this.findColumn(parm1), parm2);
    }

    public void updateByte(int parm1, byte parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateByte(String parm1, byte parm2) throws SQLException {
        this.updateByte(this.findColumn(parm1), parm2);
    }

    public void updateBytes(int parm1, byte[] parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateBytes(String parm1, byte[] parm2) throws SQLException {
        this.updateBytes(this.findColumn(parm1), parm2);
    }

    public void updateCharacterStream(int parm1, Reader parm2, int parm3) throws SQLException {
        throw new DbException(2);
    }

    public void updateCharacterStream(String parm1, Reader parm2, int parm3) throws SQLException {
        this.updateCharacterStream(this.findColumn(parm1), parm2, parm3);
    }

    public void updateDate(int parm1, Date parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateDate(String parm1, Date parm2) throws SQLException {
        this.updateDate(this.findColumn(parm1), parm2);
    }

    public void updateDouble(int parm1, double parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateDouble(String parm1, double parm2) throws SQLException {
        this.updateDouble(this.findColumn(parm1), parm2);
    }

    public void updateFloat(int parm1, float parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateFloat(String parm1, float parm2) throws SQLException {
        this.updateFloat(this.findColumn(parm1), parm2);
    }

    public void updateInt(int parm1, int parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateInt(String parm1, int parm2) throws SQLException {
        this.updateInt(this.findColumn(parm1), parm2);
    }

    public void updateLong(int parm1, long parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateLong(String parm1, long parm2) throws SQLException {
        this.updateLong(this.findColumn(parm1), parm2);
    }

    public void updateNull(int parm1) throws SQLException {
        throw new DbException(2);
    }

    public void updateNull(String parm1) throws SQLException {
        this.updateNull(this.findColumn(parm1));
    }

    public void updateObject(int parm1, Object parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateObject(int parm1, Object parm2, int parm3) throws SQLException {
        throw new DbException(2);
    }

    public void updateObject(String parm1, Object parm2) throws SQLException {
        this.updateObject(this.findColumn(parm1), parm2);
    }

    public void updateObject(String parm1, Object parm2, int parm3) throws SQLException {
        this.updateObject(this.findColumn(parm1), parm2, parm3);
    }

    public void updateRow() throws SQLException {
        throw new DbException(2);
    }

    public void updateShort(int parm1, short parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateShort(String parm1, short parm2) throws SQLException {
        this.updateShort(this.findColumn(parm1), parm2);
    }

    public void updateString(int parm1, String parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateString(String parm1, String parm2) throws SQLException {
        this.updateString(this.findColumn(parm1), parm2);
    }

    public void updateTime(int parm1, Time parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateTime(String parm1, Time parm2) throws SQLException {
        this.updateTime(this.findColumn(parm1), parm2);
    }

    public void updateTimestamp(int parm1, Timestamp parm2) throws SQLException {
        throw new DbException(2);
    }

    public void updateTimestamp(String parm1, Timestamp parm2) throws SQLException {
        this.updateTimestamp(this.findColumn(parm1), parm2);
    }

    public synchronized void addWarning(SQLWarning w) {
        if (this.warnings == null) {
            this.warnings = w;
        } else {
            this.warnings.setNextWarning(w);
        }
    }

    public synchronized void setWasNull(boolean wasNull) {
        this.lastGetWasNull = wasNull;
    }

    public synchronized URL getURL(int columnIndex) throws SQLException {
        this.checkAccess(columnIndex);
        return this.metadata.getColumn(columnIndex).getURL(this.row);
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new DbException(2);
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new DbException(2);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new DbException(2);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new DbException(2);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new DbException(2);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new DbException(2);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new DbException(2);
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new DbException(2);
    }

    void setColumnName(int colno, String name) throws SQLException {
        this.checkOpen();
        this.metadata.setColumnName(colno, name);
    }

    private void checkAccess(int colix) throws SQLException {
        this.checkOpen();
        this.metadata.checkColumnIndex(colix);
        if (this.isRowInvalid()) {
            throw new DbException(11);
        }
    }

    protected void checkValidRow() throws SQLException {
        this.checkOpen();
        if (this.isRowInvalid()) {
            throw new DbException(11);
        }
    }

    private boolean isRowInvalid() {
        return this.tupleStore.getTuple() == null;
    }

    protected void checkOpen() throws SQLException {
        if (!this.isOpen) {
            throw new DbException(12);
        }
    }

    protected void finalize() throws SQLException {
        if (this.isOpen) {
            this.close();
        }
    }
}

