/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.comm.RPCTableTypeDescr;
import com.sun.hadb.jdbc.BigintColumn;
import com.sun.hadb.jdbc.BinaryColumn;
import com.sun.hadb.jdbc.BitColumn;
import com.sun.hadb.jdbc.BlobColumn;
import com.sun.hadb.jdbc.CharacterColumn;
import com.sun.hadb.jdbc.ClobColumn;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.ColumnAccessor;
import com.sun.hadb.jdbc.DateColumn;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.DecimalColumn;
import com.sun.hadb.jdbc.FloatColumn;
import com.sun.hadb.jdbc.IntegerColumn;
import com.sun.hadb.jdbc.IntervalColumn;
import com.sun.hadb.jdbc.JdbcLogFactory;
import com.sun.hadb.jdbc.SmallintColumn;
import com.sun.hadb.jdbc.TimeColumn;
import com.sun.hadb.jdbc.TimestampColumn;
import com.sun.hadb.jdbc.VarbinaryColumn;
import com.sun.hadb.jdbc.VarcharColumn;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResultSetMetaDataImpl
implements ResultSetMetaData {
    private Column[] outputs;
    private Hashtable nameLookup = null;
    private static Hashtable typeInfo = null;
    private Connection con;
    private String[] columnName = null;
    private RPCTableTypeDescr ttd = null;
    private static Logger logger = JdbcLogFactory.getJDBCLogger();

    ResultSetMetaDataImpl(RPCTableTypeDescr ttd, Connection con) throws SQLException {
        this.ttd = ttd;
        this.con = con;
        this.outputs = new Column[ttd.getAttcnt()];
        for (int i = 0; i < this.outputs.length; ++i) {
            this.outputs[i] = ResultSetMetaDataImpl.newColumn(ttd.getRPCAttrDescr(i), i);
        }
    }

    public String toString() {
        return "ResultSetMetaDataImpl\n .ttd:" + this.ttd.toString();
    }

    void setColumnName(int colno, String name) throws SQLException {
        this.checkColumnIndex(colno);
        this.columnName[colno - 1] = name;
    }

    void setColumnAccessor(ColumnAccessor a) {
        for (int i = 0; i < this.outputs.length; ++i) {
            this.outputs[i].setColumnAccessor(a);
        }
    }

    void checkColumnIndex(int colix) throws SQLException {
        if (colix < 1 || colix > this.outputs.length) {
            throw new DbException(13, "" + colix + ", Valid is 1 to " + this.outputs.length);
        }
    }

    /*
     * WARNING - void declaration
     */
    static Column newColumn(RPCAttrDescr att, int fieldno) throws SQLException {
        void var2_2;
        if (att == null) {
            throw new DbException(1);
        }
        switch (att.getMain()) {
            case 8: {
                Column ret;
                if (att.isVarsize()) {
                    ret = new VarcharColumn(att, fieldno);
                    break;
                }
                ret = new CharacterColumn(att, fieldno);
                break;
            }
            case 1: {
                Column ret = new SmallintColumn(att, fieldno);
                break;
            }
            case 2: {
                Column ret = new IntegerColumn(att, fieldno);
                break;
            }
            case 3: {
                Column ret = new BigintColumn(att, fieldno);
                break;
            }
            case 10: {
                Column ret = new BitColumn(att, fieldno);
                break;
            }
            case 4: {
                Column ret = new DecimalColumn(att, fieldno, true);
                break;
            }
            case 7: {
                Column ret = new DecimalColumn(att, fieldno, false);
                break;
            }
            case 11: {
                Column ret;
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("isDate:" + att.isDate() + "isTime:" + att.isTime() + "isTimeStamp:" + att.isTimeStamp());
                }
                if (att.isDate()) {
                    ret = new DateColumn(att, fieldno);
                    break;
                }
                if (att.isTime()) {
                    ret = new TimeColumn(att, fieldno);
                    break;
                }
                if (att.isTimeStamp()) {
                    ret = new TimestampColumn(att, fieldno);
                    break;
                }
                throw new DbException(1);
            }
            case 5: 
            case 6: {
                Column ret = new FloatColumn(att, fieldno);
                break;
            }
            case 9: {
                Column ret;
                if (att.isVarsize()) {
                    ret = new VarbinaryColumn(att, fieldno);
                    break;
                }
                ret = new BinaryColumn(att, fieldno);
                break;
            }
            case 12: {
                Column ret = new IntervalColumn(att, fieldno);
                break;
            }
            case 13: {
                Column ret = new BlobColumn(att, fieldno);
                break;
            }
            case 14: {
                Column ret = new ClobColumn(att, fieldno);
                break;
            }
            default: {
                throw new DbException(15, Integer.toString(att.getMain()));
            }
        }
        return var2_2;
    }

    int findColumn(String parm1) throws SQLException {
        String arg;
        Integer i;
        if (this.nameLookup == null) {
            this.loadMetadata();
        }
        if ((i = (Integer)this.nameLookup.get(arg = parm1.startsWith("\"") & parm1.endsWith("\"") ? parm1.substring(1, parm1.length() - 1) : parm1.toLowerCase())) == null) {
            throw new DbException(16, parm1);
        }
        return i;
    }

    Column getColumn(int colno) {
        return this.outputs[colno - 1];
    }

    private void loadMetadata() throws SQLException {
        this.nameLookup = new Hashtable(this.outputs.length);
        this.columnName = new String[this.outputs.length];
        for (int i = 0; i < this.outputs.length; ++i) {
            this.columnName[i] = this.ttd.getRPCAttrDescr(i).getName();
            this.nameLookup.put(this.columnName[i], new Integer(i + 1));
        }
    }

    public RPCTableTypeDescr getTTD() {
        return this.ttd;
    }

    public String getCatalogName(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return "";
    }

    public int getColumnCount() throws SQLException {
        return this.outputs.length;
    }

    public int getColumnDisplaySize(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.getColumnDisplaySize();
    }

    public String getColumnLabel(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return this.ttd.getRPCAttrDescr(parm1 - 1).getName();
    }

    public String getColumnName(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return this.ttd.getRPCAttrDescr(parm1 - 1).getName();
    }

    public int getColumnType(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.getColumnType();
    }

    public String getColumnTypeName(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.getColumnTypeName();
    }

    public int getPrecision(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        RPCAttrDescr att = this.ttd.getRPCAttrDescr(parm1 - 1);
        switch (att.getMain()) {
            case 4: {
                return att.getPrecision();
            }
            case 8: 
            case 9: {
                return att.getLength();
            }
        }
        return 0;
    }

    public int getScale(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        RPCAttrDescr att = this.ttd.getRPCAttrDescr(parm1 - 1);
        if (att.getMain() == 4) {
            return att.getScale();
        }
        return 0;
    }

    public String getSchemaName(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return "";
    }

    public String getTableName(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return "";
    }

    public boolean isAutoIncrement(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return false;
    }

    public boolean isCaseSensitive(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return this.getTypeInfo(parm1).isCaseSensitive();
    }

    public boolean isCurrency(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return false;
    }

    public boolean isDefinitelyWritable(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.isDefinitelyWritable();
    }

    public int isNullable(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.isNullable() ? 1 : 0;
    }

    public boolean isReadOnly(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.isReadOnly();
    }

    public boolean isSearchable(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return this.getTypeInfo(parm1).isSearchAble();
    }

    public boolean isSigned(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        return this.getTypeInfo(parm1).isSigned();
    }

    public boolean isWritable(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.isWritable();
    }

    public String getColumnClassName(int parm1) throws SQLException {
        this.checkColumnIndex(parm1);
        Column c = this.outputs[parm1 - 1];
        return c.getClassName();
    }

    private TypeInfo getTypeInfo(int parm1) throws SQLException {
        Column c;
        Integer datatype;
        TypeInfo ti;
        if (typeInfo == null) {
            ResultSet rs = this.con.getMetaData().getTypeInfo();
            Hashtable<Integer, TypeInfo> tmpTypeInfo = new Hashtable<Integer, TypeInfo>();
            logger.finer("Type information:");
            while (rs.next()) {
                boolean isSigned;
                Integer s = (Integer)rs.getObject("DATA_TYPE");
                boolean bl = isSigned = !rs.getBoolean("UNSIGNED_ATTRIBUTE");
                if (rs.wasNull()) {
                    isSigned = false;
                }
                TypeInfo ti2 = new TypeInfo(rs.getBoolean("SEARCHABLE"), isSigned, rs.getBoolean("CASE_SENSITIVE"));
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(rs.getString("TYPE_NAME") + ",SQLTYPE(" + s.toString() + "), TYPEINFO(" + ti2.toString() + ")");
                }
                tmpTypeInfo.put(s, ti2);
            }
            rs.close();
            typeInfo = tmpTypeInfo;
        }
        if ((ti = (TypeInfo)typeInfo.get(datatype = new Integer((c = this.outputs[parm1 - 1]).getColumnType()))) == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Could not find typeinfo in metadata on column:" + c.getColumnTypeName() + ", SQLTYPE(" + datatype.toString() + ")" + "\nUsing hardcoded values");
            }
            ti = new TypeInfo(c.isSearchable(), c.isSigned(), c.isCaseSensitive());
            typeInfo.put(datatype, ti);
        }
        return ti;
    }

    private static class TypeInfo {
        private boolean isSearchAble;
        private boolean isSigned;
        private boolean isCaseSensitive;

        TypeInfo(boolean isSearchAble, boolean isSigned, boolean isCaseSensitive) {
            this.isSearchAble = isSearchAble;
            this.isSigned = isSigned;
            this.isCaseSensitive = isCaseSensitive;
        }

        boolean isSearchAble() {
            return this.isSearchAble;
        }

        boolean isSigned() {
            return this.isSigned;
        }

        boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public String toString() {
            return "isSearchAble:" + this.isSearchAble + ", isCaseSensitive:" + this.isCaseSensitive + ", isSigned:" + this.isSigned;
        }
    }
}

