/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.CliStatement;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.comm.RPCExeDescr;
import com.sun.hadb.comm.RPCPrepDescr;
import com.sun.hadb.comm.RPCQueryDescr;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTableTypeDescr;
import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DatabaseMetaDataImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.JdbcLogFactory;
import com.sun.hadb.jdbc.LobFragment;
import com.sun.hadb.jdbc.LobFrame;
import com.sun.hadb.jdbc.RLobDescr;
import com.sun.hadb.jdbc.ResultSetImpl;
import com.sun.hadb.jdbc.ResultSetMetaDataImpl;
import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatementImpl
implements Statement {
    static int MAX_BATCHED_DATA_SIZE = 32000;
    private static final int FRM_HIGH_WATER_MARK = 31000;
    private static final int FRM_LOW_WATER_MARK = 1000;
    private static final int FRG_MAX_SIZE = 7000;
    private static final int MAX_STATEMENTS = 32;
    protected LinkedList batchedData = null;
    protected int currentBatchBase = 0;
    protected CliStatement statement = null;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected ConnectionImpl con;
    protected int fetchSize = 0;
    static final int DEFAULT_FETCH_SIZE = 42;
    protected long querymode;
    protected ResultSet rs = null;
    private RPCQueryDescr qd = null;
    private RPCExeDescr[] ed = null;
    private int currentExeDescr = 0;
    protected int updateCount = -1;
    protected boolean isBatch = false;
    private int[] batchUpdateCount = null;
    private int queryTimeout = 0;
    private SQLWarning warnings = null;
    protected static final int STMT_CLOSED = 0;
    protected static final int STMT_POOLED = 1;
    protected static final int STMT_OPEN = 2;
    protected int openState = 0;
    protected long schema;
    protected String cursorName = null;
    protected MessageBuffer params = null;
    protected int parameterCount = 0;
    private Logger logger = JdbcLogFactory.getJDBCLogger();
    private boolean transClosed = false;
    protected int resultSetConcurrency = 1007;
    private int resultSetType = 1003;
    private int fetchDirection = 1000;

    public StatementImpl(ConnectionImpl c, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.con = c;
        this.setDirty(false);
        this.fixAttributes(rsType, rsConcurrency, rsHoldability);
    }

    protected void fixAttributes(int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        this.openState = 2;
        this.querymode = 528L;
        DatabaseMetaDataImpl.testResultSetType(rsType);
        DatabaseMetaDataImpl.testConcurrency(rsConcurrency);
        DatabaseMetaDataImpl.testHoldability(rsHoldability);
        if (rsType != 1003) {
            this.addWarning(new SQLWarning("Only TYPE_FORWARD is supported for ResultSets"));
            rsType = 1003;
        }
        block0 : switch (rsType) {
            case 1003: {
                this.resultSetType = rsType;
                switch (rsConcurrency) {
                    case 1008: {
                        this.querymode |= 0x20000L;
                    }
                    case 1007: {
                        this.resultSetConcurrency = rsConcurrency;
                        break block0;
                    }
                }
                this.openState = 0;
                throw new DbException(2, "CONCUR_UPDATABLE");
            }
            default: {
                this.openState = 0;
                throw new DbException(2, "ResultSetType should be TYPE_FORWARD");
            }
        }
        switch (rsHoldability) {
            case 2: {
                break;
            }
            default: {
                throw new DbException(52);
            }
        }
    }

    CliStatement getCliStatement() {
        return this.statement;
    }

    public void cancel() throws SQLException {
        throw new DbException(2, "Cancel");
    }

    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    synchronized void doClose(boolean poolStatement, String sql, long schema) throws SQLException {
        switch (this.openState) {
            case 1: 
            case 2: {
                this.clearStatement();
                if (poolStatement) {
                    this.con.poolStatement(this, sql, schema);
                    this.openState = 1;
                    break;
                }
                if (this.statement != null) {
                    this.statement.close();
                    this.statement = null;
                }
                this.doClearBatch();
                this.con = null;
                this.params = null;
                this.openState = 0;
                break;
            }
        }
    }

    public void close() throws SQLException {
        if (this.openState == 2) {
            this.doClose(false, null, this.schema);
        }
    }

    int rowsToFetch(int readSoFar) throws SQLException {
        int fetchSize = this.getFetchSize();
        int fetch = fetchSize == 0 ? 42 : fetchSize;
        int rows = (this.maxRows == 0 ? Integer.MAX_VALUE : this.maxRows) - readSoFar;
        int n = rows = rows < 0 ? 0 : rows;
        if (fetch > rows) {
            return rows;
        }
        return fetch;
    }

    void doTheStatement(String sql, int block_mask) throws SQLException {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SQL: " + sql);
            }
            this.clearStatement();
            this.schema = this.con.getCurrentSchema();
            if (this.isDirty() || this.statement == null) {
                this.statement = this.con.getDatabase().getStatement();
                this.setDirty(false);
            }
            this.statement.setTimeout(this.queryTimeout * 1000);
            if (this.parameterCount != 0 || this.params != null) {
                throw new DbException(1, "Not allowed for parameterized queries");
            }
            this.currentExeDescr = 0;
            this.qd = this.statement.prepareAndExecuteQuery(sql, 1, 0x300003 | block_mask, 0, this.querymode, null, this.rowsToFetch(0));
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.qd.toString());
            }
            RPCStatus stat = this.qd.getRPCStatus();
            if (!this.isBatch && stat.isError()) {
                this.qd.close();
                throw new DbException(stat);
            }
            if (this.qd.getPDS() != null) {
                throw new DbException(26);
            }
            this.addWarning(this.qd.getRPCStatus());
            this.transClosed = false;
            if (this.isBatch) {
                int execount = this.qd.getExeCount();
                this.batchUpdateCount = new int[execount];
                boolean qry_select_error = false;
                block12: for (int i = 0; i < execount; ++i) {
                    this.batchUpdateCount[i] = stat.isError() ? -3 : this.qd.getExe(i).getCount();
                    switch (this.qd.getPrep(i).getQryType()) {
                        case 16: {
                            long retparam = this.qd.getExe(i).getRetparam();
                            this.con.setInternalAutoCommit(retparam == 1L);
                            continue block12;
                        }
                        case 20: 
                        case 41: {
                            this.con.setCurrentSchema(this.qd.getExe(i).getRetparam());
                            continue block12;
                        }
                        case 1: {
                            qry_select_error = true;
                            this.batchUpdateCount[i] = -3;
                        }
                    }
                }
                if (stat.isError()) {
                    throw new BatchUpdateException(stat.getErrorMessage(), stat.getSQLState(), (int)stat.getMainStatus(), this.batchUpdateCount);
                }
                if (qry_select_error) {
                    throw new BatchUpdateException("INTERNAL: SELECT accepted by server when QRY_BLOCK_SELECT was set", this.batchUpdateCount);
                }
                return;
            }
            switch (this.qd.getPrep(0).getQryType()) {
                case 1: {
                    ResultSetMetaDataImpl md = new ResultSetMetaDataImpl(this.qd.getPrep(0).getTTD(), this.con);
                    this.rs = new ResultSetImpl(this, this.con, 0, md, this.fetchSize == 0 ? 42 : this.fetchSize, this.maxRows, this.qd.getExe(0), this.qd.getTuples(), 0);
                    break;
                }
                case 16: {
                    long retparam = this.qd.getExe(0).getRetparam();
                    this.con.setInternalAutoCommit(retparam == 1L);
                    break;
                }
                case 20: 
                case 41: {
                    this.con.setCurrentSchema(this.qd.getExe(0).getRetparam());
                    this.updateCount = this.qd.getExe(0).getCount();
                    break;
                }
                default: {
                    this.updateCount = this.qd.getExe(0).getCount();
                    this.qd.close();
                    break;
                }
            }
        }
        catch (CommException e) {
            this.con.markDirty(e);
            if (e.getRPCStatus() != null) {
                throw new DbException(e.getRPCStatus(), e);
            }
            throw new DbException(e);
        }
    }

    RPCQueryDescr doPrepare(String sql) throws SQLException {
        try {
            RPCStatus stat;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("PREP: " + sql);
            }
            this.clearStatement();
            this.schema = this.con.getCurrentSchema();
            if (this.statement == null) {
                this.statement = this.con.getDatabase().getStatement();
            }
            this.statement.setTimeout(this.queryTimeout * 1000);
            int actions = 0x300001;
            this.currentExeDescr = 0;
            this.qd = this.statement.prepareAndExecuteQuery(sql, 1, actions, 0, this.querymode, null, 0);
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.qd.toString());
            }
            if ((stat = this.qd.getRPCStatus()).isError()) {
                throw new DbException(stat);
            }
            this.addWarning(this.qd.getRPCStatus());
            this.setDirty(false);
            this.qd.close();
            return this.qd;
        }
        catch (CommException e) {
            this.con.markDirty(e);
            if (e.getRPCStatus() != null) {
                throw new DbException(e.getRPCStatus(), e);
            }
            throw new DbException(e);
        }
    }

    ResultSet doExecuteQuery(RPCPrepDescr pd) throws SQLException {
        try {
            RPCStatus stat;
            this.clearStatement();
            this.currentExeDescr = 0;
            int actions = 0x300002;
            this.qd = this.statement.prepareAndExecuteQuery(null, 1, actions, this.parameterCount, this.querymode, this.params, this.rowsToFetch(0));
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.qd.toString());
            }
            if ((stat = this.qd.getRPCStatus()).isError()) {
                throw new DbException(stat);
            }
            this.addWarning(this.qd.getRPCStatus());
            this.transClosed = false;
            ResultSetMetaDataImpl md = new ResultSetMetaDataImpl(pd.getTTD(), this.con);
            this.rs = new ResultSetImpl(this, this.con, 0, md, this.fetchSize == 0 ? 42 : this.fetchSize, this.maxRows, this.qd.getExe(0), this.qd.getTuples(), 0);
            return this.rs;
        }
        catch (CommException e) {
            this.con.markDirty(e);
            if (e.getRPCStatus() != null) {
                throw new DbException(e.getRPCStatus(), e);
            }
            throw new DbException(e);
        }
    }

    int[] doExecuteUpdate(RPCQueryDescr rqd, int executecount, RLobDescr[] rld) throws SQLException {
        RPCPrepDescr pd = rqd.getPrep(0);
        boolean skiptuple = false;
        boolean lob_size_error = false;
        long accum_lob_size = 0L;
        long current_lob_size = 0L;
        try {
            this.updateCount = -1;
            this.currentExeDescr = 0;
            if (rld == null) {
                this.qd = this.statement.prepareAndExecuteQuery(null, executecount, 2, this.parameterCount, this.querymode, this.params, 0);
                this.transClosed = false;
            } else {
                int size = this.params.size();
                int remainder = 31000 - size;
                LobFrame frame = new LobFrame();
                LobFragment frag = null;
                int frameno = 0;
                byte[] barr = new byte[7000];
                int lobctr = -1;
                RPCTableTypeDescr ttd = rqd.getPDS();
                for (int i = 0; i < ttd.getAttcnt() && !skiptuple; ++i) {
                    RPCAttrDescr ad = ttd.getRPCAttrDescr(i);
                    if (!ad.isLOB()) continue;
                    accum_lob_size = 0L;
                    current_lob_size = rld[++lobctr].getLength();
                    boolean eol = false;
                    int lobno = ad.getLobNo();
                    while (!eol) {
                        int ucount;
                        RPCExeDescr exe;
                        int rlen = 0;
                        try {
                            long diff = current_lob_size - accum_lob_size;
                            int rsiz = Math.min(remainder, 7000);
                            if (diff < (long)rsiz) {
                                rsiz = (int)diff;
                            }
                            int offset = 0;
                            while (true) {
                                InputStream lstr;
                                int rcount;
                                if ((rcount = (lstr = rld[lobctr].getBinaryStream()) != null ? lstr.read(barr, offset, rsiz) : -1) > 0) {
                                    accum_lob_size += (long)rcount;
                                }
                                if (rcount == -1) {
                                    eol = true;
                                    break;
                                }
                                if (accum_lob_size >= current_lob_size) {
                                    eol = true;
                                    rlen += rcount;
                                    break;
                                }
                                if (rcount == rsiz) {
                                    rlen += rcount;
                                    break;
                                }
                                if (rcount > rsiz) {
                                    throw new DbException(1, "rlen(" + rlen + ") > rsiz (" + rsiz + ")");
                                }
                                offset += rcount;
                                rsiz -= rcount;
                                rlen += rcount;
                            }
                        }
                        catch (IOException e) {
                            throw new DbException(1, e);
                        }
                        byte[] frr = new byte[rlen];
                        System.arraycopy(barr, 0, frr, 0, rlen);
                        frag = new LobFragment(lobno, frr);
                        if (eol) {
                            if (accum_lob_size < rld[lobctr].getLength()) {
                                lob_size_error = true;
                                if (frameno > 0) {
                                    this.statement.closeCursor();
                                }
                                throw new DbException(59, "was " + accum_lob_size + " should have been " + current_lob_size);
                            }
                            frag.setEOL();
                        }
                        frag.setData();
                        frame.addFragment(frag);
                        remainder = 31000 - size - frame.size();
                        if (remainder >= 1000) continue;
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.finest("Sending LOB frame");
                            this.logger.finest(frame.toString());
                        }
                        RPCQueryDescr rrqd = this.sendFrame(executecount, this.params, frame, frameno);
                        rrqd.close();
                        if (frameno == 0 && rrqd != null && (rrqd.getQueryMode() | 4L) > 0L && (exe = rrqd.getExe(0)) != null && (ucount = exe.getCount()) == 0) {
                            eol = true;
                            skiptuple = true;
                        }
                        if (rqd != null) {
                            this.qd = rrqd;
                        }
                        frame = new LobFrame();
                        remainder = 31000;
                        size = 0;
                        ++frameno;
                    }
                }
                if (frameno == 0 || frame.getFragmentCount() > 0 && !skiptuple) {
                    RPCQueryDescr qrqd = this.sendFrame(executecount, this.params, frame, frameno);
                    if (qrqd != null) {
                        qrqd.close();
                        this.qd = qrqd;
                    }
                    ++frameno;
                }
            }
            if (lob_size_error) {
                throw new DbException(59, "was " + accum_lob_size + " should have been " + current_lob_size);
            }
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.finer(this.qd.toString());
            }
            RPCStatus stat = this.qd.getRPCStatus();
            this.addWarning(stat);
            int execount = this.qd.getExeCount();
            int[] updatecounts = new int[execount];
            this.qd.close();
            if (!this.isBatch) {
                RPCExeDescr exe = this.qd.getExe(0);
                this.updateCount = this.ed != null && this.ed[0] != null ? this.ed[0].getCount() : (exe != null ? exe.getCount() : 0);
                if (stat.isError()) {
                    throw new DbException(stat);
                }
                if (updatecounts.length > 0) {
                    updatecounts[0] = this.updateCount;
                }
                return updatecounts;
            }
            block11: for (int i = 0; i < execount; ++i) {
                updatecounts[i] = stat.isError() ? -3 : this.qd.getExe(i).getCount();
                switch (pd.getQryType()) {
                    case 16: {
                        long retparam = this.qd.getExe(i).getRetparam();
                        this.con.setInternalAutoCommit(retparam == 1L);
                        continue block11;
                    }
                    case 20: 
                    case 41: {
                        this.con.setCurrentSchema(this.qd.getExe(i).getRetparam());
                        continue block11;
                    }
                }
            }
            if (stat.isError()) {
                throw new BatchUpdateException(stat.getErrorMessage(), stat.getSQLState(), (int)stat.getMainStatus(), updatecounts);
            }
            return updatecounts;
        }
        catch (CommException e) {
            this.con.markDirty(e);
            if (e.getRPCStatus() != null) {
                throw new DbException(e.getRPCStatus(), e);
            }
            throw new DbException(e);
        }
    }

    private RPCQueryDescr sendFrame(int executecount, MessageBuffer param, LobFrame frame, int frameno) throws DbException, CommException {
        RPCQueryDescr qd;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("sendFrame: frameno=" + frameno);
            if (frame != null) {
                this.logger.finest(frame.toString());
            }
        }
        if (frameno == 0) {
            param.append(frame.asMessageBuffer());
            qd = this.statement.prepareAndExecuteQuery(null, executecount, 2, this.parameterCount, this.querymode, param, 0);
        } else {
            MessageBuffer buffer = frame.asMessageBuffer();
            qd = this.statement.executeParams(buffer);
        }
        RPCStatus stat = qd.getRPCStatus();
        this.addWarning(stat);
        if (stat.isError()) {
            throw new DbException(stat);
        }
        return qd;
    }

    private void dumpUpdateCounts(RPCExeDescr[] ed, int frameno) {
        System.out.println("StatementImpl.dumpUpdateCounts() frame=" + frameno);
        if (ed != null) {
            for (int i = 0; i < ed.length; ++i) {
                System.out.println("  exe[" + i + "] = " + ed[i].toString());
            }
        } else {
            System.out.println("  ExeDescr is null");
        }
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.checkOpen();
        if (this.isBatch) {
            throw new DbException(50);
        }
        this.doTheStatement(sql, 0);
        if (this.updateCount < 0) {
            return true;
        }
        this.qd.close();
        return false;
    }

    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.checkOpen();
        if (this.isBatch) {
            throw new DbException(50);
        }
        this.doTheStatement(sql, 1048064);
        if (this.updateCount > -1) {
            this.qd.close();
            throw new DbException(25);
        }
        return this.rs;
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        this.checkOpen();
        if (this.isBatch) {
            throw new DbException(50);
        }
        this.doTheStatement(sql, 256);
        this.qd.close();
        if (this.rs != null) {
            throw new DbException(24);
        }
        return this.updateCount;
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        this.checkOpen();
        return this.maxFieldSize;
    }

    public synchronized int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        this.checkOpen();
        ++this.currentExeDescr;
        if (this.qd != null && this.currentExeDescr < this.qd.getExeCount()) {
            this.updateCount = this.qd.getExe(this.currentExeDescr).getCount();
            return false;
        }
        this.clearStatement();
        return false;
    }

    public synchronized int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.rs;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.checkOpen();
        return this.updateCount;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public synchronized void setCursorName(String str) throws SQLException {
        this.checkOpen();
        this.cursorName = str.toUpperCase();
    }

    public void setEscapeProcessing(boolean parm1) throws SQLException {
    }

    public synchronized void setMaxFieldSize(int parm1) throws SQLException {
        this.checkOpen();
        if (parm1 < 0) {
            throw new DbException(27);
        }
        this.maxFieldSize = parm1;
    }

    public synchronized void setMaxRows(int parm1) throws SQLException {
        this.checkOpen();
        if (parm1 < 0) {
            throw new DbException(28);
        }
        this.maxRows = parm1;
    }

    public synchronized void setQueryTimeout(int timeout) throws SQLException {
        this.checkOpen();
        if (timeout < 0) {
            throw new DbException(29);
        }
        this.queryTimeout = timeout;
    }

    protected boolean isScrollable() throws SQLException {
        this.checkOpen();
        return this.resultSetType != 1003;
    }

    protected boolean isUpdatable() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency == 1008;
    }

    public synchronized void addBatch(String parm1) throws SQLException {
        this.checkOpen();
        this.isBatch = true;
        parm1 = parm1.trim();
        if (parm1.charAt(parm1.length() - 1) != ';') {
            parm1 = parm1 + ";";
        }
        if (this.batchedData == null) {
            this.batchedData = new LinkedList();
        }
        this.batchedData.add(parm1);
    }

    public void clearBatch() throws SQLException {
        this.doClearBatch();
    }

    synchronized void doClearBatch() {
        if (this.batchedData != null) {
            this.batchedData.clear();
            this.batchedData = null;
        }
        this.isBatch = false;
    }

    public synchronized int[] executeBatch() throws SQLException {
        this.checkOpen();
        int[] ret = null;
        try {
            if (!this.isBatch || this.batchedData == null) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int executeCount = this.batchedData.size();
            ret = new int[executeCount];
            this.currentBatchBase = 0;
            int executes = 0;
            int curSize = 0;
            String batch = "";
            int nextSize = 0;
            while (this.batchedData.size() > 0) {
                String curString = (String)this.batchedData.removeFirst();
                batch = batch + curString;
                int n = nextSize == 0 ? curString.length() : nextSize;
                int n2 = nextSize = this.batchedData.size() > 0 ? ((String)this.batchedData.getFirst()).length() : 0;
                if ((curSize += n) + nextSize <= MAX_BATCHED_DATA_SIZE && ++executes < 32 && this.batchedData.size() != 0) continue;
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.finer("Sends batch to server:\ncurrent batch base = " + this.currentBatchBase + "\ncurrent size  = " + curSize + "\nexecutes = " + executes);
                }
                this.doTheStatement(batch, 256);
                if (this.batchUpdateCount.length != executes) {
                    throw new DbException(1, "invalid batchupdatecount array, REMARK: DDL operations not supported in batched updates");
                }
                System.arraycopy(this.batchUpdateCount, 0, ret, this.currentBatchBase, executes);
                this.currentBatchBase += executes;
                curSize = 0;
                executes = 0;
                batch = "";
            }
            int[] nArray = ret;
            return nArray;
        }
        catch (BatchUpdateException e) {
            if (this.currentBatchBase == 0) {
                throw e;
            }
            int[] updatecounts = new int[this.currentBatchBase + e.getUpdateCounts().length];
            System.arraycopy(ret, 0, updatecounts, 0, this.currentBatchBase);
            System.arraycopy(e.getUpdateCounts(), 0, updatecounts, this.currentBatchBase, e.getUpdateCounts().length);
            throw new BatchUpdateException(e.getMessage(), e.getSQLState(), e.getErrorCode(), updatecounts);
        }
        finally {
            this.doClearBatch();
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.con;
    }

    public synchronized int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    public synchronized int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return this.resultSetConcurrency;
    }

    public synchronized int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    public synchronized void setFetchDirection(int parm1) throws SQLException {
        this.checkOpen();
        if (parm1 != 1000 && parm1 != 1001 && parm1 != 1002) {
            throw new DbException(38, Integer.toString(parm1));
        }
        this.fetchDirection = parm1;
    }

    public synchronized void setFetchSize(int parm1) throws SQLException {
        this.checkOpen();
        if (parm1 < 0) {
            throw new DbException(37, Integer.toString(parm1));
        }
        if (parm1 > this.maxRows && this.maxRows > 0) {
            throw new DbException(39, "maxRows=" + this.maxRows);
        }
        this.fetchSize = parm1;
    }

    protected void checkOpen() throws SQLException {
        if (this.openState != 2) {
            throw new DbException(30);
        }
        this.con.checkOpen();
    }

    public synchronized void addWarning(SQLWarning w) {
        if (this.warnings == null) {
            this.warnings = w;
        } else {
            this.warnings.setNextWarning(w);
        }
    }

    synchronized void addWarning(RPCStatus status) {
        SQLWarning w;
        if (status != null && (w = DbException.toWarning(status)) != null) {
            this.addWarning(w);
        }
    }

    protected synchronized void clearStatement() throws SQLException {
        this.updateCount = -1;
        if (!this.isDirty() && this.rs != null) {
            this.rs.close();
        }
        this.rs = null;
        this.qd = null;
        this.ed = null;
        this.currentExeDescr = 0;
    }

    protected void finalize() throws SQLException {
        if (this.openState == 2) {
            this.doClose(false, null, this.schema);
        }
    }

    public synchronized int getTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    protected int getRowArraySize() throws SQLException {
        throw new DbException(2);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.getMoreResults();
    }

    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        this.checkOpen();
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT empty_column AS key FROM sys.dual WHERE 1=0");
        return rs;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    public synchronized int getResultSetHoldability() throws SQLException {
        this.checkOpen();
        return 2;
    }

    protected synchronized boolean isDirty() {
        return this.con.isDirty(this);
    }

    protected synchronized void setDirty(boolean flag) {
        this.con.markDirty(this, flag);
    }

    public synchronized void closeCursor() {
        this.transClosed = true;
    }

    public synchronized boolean isCursorClosed() {
        return this.transClosed;
    }

    static class SendFrameResult {
        public RPCQueryDescr qd;
        public RPCExeDescr[] ed;

        SendFrameResult() {
        }
    }
}

