/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;

class TimeColumn
extends Column {
    TimeColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
    }

    int getColumnDisplaySize() {
        return 8;
    }

    int getColumnType() {
        return 92;
    }

    String getColumnTypeName() {
        return "TIME";
    }

    Object getObject(Tuple r) throws SQLException {
        return this.getTime(r);
    }

    String getClassName() throws SQLException {
        return "java.sql.Time";
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getField(this.fieldNo).getTime(0);
    }

    Time getTime(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return new Time(this.getTimestamp(r).getTime());
    }

    Timestamp getTimestamp(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        String str = r.getField(this.fieldNo).getTime(0);
        return Timestamp.valueOf("1970-01-01 " + str);
    }

    public static boolean validTime(long hour, long minute, long second, long microsec) {
        return hour >= 0L && minute >= 0L && second >= 0L && microsec >= 0L && hour < 24L && minute < 60L && second < 62L && microsec <= 999999L;
    }

    void setString(ParameterTuple r, String str) throws SQLException {
        if (str == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        StringTokenizer tk = new StringTokenizer(str, ":");
        try {
            long microsec;
            long hourval = new Long(tk.nextToken());
            long minuteval = new Long(tk.nextToken());
            tk = new StringTokenizer(tk.nextToken(), ".");
            long secondval = new Long(tk.nextToken());
            String nanos = tk.hasMoreElements() ? tk.nextToken() : "0";
            nanos = nanos + "000000000";
            String us = nanos.substring(0, 6);
            String trunc = nanos.substring(6, 9);
            if (trunc.compareTo("000") != 0) {
                this.accessor.addWarning(new DataTruncation(this.fieldNo + 1, true, false, str.length(), 15));
            }
            if (!TimeColumn.validTime(hourval, minuteval, secondval, microsec = new Long(us).longValue()) || tk.hasMoreElements()) {
                throw new DbException(33, "'" + str + "' not accepted as a time");
            }
            if (this.hasTimezone()) {
                ExtData p = r.allocField(this.fieldNo, 10);
                p.setTimeWithTimezone(hourval, minuteval, secondval, microsec, 0, 0, 0);
            } else {
                ExtData p = r.allocField(this.fieldNo, 8);
                p.setTime(hourval, minuteval, secondval, microsec, 0);
            }
        }
        catch (Exception e) {
            throw new DbException(33, "'" + str + "' not accepted as a time", e);
        }
    }

    void setTime(ParameterTuple r, Time val) throws SQLException {
        if (val == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        this.setString(r, val.toString());
    }

    void setTimestamp(ParameterTuple r, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        String str = timestamp.toString();
        StringTokenizer tk = new StringTokenizer(str, ":.- ");
        try {
            for (int i = 0; i < 3; ++i) {
                tk.nextToken();
            }
            long hour = new Long(tk.nextToken());
            long minute = new Long(tk.nextToken());
            long second = new Long(tk.nextToken());
            long microsecond = new Long(tk.nextToken());
            if (this.hasTimezone()) {
                ExtData p = r.allocField(this.fieldNo, 10);
                p.setTimeWithTimezone(hour, minute, second, microsecond, 0, 0, 0);
            } else {
                ExtData p = r.allocField(this.fieldNo, 8);
                p.setTime(hour, minute, second, microsecond, 0);
            }
        }
        catch (Exception e) {
            throw new DbException(33, "'" + str + "' not accepted as a time/timestamp", e);
        }
    }

    private boolean hasTimezone() {
        return this.att.hasTimezone();
    }
}

