/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc.ds;

import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.JdbcLogFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class HadbDataSource
implements DataSource,
Referenceable,
Serializable {
    private int login_timeout = 0;
    private int query_timeout = 0;
    private int lock_timeout = 0;
    private int max_trans_idle = 0;
    private int max_statements = 0;
    private boolean eliminate_redundant_end_trans = false;
    private boolean cacheDatabaseMetaData = true;
    private String server_name;
    private int port_number;
    private String description;
    private String server_list;
    private String username;
    private String password;
    private Logger logger = JdbcLogFactory.getJDBCLogger();
    private static final int DEFAULT_TIMEOUT = 10;

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.username, this.password);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        String hostlist = ConnectionImpl.concatHostList(this.server_name, this.port_number, this.server_list);
        Properties info = new Properties();
        info.setProperty("logintimeout", "" + this.login_timeout);
        info.setProperty("maxtransidle", "" + this.max_trans_idle);
        info.setProperty("locktimeout", "" + this.lock_timeout);
        info.setProperty("querytimeout", "" + this.query_timeout);
        info.setProperty("eliminateredundantendtransaction", "" + this.eliminate_redundant_end_trans);
        info.setProperty("cachedatabasemetadata", "" + this.cacheDatabaseMetaData);
        if (this.logger.isLoggable(Level.CONFIG)) {
            StringBuffer sb = new StringBuffer();
            sb.append("hostlist=").append(hostlist).append(" user=").append(username).append(" logintimeout=").append(this.login_timeout).append(" maxtransidle=").append(this.max_trans_idle).append(" querytimeout=").append(this.query_timeout).append(" eliminateredundantedntransaction=").append(this.eliminate_redundant_end_trans).append(" cachedatabasemetadata=").append(this.cacheDatabaseMetaData);
            this.logger.config(sb.toString());
        }
        ConnectionImpl cc = new ConnectionImpl(hostlist, username, password, info);
        if (this.max_statements > 0) {
            cc.initializeStatementPool(this.max_statements);
        }
        return cc;
    }

    public int getLoginTimeout() throws SQLException {
        return this.login_timeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.login_timeout = seconds;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    public void setServerName(String serverName) {
        this.server_name = serverName;
    }

    public String getServerName() {
        return this.server_name;
    }

    public void setPortNumber(int portno) {
        this.port_number = portno;
    }

    public int getPortNumber() {
        return this.port_number;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    public void setServerList(String slist) {
        this.server_list = slist;
    }

    public String getServerList() {
        return this.server_list;
    }

    public void setUserName(String uname) {
        this.username = uname;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUser(String uname) {
        this.username = uname;
    }

    public String getUser() {
        return this.username;
    }

    public void setPassword(String pass) {
        this.password = pass;
    }

    private String getHostList() {
        StringBuffer buf = new StringBuffer();
        if (this.server_list != null) {
            buf.append(this.server_list);
        }
        if (this.server_name != null) {
            if (this.server_list != null) {
                buf.append(',');
            }
            buf.append(this.server_name);
            buf.append(':');
            buf.append(this.port_number);
        }
        return buf.toString();
    }

    public void setQueryTimeout(int timeout) {
        this.query_timeout = timeout;
    }

    public int getQueryTimeout() {
        return this.query_timeout;
    }

    public void setMaxTransIdle(int timeout) {
        this.max_trans_idle = timeout;
    }

    public int getMaxTransIdle() {
        return this.max_trans_idle;
    }

    public void setLockTimeout(int timeout) {
        this.lock_timeout = timeout;
    }

    public int getLockTimeout() {
        return this.lock_timeout;
    }

    public void setMaxStatements(int statements) {
        this.max_statements = statements;
    }

    public int getMaxStatements() {
        return this.max_statements;
    }

    public void setEliminateRedundantEndTransaction(boolean eliminate) {
        this.eliminate_redundant_end_trans = eliminate;
    }

    public boolean getEliminateRedundantEndTransaction() {
        return this.eliminate_redundant_end_trans;
    }

    public void setCacheDatabaseMetaData(boolean cache) {
        this.cacheDatabaseMetaData = cache;
    }

    public boolean getCacheDatabaseMetaData() {
        return this.cacheDatabaseMetaData;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.sun.hadb.jdbc.ds.HadbDSFactory", null);
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("portNumber", "" + this.getPortNumber()));
        ref.add(new StringRefAddr("serverList", this.getHostList()));
        ref.add(new StringRefAddr("logintimeout", "" + this.login_timeout));
        ref.add(new StringRefAddr("queryTimeout", "" + this.query_timeout));
        ref.add(new StringRefAddr("locktimeout", "" + this.lock_timeout));
        ref.add(new StringRefAddr("maxtransidle", "" + this.max_trans_idle));
        ref.add(new StringRefAddr("maxstatements", "" + this.max_statements));
        ref.add(new StringRefAddr("eliminateRedundantEndTransaction", "" + this.eliminate_redundant_end_trans));
        ref.add(new StringRefAddr("cacheDatabaseMetaData", "" + this.cacheDatabaseMetaData));
        return ref;
    }
}

