/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc.pool;

import com.sun.hadb.jdbc.pool.HadbPooledConnection;
import com.sun.hadb.jdbc.pool.PoolLogFactory;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;

class ConnectionCache {
    private LinkedList clist;
    private Logger logger = PoolLogFactory.getPoolLogger();

    public ConnectionCache() {
        this.clist = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledConnection getPooledConnection(String user, String pass) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("getPooledConnection:");
            this.logger.fine(this.getCacheInfo());
        }
        LinkedList linkedList = this.clist;
        synchronized (linkedList) {
            ListIterator li = this.clist.listIterator(0);
            while (li.hasNext()) {
                CacheEntry ce = (CacheEntry)li.next();
                if (!this.isMatch(user, pass, ce.user, ce.pass)) continue;
                li.remove();
                try {
                    if (ce.pconn != null && ce.pconn.getPhysical() != null && !ce.pconn.getPhysical().isClosed()) {
                        this.logger.finest("getPooledConnection:  found sane connection");
                        return ce.pconn;
                    }
                    this.logger.finest("getPooledConnection: connection in pool was not sane");
                }
                catch (SQLException e) {
                    this.logger.log(Level.FINE, "Exception in connection retrieval", e);
                }
            }
        }
        return null;
    }

    private boolean isMatch(String user1, String pass1, String user2, String pass2) {
        if (user1 == null && user2 == null && pass1 == null && pass2 == null) {
            return true;
        }
        return user1 != null && user2 != null && user1.equals(user2) && pass1.equals(pass2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(HadbPooledConnection pc) {
        CacheEntry ce = new CacheEntry();
        ce.user = pc.getUser();
        ce.pass = pc.getPassword();
        ce.pconn = pc;
        LinkedList linkedList = this.clist;
        synchronized (linkedList) {
            this.clist.addFirst(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCacheInfo() {
        StringBuffer sb = new StringBuffer();
        LinkedList linkedList = this.clist;
        synchronized (linkedList) {
            ListIterator li = this.clist.listIterator(0);
            while (li.hasNext()) {
                CacheEntry ce = (CacheEntry)li.next();
                sb.append(ce.user).append(" : ");
                sb.append(ce.pconn.toString()).append('\n');
            }
        }
        return sb.toString();
    }

    public void printCache() {
        System.out.println(this.getCacheInfo());
    }

    class CacheEntry {
        public String user;
        public String pass;
        public HadbPooledConnection pconn;
        public long last_used;

        CacheEntry() {
        }
    }
}

