/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc.pool;

import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.LOBDescr;
import com.sun.hadb.jdbc.LobConnection;
import com.sun.hadb.jdbc.pool.HadbPooledConnection;
import com.sun.hadb.jdbc.pool.PoolLogFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Logger;

public class ShadowConnection
implements Connection,
LobConnection {
    private ConnectionImpl phys = null;
    private HadbPooledConnection master = null;
    private Logger logger = PoolLogFactory.getPoolLogger();

    public ShadowConnection(HadbPooledConnection master_obj, ConnectionImpl physical_conn) throws SQLException {
        this.phys = physical_conn;
        this.master = master_obj;
        SQLException exc = null;
        for (int i = 0; i < 5; ++i) {
            try {
                this.setAutoCommit(true);
                this.setTransactionIsolation(4);
                this.logger.fine("ShadowConnection: Acquired sane connection at attempt #" + i);
                return;
            }
            catch (SQLException e) {
                this.logger.fine("ShadowConnection: connection attempt " + i + " fails with code=" + e.getErrorCode());
                if (e.getErrorCode() != 25018) {
                    throw e;
                }
                exc = e;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                continue;
            }
        }
        if (exc == null) {
            throw new DbException(1);
        }
        throw exc;
    }

    public boolean isValid() {
        if (this.phys == null) {
            return false;
        }
        try {
            this.phys.setAutoCommit(true);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        this.logger.finest("ShadowConnection.close()");
        this.commit();
        this.master.freeConnection();
        this.phys = null;
    }

    public void commit() throws SQLException {
        this.checkOpen();
        this.phys.commit();
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        this.phys.rollback();
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.phys.clearWarnings();
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this.phys.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this.phys.createStatement(resultSetType, resultSetConcurrency);
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.phys.getCatalog();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this.phys.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.phys.getTransactionIsolation();
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.phys.getAutoCommit();
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return this.phys.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.phys.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.phys == null;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.phys.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return this.phys.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        return this.phys.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this.phys.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return this.phys.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkOpen();
        return this.phys.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public void setAutoCommit(boolean ac) throws SQLException {
        this.checkOpen();
        this.phys.setAutoCommit(ac);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this.phys.setCatalog(catalog);
    }

    public void setReadOnly(boolean b) throws SQLException {
        this.checkOpen();
        this.phys.setReadOnly(b);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        this.phys.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this.phys.setTypeMap(map);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        this.phys.setHoldability(holdability);
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this.phys.getHoldability();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        return this.phys.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        return this.phys.setSavepoint(name);
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this.phys.rollback(savepoint);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this.phys.releaseSavepoint(savepoint);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return this.phys.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return this.phys.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        return this.phys.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        return this.phys.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        return this.phys.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        return this.phys.prepareStatement(sql, columnNames);
    }

    public void createLobTable(String schema, String table_name) throws SQLException {
        this.checkOpen();
        this.phys.createLobTable(schema, table_name);
    }

    public void dropLobTable(String schema, String table_name) throws SQLException {
        this.checkOpen();
        this.phys.dropLobTable(schema, table_name);
    }

    public PreparedStatement prepareLobStatement(String query, LOBDescr lob_descr) throws SQLException {
        this.checkOpen();
        return this.phys.prepareLobStatement(query, lob_descr);
    }

    private void checkOpen() throws SQLException {
        if (this.phys == null) {
            throw new DbException(4);
        }
    }
}

