/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.dbstate;

import com.sun.hadb.mgt.AdminUser;
import com.sun.hadb.mgt.DatabaseState;
import com.sun.hadb.mgt.MgtException;
import com.sun.hadb.mgt.api.Database;
import com.sun.hadb.mgt.api.MAConnection;
import com.sun.hadb.mgt.api.MAConnectionPool;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbState {
    public static final int STATE_HA_FAULT_TOLERANT = 50;
    public static final int STATE_FAULT_TOLERANT = 40;
    public static final int STATE_OPERATIONAL = 30;
    public static final int STATE_NON_OPERATIONAL = 20;
    public static final int STATE_STOPPED = 10;
    public static final int STATE_UNKNOWN = -10;
    public static final int STATE_MA_NOT_REACHABLE = -20;
    public static final int STATE_HOST_NOT_FOUND = -30;
    public static final int STATE_DB_NOT_FOUND = -40;
    private final String url;
    private final String dbName;
    private final AdminUser user;
    private MAConnection maConnection = null;
    private final MAConnectionPool maConnPool;
    private Database db = null;

    private Logger getLogger() {
        return Logger.getLogger("com.sun.hadb.dbstate");
    }

    private void connect() {
        block5: {
            if (this.maConnection == null) {
                this.db = null;
                try {
                    this.maConnection = this.maConnPool.getConnection(10000L);
                    if (this.maConnection == null) {
                        this.getLogger().log(Level.WARNING, "Timed out connecting");
                    } else {
                        this.db = this.maConnection.getDomain().getDatabase(this.dbName);
                    }
                }
                catch (MgtException e) {
                    this.getLogger().log(Level.WARNING, "Failed connecting / getting db", e);
                    if (e.getErrorCode() == 21009 || this.maConnection == null) break block5;
                    this.maConnection.close();
                    this.maConnection = null;
                }
            }
        }
    }

    public DbState(String url, String db_name, String password) {
        this.url = url;
        this.dbName = db_name;
        this.user = new AdminUser("admin");
        this.user.setPassword(password);
        this.user.useAdminPassword(true);
        this.maConnPool = MAConnectionPool.createPool((String)url, (AdminUser)this.user, (boolean)true, (String)db_name);
    }

    public boolean isAvailable() {
        return this.getState() >= 30;
    }

    public int getState() {
        try {
            if (this.db != null) {
                DatabaseState dbState = this.db.getState();
                return this.adaptEnumeration(dbState);
            }
        }
        catch (MgtException e) {
            this.getLogger().log(Level.WARNING, "Failed getting state", e);
            this.maConnection.close();
            this.db = null;
            this.maConnection = null;
        }
        this.connect();
        if (this.maConnection == null) {
            return -20;
        }
        if (this.db == null) {
            this.maConnection.close();
            this.maConnection = null;
            return -40;
        }
        try {
            DatabaseState dbState = this.db.getState();
            return this.adaptEnumeration(dbState);
        }
        catch (MgtException e) {
            this.getLogger().log(Level.WARNING, "Failed getting state", e);
            this.maConnection.close();
            this.db = null;
            this.maConnection = null;
            return -20;
        }
    }

    private int adaptEnumeration(DatabaseState dbState) {
        if (dbState == DatabaseState.haFaultTolerant) {
            return 50;
        }
        if (dbState == DatabaseState.faultTolerant) {
            return 40;
        }
        if (dbState == DatabaseState.operational) {
            return 30;
        }
        if (dbState == DatabaseState.nonOperational) {
            return 20;
        }
        if (dbState == DatabaseState.stopped) {
            return 10;
        }
        return -10;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("usage:  DbState <url> <dbname> <password>");
            return;
        }
        DbState dbstate = new DbState(args[0], args[1], args[2]);
        for (int i = 0; i < 1000; ++i) {
            Thread.sleep(1000L);
            System.out.println("Response: " + dbstate.getState());
        }
    }
}

