/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.ee.admin.mbeans;

import com.sun.logging.ee.EELogDomains;
import java.util.logging.Logger;

import java.util.Set;
import java.util.HashSet;

import javax.management.*;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.ee.admin.mbeanapi.ClusterConfigMBean;
import com.sun.enterprise.admin.servermgmt.InstanceException;

public class ClusterApplicationRefMBean
    extends EEBaseConfigMBean
    implements com.sun.enterprise.ee.admin.mbeanapi.ClusterApplicationRefMBean, MBeanRegistration
{               
    private static final Logger _logger = Logger.getLogger(EELogDomains.EE_ADMIN_LOGGER);            
    
    public ClusterApplicationRefMBean() {
        super();
    }
    
    /**
        Get the server names in a cluster.
     */
    private Set<String> getInstanceNames( final String clusterName ) throws MBeanException {
        final ObjectName clusterObjectName = getClusterObjectName(clusterName);
        final ClusterConfigMBean clusterConfig = ClusterConfigMBean.class.cast(
            MBeanServerInvocationHandler.newProxyInstance( getMBeanServer(), clusterObjectName, ClusterConfigMBean.class, false ) );
    
        try{
            return GSetUtil.newSet( clusterConfig.listServerInstancesAsString(false) );
        } catch (final InstanceException e ) {
            throw new MBeanException(e);
        }
    }
    
    /**
        Find all server application-refs with the specified refName.  Exclude application refs
        on clusters.
     */
    private Set<ObjectName> getServerApplicationRefsByRef( final String refName ) {
        final String ps = getSelfObjectName().getDomain() + ":type=application-ref,category=config,ref=" + refName + ",*";
        final ObjectName pattern = JMXUtil.newObjectName(ps);
        final Set<ObjectName> candidates = JMXUtil.queryNames( getMBeanServer(), pattern, null );
        
        // exclude refs on clusters; we just want those on servers
        final Set<ObjectName> result = new HashSet<ObjectName>();
        for( final ObjectName c : candidates ) {
            // ex: com.sun.appserv:type=application-ref,category=config,cluster=c1,ref=hello (don't want these)
            if ( c.getKeyProperty("cluster") == null ) {
                result.add(c);
            }
        }
        return result;
    }
    
    // 'Attribute' doesn't supply a toString
    private String toString( final Attribute a ) {
        return a.getName() + "=" + a.getValue();
    }
    
    private static final Set<String> WRITE_THROUGH_ATTR_NAMES = GSetUtil.newUnmodifiableStringSet( "virtual-servers", "enabled" );
    
    /**
        Certain attributes in application-refs belonging to clustered servers are server specific,
        and others should be held consistent with the cluster eg "written through".
     */
    private static boolean isWriteThroughAttribute( final String name ) {
        return WRITE_THROUGH_ATTR_NAMES.contains(name);
    }
    
    /**
        Write the attribute to all application-ref elements belonging to servers in the cluster.
    */
        private void
    writeThroughToServers( final Attribute attr )
        throws MBeanException {
        /*
            If this is a clustered application-ref, it will an ObjectName like this:
            com.sun.appserv:type=application-ref,category=config,cluster=c1,ref=hello
            Verify that it is indeed a cluster ref.
        */
        final ObjectName selfObjectName = getSelfObjectName();
        final String clusterName = selfObjectName.getKeyProperty("cluster");
        // sanity check to verify this is a ref for a cluster
        if ( clusterName != null )  { 
            // apply the change to all servers in this cluster
            final MBeanServer mbs = getMBeanServer();
            final String refName  = selfObjectName.getKeyProperty("ref");

            // find all server application refs that contain the same refName as this clustered one
            final Set<ObjectName> appRefCandidates = getServerApplicationRefsByRef(refName);

            // include only those servers in this cluster
            final Set<String> instanceNames = getInstanceNames(clusterName);
            final Set<ObjectName> items = new HashSet<ObjectName>();
            for( final ObjectName c : appRefCandidates ) {
                // ex: com.sun.appserv:type=application-ref,category=config,ref=hello,server=c1-i1
                final String serverName = c.getKeyProperty( "server" );
                if ( instanceNames.contains(serverName) ) {
                    items.add(c);
                }
            }
            
            // set the same attribute on all application refs that belong to servers in this cluster
            for( final ObjectName appRefObjectName : items ) {
                try {
                    mbs.setAttribute( appRefObjectName, attr );
                    //_logger.info( "ClusterApplicationRefMBean: set attribute " + toString(attr) + " on " + appRefObjectName );
                }
                catch ( final JMException e ) {
                    //_logger.warning( "ClusterApplicationRefMBean: FAILED to set attribute " + toString(attr) + " on " + appRefObjectName );
                    // keep trying with the other ones
                }
            }
        }
    }
    
    @Override
    public void setAttribute( final Attribute attr)
        throws AttributeNotFoundException, MBeanException, ReflectionException
    {
        //_logger.info( "ClusterApplicationRefMBean.setAttribute: " + attr.getName() + "=" + attr.getValue() );
        super.setAttribute( attr );

        if ( isWriteThroughAttribute(attr.getName()) ) {
            writeThroughToServers(attr);
        }
    }
}






































