<!--
 DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 
 Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 
 The contents of this file are subject to the terms of either the GNU
 General Public License Version 2 only ("GPL") or the Common Development
 and Distribution License("CDDL") (collectively, the "License").  You
 may not use this file except in compliance with the License. You can obtain
 a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 language governing permissions and limitations under the License.
 
 When distributing the software, include this License Header Notice in each
 file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 Sun designates this particular file as subject to the "Classpath" exception
 as provided by Sun in the GPL Version 2 section of the License file that
 accompanied this code.  If applicable, add the following below the License
 Header, with the fields enclosed by brackets [] replaced by your own
 identifying information: "Portions Copyrighted [year]
 [name of copyright owner]"
 
 Contributor(s):
 
 If you wish your version of this file to be governed by only the CDDL or
 only the GPL Version 2, indicate your decision by adding "[Contributor]
 elects to include this software in this distribution under the [CDDL or GPL
 Version 2] license."  If you don't indicate a single choice of license, a
 recipient has the option to distribute your version of this file under
 either the CDDL, the GPL Version 2 or to extend the choice of license to
 its licensees as provided above.  However, if you add GPL Version 2 code
 and therefore, elected the GPL Version 2 license, then the option applies
 only if the new code is made subject to such option by the copyright
 holder.
-->
<!-- shared/monitorRuntime_2.jsf -->
        <!-- Page Title -->
                <sun:title id="propertyContentPage" title="$resource{i18n.tree.monitoring}" 
                    helpText="$resource{i18n.MonitoringPageHelp}"> 
                    <!-- Buttons  -->                    
                    <!facet pageButtonsTop>
                    <sun:panelGroup id="topButtons">
                        <sun:button id="refreshButton" 
                            text="$resource{i18n.button.Refresh}">
                            <!command
                                redirect(page="../$pageSession{parent}/monitorRuntime.jsf?instanceName=$pageSession{instanceName}&configName=$pageSession{configName}&selectedValue=#{viewVal}");
                            />              
                        </sun:button>
                    </sun:panelGroup>
                    </facet>                     
                </sun:title>
                <!-- PropertySheet .... -->
                <sun:propertySheet id="propertySheet">
                    <sun:propertySheetSection id="viewPropertySection">
                        <sun:property id="ViewProp"  labelAlign="left" noWrap="#{true}" overlapLabel="#{false}" label="$resource{i18n.jvmReport.viewLabel}" >
                            <sun:dropDown id="View" selected="#{viewVal}" items="$attribute{monitorList}" submitForm="#{true}" immediate="#{true}" >
                                <!beforeCreate
                                    setAttribute(key="MonitorObjects" value={
                                            "com.sun.appserv:type=jvm,category=monitor,server=$pageSession{instanceName}", 
                                            "com.sun.appserv:type=http-service,category=monitor,server=$pageSession{instanceName}", 
                                            "com.sun.appserv:type=orb,category=monitor,server=$pageSession{instanceName}", 
                                            "com.sun.appserv:type=thread-pools,category=monitor,server=$pageSession{instanceName}", 
                                            "com.sun.appserv:type=transaction-service,category=monitor,server=$pageSession{instanceName}"
				    });
				    if(#{SipConfigBean.enabled}) {
					updateMonitorObjectsForSip(MonitorObjects="#{MonitorObjects}",
					    instanceName="$pageSession{instanceName}",
					    MonitorObjects=>$attribute{MonitorObjects});
				    }
				    populateMonitorDropDown(
                                        MonitorObjects="#{MonitorObjects}"
                                        DoGrouping="#{true}"
                                        MonitorList=>$attribute{monitorList}
                                        ObjectName=>$pageSession{viewVal});
				    if( $pageSession{selectedValue}){
					setAttribute(key="viewVal" value="#{selectedValue}")
				    }
                                    getStatisticData(
                                        MonitorObject="#{viewVal}"
                                        StatisticData=>$attribute{statisticData});
                                />
                                <!command
                                    setAttribute(key="click" value="$this{component}");
                                    setAttribute(key="viewVal" value="#{click.selected}")
                                    setAttribute(key="instanceName" value="#{instanceName}")
                                    setAttribute(key="monitorList" value="#{monitorList}");
                                    navigate(page="/$pageSession{parent}/monitorRuntime.jsf");
                                />
                            </sun:dropDown>
                            "&nbsp;
                            <sun:hyperlink 
                                id="configMonitoringLink"
                                text="$resource{i18n.monitor.configureLink}"
                                url="../configuration/monitoringService.jsf?configName=#{pageSession.configName}"/>
                        </sun:property>
                    </sun:propertySheetSection>
                </sun:propertySheet>
                "<br />
                <sun:table id="statistics" title="$resource{i18n.monitoring.runtime.table.title}">
                    <sun:tableRowGroup id="rowGroup1" data={"$attribute{statisticData}"} sourceVar="td">
                        <sun:tableColumn headerText="$resource{i18n.common.name.header}" rowHeader="$boolean{true}" id="col1">
                             <staticText id="name" value="#{td.value.Name}" />
                        </sun:tableColumn>
                        <sun:tableColumn headerText="$resource{i18n.common.PropertyValue}" rowHeader="$boolean{true}" id="col2">
                            <staticText id="value" value="#{td.value.Value}" />
                        </sun:tableColumn>
                        <sun:tableColumn headerText="$resource{i18n.monitoring.details.header}" rowHeader="$boolean{true}" id="col3">
                            <staticText id="details" value="#{td.value.Details}" />
                            <staticText id="lastSampleTime" value="$resource{i18n.monitoring.LastSample}: #{td.value.LastSampleTime}" />                              
                            "<br/>
                            <staticText id="startTime" value="$resource{i18n.monitoring.StartTime}: #{td.value.StartTime}" />
                        </sun:tableColumn>
                        <sun:tableColumn headerText="$resource{i18n.common.description.header}" rowHeader="$boolean{true}" id="col4">
                            <staticText id="description" value="#{td.value.Description}" />
                        </sun:tableColumn>
                   </sun:tableRowGroup>
                </sun:table>
	<sun:hidden id="helpKey" value="$attribute{helpKey}" />
            </sun:form>
        </sun:body>
    </sun:html>
</sun:page>
