/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.extensions.comms;

// sip cannot have dependencies on JBI! import com.sun.jbi.jsf.bean.ListBean;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.jsftemplating.annotation.Handler;
import com.sun.jsftemplating.annotation.HandlerInput;
import com.sun.jsftemplating.annotation.HandlerOutput;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.MessageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;

/**
 *
 * @author irfan
 */
public class SipUtilities {

    public static final String SIP_PACKAGE = "org.jvnet.glassfish.comms.admin.gui.extensions";
    public static final String SIP_UTIL_CLASS = SIP_PACKAGE + ".util.SipUtil";
    public static final String SAILFIN_REGISTRY = "registry.properties";
    public static final String SIP_MODULE_TYPE =
            "org.jvnet.glassfish.comms.deployment.backend.SipArchiveDeployer";
    public static final String SIP_RESOURCE_BUNDLE =
            "org.jvnet.glassfish.comms.admin.gui.extensions.resources.Strings";
    static private Map<String, String> editMap = new HashMap();
    static {
        editMap.put("sipModule", "sipModuleEdit.jsf");
        editMap.put("convergedSipModule", "sipModuleEdit.jsf");
    }

    /** Creates a new instance of SipUtilities */
    public SipUtilities() {
    }

    public static SipConfigBean getSipConfigBean() {
        SipConfigBean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve =
                // sip cannot have dependencies on JBI!  ef.createValueExpression(elCtx, "#{SipConfigBean}", ListBean.class);
                ef.createValueExpression(elCtx, "#{SipConfigBean}", SipConfigBean.class);
        result = (SipConfigBean) ve.getValue(elCtx);
        return result;
    }

    public static boolean isEnabled() {
        Boolean result = null;
        FacesContext fCtx = FacesContext.getCurrentInstance();
        ELContext elCtx = fCtx.getELContext();
        ExpressionFactory ef = fCtx.getApplication().getExpressionFactory();
        ValueExpression ve =
                ef.createValueExpression(elCtx, "#{SipConfigBean.enabled}", Boolean.class);
        result = (Boolean) ve.getValue(elCtx);
        return result;
    }

    /** Sets SIP specific product information attributes */
    @Handler(id = "initSipProductInfoAttributes")
    public static void initSipProductInfoAttributes(HandlerContext handlerContext) {
        Map sessionMap = handlerContext.getFacesContext().getExternalContext().getSessionMap();

        //Ensure this method is called once per session
        Object initialized = sessionMap.get("_SIP_INFO_SESSION_INITIALIZED");
        if (initialized != null) {
            return;
        }

        MessageUtil msgUtil = MessageUtil.getInstance();

        // Initialize Product Specific Attributes
        sessionMap.put("productImageURL", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productImage.URL"));
        int prodImageHeight = 23;
        int prodImageWidth = 422;
        try {
            prodImageWidth = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productImage.width"));
            prodImageHeight = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productImage.height"));
        } catch (Exception ex) {
            //use the preset values.
        }
        sessionMap.put("productImageWidth", prodImageWidth);
        sessionMap.put("productImageHeight", prodImageHeight);

        sessionMap.put("loginProductImageURL", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "login.productImage.URL"));
        int loginProdImageHeight = 40;
        int loginProdImageWidth = 455;
        try {
            loginProdImageWidth = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "login.productImage.width"));
            loginProdImageHeight = Integer.parseInt(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "login.productImage.height"));
        } catch (Exception ex) {
            //use preset values.
        }
        sessionMap.put("loginProductImageWidth", loginProdImageWidth);
        sessionMap.put("loginProductImageHeight", loginProdImageHeight);


        sessionMap.put("fullProductName", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "productName.full"));
        sessionMap.put("productVersion", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "product.version"));
        sessionMap.put("loginButtonTooltip", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "loginButton.tooltip"));
        sessionMap.put("mastHeadDescription", msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "mastHeadDescription"));

        sessionMap.put("showLoadBalancer", false);
        sessionMap.put("logoutConfirmMsg", msgUtil.getMessage(SIP_RESOURCE_BUNDLE,
                "logoutConfirmMsg"));
        sessionMap.put("upsellingURLPE", msgUtil.getMessage(SIP_RESOURCE_BUNDLE,
                "upselling.comms.url.pe"));
        sessionMap.put("upsellingURLEE", msgUtil.getMessage(SIP_RESOURCE_BUNDLE,
                "upselling.comms.url.ee"));

        // Set the URN for Communications Server
        String productURN = "urn:uuid:555af591-db3b-11dc-ac55-080020a9ed93";
        String installRoot = System.getProperty(SystemPropertyConstants.INSTALL_ROOT_PROPERTY);
        try {
            File sailfinRegistry = new File(installRoot, SAILFIN_REGISTRY);
            Properties props = new Properties();
            props.load(new FileInputStream(sailfinRegistry));
            productURN = props.getProperty("product.urn");
        } catch (Exception ex) {
            //take the hard coded value in this case.
        }
        sessionMap.put("productInstanceURN", productURN);

        sessionMap.put("_SIP_INFO_SESSION_INITIALIZED", "TRUE");
    }

    /** The function is used to set SIP filter data for Call Flow
     *
     * @param handlerContext This will contain filterLabels and filterValues list which will be updated with
     *	SIP specific values.
     */
    @Handler(id = "updateCallFlowFiltersForSip",
    input = {
        @HandlerInput(name = "filterLabels", type = List.class),
        @HandlerInput(name = "filterValues", type = List.class)
    },
    output = {
        @HandlerOutput(name = "filterListValue", type = List.class),
        @HandlerOutput(name = "filterListLabel", type = List.class)
    })
    public static void updateCallFlowFiltersForSip(HandlerContext handlerContext) {
        ArrayList label = new ArrayList((List) handlerContext.getInputValue("filterLabels"));
        MessageUtil msgUtil = MessageUtil.getInstance();
        label.add(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "callFlow.remoteSip.label"));

        ArrayList value = new ArrayList((List) handlerContext.getInputValue("filterValues"));
        value.add("REMOTE_SIP");
        handlerContext.setOutputValue("filterListValue", value);
        handlerContext.setOutputValue("filterListLabel", label);
    }

    /**
     *	The function adds the SIP/Converged-SIP modules to the applications table which is
     *	displayed when a user clicks on Clusters > Cluster Name > Applications tab
     */
    @Handler(id = "updateSIPApplications",
    input = {
        @HandlerInput(name = "target", type = String.class, required = true),
        @HandlerInput(name = "filterValue", type = String.class),
        @HandlerInput(name = "isServer", type = Boolean.class, required = true),
        @HandlerInput(name = "gfApps", type = java.util.List.class)
    },
    output = {
        @HandlerOutput(name = "result", type = java.util.List.class),
        @HandlerOutput(name = "hasLB", type = Boolean.class)
    })
    public static void updateSIPApplications(HandlerContext handlerContext) {
        String target = (String) handlerContext.getInputValue("target");
        String filterValue = (String) handlerContext.getInputValue("filterValue");
        boolean isServer = ((Boolean) handlerContext.getInputValue("isServer")).booleanValue();
        Collection<DeployedItemRefConfig> refs = new ArrayList();
        List result = (ArrayList) handlerContext.getInputValue("gfApps");

        if (isServer) {
            StandaloneServerConfig server = AMXUtil.getDomainConfig().getStandaloneServerConfigMap().get(target);
            refs = server.getDeployedItemRefConfigMap().values();
            Map lbMap = AMXUtil.getLBConfigHelper().getLoadBalancers(target, false);
            handlerContext.setOutputValue("hasLB", !lbMap.isEmpty());
        } else {
            ClusterConfig cluster = AMXUtil.getDomainConfig().getClusterConfigMap().get(target);
            refs = cluster.getDeployedItemRefConfigMap().values();
            Map lbMap = AMXUtil.getLBConfigHelper().getLoadBalancers(target, true);
            handlerContext.setOutputValue("hasLB", !lbMap.isEmpty());
        }

        HashMap<String, HashMap> sipModules = getSipModulesInfo();

        for (DeployedItemRefConfig refObject : refs) {
            String appName = refObject.getName();
            HashMap sipModuleInfo = sipModules.get(appName);

            if ((sipModuleInfo != null) && includeSipApp(filterValue,
                    (String) sipModuleInfo.get("appType"))) {
                Map oneRow = new HashMap();
                String appType = (String) sipModuleInfo.get("appType");
                boolean hasContextRoot = false;
                if ("convergedSipModule".equals(appType)) {
                    hasContextRoot = true;
                }
                oneRow.put("enabled", refObject.getEnabled() ? "true" : "false");
                oneRow.put("lbEnabled", refObject.getLBEnabled() ? "true" : "false");
                oneRow.put("timeout", refObject.getDisableTimeoutInMinutes());
                oneRow.put("name", appName);
                oneRow.put("selected", false);
                oneRow.put("link", "/sip/applications/" + editMap.get(appType) +
                        "?appName=" + appName + "&hasContextRoot=" + hasContextRoot);
                oneRow.put("appType", sipModuleInfo.get("appTypeLabel"));
                oneRow.put("objectName", "" + com.sun.appserv.management.base.Util.getObjectName(refObject));
                result.add(oneRow);
            }
        }

        handlerContext.setOutputValue("result", result);
    }

    public static HashMap<String, HashMap> getSipModulesInfo() {
        String methodName = "getDeployedSIPModules";
        if (isEnabled()) {
            try {
                Class sipUtilClass = Class.forName(SIP_UTIL_CLASS);
                Method getSipModulesInfo = sipUtilClass.getDeclaredMethod(methodName);
                HashMap<String, HashMap> modulesMap =
                        (HashMap<String, HashMap>) getSipModulesInfo.invoke(null);
                return modulesMap;
            } catch (Exception ex) {
            }
        }
        return null;
    }

    private static boolean includeSipApp(String filterValue, String sipAppType) {
        if (GuiUtil.isEmpty(filterValue)) {
            return true;
        }

        return filterValue.equals(sipAppType);
    }

    @Handler(id = "updateSipAppFilterTypes",
    input = {
        @HandlerInput(name = "labels", type = List.class),
        @HandlerInput(name = "values", type = List.class)
    },
    output = {
        @HandlerOutput(name = "labels", type = java.util.List.class),
        @HandlerOutput(name = "values", type = java.util.List.class)
    })
    public static void updateSipAppFilterValues(HandlerContext handlerContext) {
        List labels = (ArrayList) handlerContext.getInputValue("labels");
        List values = (ArrayList) handlerContext.getInputValue("values");

        MessageUtil msgUtil = MessageUtil.getInstance();
        labels.add(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "sipModules.label"));
        labels.add(msgUtil.getMessage(SIP_RESOURCE_BUNDLE, "convergedSipModules.label"));

        values.add("sipModule");
        values.add("convergedSipModule");

        handlerContext.setOutputValue("labels", labels);
        handlerContext.setOutputValue("values", values);
    }

    /** The function is used to set SIP Monitoring Objects for runtime monitoring information
     */
    @Handler(id = "updateMonitorObjectsForSip",
    input = {
        @HandlerInput(name = "MonitorObjects", type = List.class),
        @HandlerInput(name = "instanceName", type = String.class)
    },
    output = {
        @HandlerOutput(name = "MonitorObjects", type = List.class)
    })
    public static void updateMonitorObjectsForSip(HandlerContext handlerContext) {
        ArrayList objects = (ArrayList) handlerContext.getInputValue("MonitorObjects");
        if (objects == null) {
            objects = new ArrayList();
        }
        String instanceName = (String) handlerContext.getInputValue("instanceName");
        objects.add("com.sun.appserv:type=sip-service,category=monitor,server=" + instanceName);

        handlerContext.setOutputValue("MonitorObjects", objects);
    }

    /**
     *  The function is called from the subComponentsTable to update the SIP components of an enterprise
     *  application (EAR) file.
     * @param handlerContext
     * @throws java.lang.Exception
     */
    @Handler(id = "updateSipApplicationSubComponentsInfo", input = {
        @HandlerInput(name = "appName", type = String.class, required = true),
        @HandlerInput(name = "appType", type = String.class, required = true),
        @HandlerInput(name = "components", type = List.class)
    },
    output = {
        @HandlerOutput(name = "result", type = java.util.List.class)
    })
    public static void updateSipApplicationSubComponentsInfo(HandlerContext handlerContext)
            throws Exception {
        String appName = (String) handlerContext.getInputValue("appName");
        String appType = (String) handlerContext.getInputValue("appType");

        if (isEnabled() && "application".equals(appType)) {
            List result = (List) handlerContext.getInputValue("components");
            List updatedList = (List) invoke(SIP_UTIL_CLASS, "getSipApplicationSubComponents",
                    new Object[]{appName}, new Class[]{String.class});
            if (updatedList != null && updatedList.size() > 0) {
                result.addAll(updatedList);
            }
            handlerContext.setOutputValue("result", result);
        }
    }

   @Handler(id = "updateCallFlowDetail",
        input = {
            @HandlerInput(name = "instanceName", type = String.class, required = true),
            @HandlerInput(name = "requestId", type = String.class, required = true),
            @HandlerInput(name = "infoMap", type = java.util.Map.class)},
        output = {
            @HandlerOutput(name = "detailInfo", type = java.util.Map.class)
    })
    public static void updateCallFlowDetail(HandlerContext handlerContext) {
        // call the method in SailFin code
        if (isEnabled()) {
            String className = SIP_PACKAGE + ".handlers.SipCallFlowHandlers";
            String methodName = "updateCallFlowDetail";
            invoke(className, methodName, new Object[]{handlerContext},
                    new Class[]{HandlerContext.class});
        }
    }

    public static Object invoke(String className, String methodName, Object[] args, Class[] types) {
        try {
            Class sipClass = Class.forName(className);
            Method method = sipClass.getDeclaredMethod(methodName, types);
            Object retValue = method.invoke(sipClass, args);
            return retValue;
        } catch (Exception ex) {
            return null;
        }
    }
}
