/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 *  JBIHookBean.java 
 */

package com.sun.jbi.jsf.bean;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class JBIHookBean
{
    /**
     * Determines whether the JBI Console Extension and underlying
     * JBI implementation can be used
     */
    public JBIHookBean()
    {
	boolean isJbiAdminCommonJarFound = false;
	boolean isJbiAdminGuiJarFound = false;

	final String BEAN_NAME = "JBIConfigBean";
	final String CLASS_NAME = "com.sun.jbi.jsf.bean.JBIConfigBean"; // in jbi-admin-gui.jar
	final String EXCEPTION_CLASS_NAME = "com.sun.jbi.ui.common.JBIRemoteException"; // in jbi-admin-common.jar

	// first sanity check: is jbi/lib/jbi-admin-gui.jar in the classpath?
	try
	    {
		Class beanClass = Class.forName(CLASS_NAME);
		Object bean = beanClass.newInstance();
		FacesContext facesContext = FacesContext.getCurrentInstance();
		facesContext.getExternalContext().getSessionMap().put(BEAN_NAME, bean);
		isJbiAdminGuiJarFound = true;
		mLog.fine("JBIHookBean.<init>(): isJbiAdminGuiJarFound=" +
			  isJbiAdminGuiJarFound); 
	    }
	catch (Exception ex)
	    {
                mLog.log(Level.FINE,
			 "JBIHookBean.<init>() exception, isJbiAdminGuiJarFound=false",
			 ex);
	    }
	
	// second sanity check: is jbi/lib/jbi-admin-common.jar also in the classpath?
	if (isJbiAdminGuiJarFound)
	    {
		try
		    {
			Object o = Class.forName(EXCEPTION_CLASS_NAME);
			isJbiAdminCommonJarFound = true;
			mLog.fine("JBIHookBean.<init>(): isJbiAdminCommonJarFound=" +
				  isJbiAdminCommonJarFound); 
			mIsJbiJarsAvailable = true; // all checks passed
		    }
		catch (Exception ex)
		    {
			mLog.log(Level.FINE,
				 "JBIHookBean.<init>() exception, isJbiAdminCommonJarFound=false",
				 ex);
		    }
		
		
		mLog.fine("JBIHookBean.<init>(): mIsJbiJarsAvailable=" +
			  mIsJbiJarsAvailable);
	    }
    }
	
    /**
     * checks for a usable JBI runtime (JBI's JSF tags use this to conditionally render JBI views.
     * any missing required jar files results in no JBI tree node or tabs in the console.
     * @return true if the JBI console implementation, common client, and runtime are all available
     */
    public boolean isJbiJarsAvailable()
    {
	boolean result =  mIsJbiJarsAvailable;
	mLog.fine("JBIHookBean.isJbiJarsAvailable(): result=" + result); 
	return result;
    }

    /**
     * JBI is usable when the jbi-admin-gui and jbi-admin-common jar files are both present
     */
    private boolean mIsJbiJarsAvailable = false;

    /**
     * JBI JSF utility logger
     */
    private Logger mLog = Logger.getLogger("com.sun.jbi.jsf.util", null);
}
