/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.ee.server;

import com.sun.enterprise.server.ApplicationLoadEventListener;
import com.sun.enterprise.ee.server.group.core.CallBack;

/**
 * Callback that receives the notification from ServerMessageRuntime.
 * @author Binod.
 */
public class MessageCallBackImpl implements CallBack{
        
    private ApplicationLoadEventListener listener = null;
    private boolean loading = false;
    private boolean failure;

    MessageCallBackImpl(ApplicationLoadEventListener listener) {
        this.listener = listener;
    }
    
    void setLoading(boolean loading) {
        this.loading = loading;
    }   
    
    void setFailure(boolean failure) {
        this.failure = failure;
    }

    public void messagingCompleted() {
        ClassLoader toSet = listener.getClass().getClassLoader();
        ClassLoader saved = AppLoaderEventListener.setContextClassLoader(toSet);
        if (failure)
            listener.handleLoadFailureInCluster(false);    
        else if (loading)
            listener.handleLoadInCluster(false);
        else 
            listener.handleUnLoadInCluster();
        AppLoaderEventListener.setContextClassLoader(saved);
    }

    public void messagingTimedOut() {
        ClassLoader toSet = listener.getClass().getClassLoader();
        ClassLoader saved = AppLoaderEventListener.setContextClassLoader(toSet);
        if (failure )
            listener.handleLoadFailureInCluster(true);
        else if (loading)
            listener.handleLoadInCluster(true);
        else 
            listener.handleUnLoadInCluster();
        AppLoaderEventListener.setContextClassLoader(saved);
    }
 
}
