/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.ee.server.group;

/**
 * The class that encapsulates the parsing of the bytes received from GMS.
 * Parser is designed to handle <route-string>:key=value:key=value;....
 * Any other kind of message is not handled and can cause problems to the 
 * system.
 * 
 * In case of deployment, the message will be <route-string>:GK=<appname>
 * So far, we did not have the need to add anything that indicates if it is 
 * load or unload...
 * 
 * @author Binod.
 */
public class MessageParser {
    static final String ITEM_DELIM = "=";
    
    static final String DELIM = ":";
    
    static Message parse(byte[] bytes) {
        Message msgObject = null;
        String msg = new String(bytes);
        String[] messageParts = msg.split(DELIM);
        for (String part: messageParts) {            
            
            //First string has to be type..
            if (msgObject == null) {
                msgObject = MessageFactory.createMessage(part);
                continue;
            }
            
            String[] items = part.split(ITEM_DELIM, 2);            
            msgObject.add(items[0], items[1]);            
        }        
        return msgObject;
    }
}
