/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
/*
 * ApplicationStatusChecker.java
 *
 * Created on June 11, 2008, 2:02 PM
 *
 */
package com.sun.enterprise.ee.web.sessmgmt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 *
 * @author Larry White
 */
public class ApplicationStatusChecker {
    
    public final static String LOGGER_MEM_REP 
        = ReplicationState.LOGGER_MEM_REP;    
    
    private static final Logger _logger 
        = Logger.getLogger(LOGGER_MEM_REP);    
    
    public final static String MESSAGE_APPLICATION_STATUS_QUERY
        = ReplicationState.MESSAGE_APPLICATION_STATUS_QUERY;
    
    private static final AtomicBoolean FIRSTTIME = new AtomicBoolean(true);
    
    private static boolean isFirstTimeExecuted() {
        return FIRSTTIME.get();
    }
    
    static void resetFirstTimeExecuted() {
        FIRSTTIME.set(true);
    }
    
    private static boolean checkFirstTimeExecuted() {
        return FIRSTTIME.compareAndSet(true, false);
    }

    private String getReplicateToInstanceName() {
        ReplicationHealthChecker healthChecker
            = ReplicationHealthChecker.getInstance();
        String replicaInstanceName = null;
        //only pay 3 sec sleep time the first execution
        if(checkFirstTimeExecuted()) {
            replicaInstanceName 
                = healthChecker.getReshapeReplicateToInstanceName(null);
        } else {
            replicaInstanceName 
                = healthChecker.getReshapeReplicateToInstanceName(null, 0L);
        }
        return replicaInstanceName;
    }
    
    public boolean isApplicationDeployed(String applicationId, String mode) {
        boolean result = false;
        HashMap resultMap = doApplicationDeployedQuery(applicationId, mode);
        String replicaInstanceName = this.getReplicateToInstanceName();
        if(_logger.isLoggable(Level.FINE)) {
            _logger.fine("isApplicationDeployed:replicaInstanceName = " + replicaInstanceName);
        }
        Iterator it = resultMap.keySet().iterator();
        while(it.hasNext()) {
            String nextInstanceName = (String)it.next();
            if(_logger.isLoggable(Level.FINE)) {
                _logger.fine("isApplicationDeployed:nextInstanceName = " + nextInstanceName);
            }
            if(nextInstanceName.equals(replicaInstanceName)) {
                String isDeployedString = (String)resultMap.get(nextInstanceName);
                if(_logger.isLoggable(Level.FINE)) {
                    _logger.fine("isApplicationDeployed:isDeployedString = " + isDeployedString);
                }
                if(isDeployedString.equals("Y")) {
                    result = true;
                } else {
                    result = false;
                }
                break;
            }
        }
        return result;
    }
    
    public HashMap doApplicationDeployedQuery(String applicationId, String mode) {

        HashMap result = new HashMap();
        String applicationStatusCommand = MESSAGE_APPLICATION_STATUS_QUERY;
        //need a unique pseudo-id for this query
        String id = applicationId + ReplicationUtil.getInstanceName() + System.currentTimeMillis();
        ReplicationState state = 
            ReplicationState.createBroadcastQueryState(mode, id, applicationId, -1L, ReplicationUtil.getInstanceName(), applicationStatusCommand);

        int numberExpectedResults = ReplicationUtil.getNumberExpectedRespondants();
        FederatedApplicationStatusRequestProcessor federatedRequestProcessor = 
            new FederatedApplicationStatusRequestProcessor(state, numberExpectedResults, 4000L);
       
        JxtaReplicationSender sender 
            = JxtaReplicationSender.createInstance();
        ReplicationState queryResult = sender.sendReplicationStateQuery(state, federatedRequestProcessor);
        if(queryResult != null && queryResult.getState() != null) {
            byte[] returnState = queryResult.getState();
            try {
                result = (HashMap)ReplicationState.getObjectValue(returnState);
            } catch (Exception ex) {
                ; //deliberately do nothing
            }            
        }
        return result;
    }      

}
