/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * Portions Copyright Apache Software Foundation.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.ee.web.sessmgmt;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.apache.catalina.session.IOUtilsCaller;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.web.ServerConfigLookup;

/**
 *
 * @author Larry White
 */
public abstract class BaseFileSync {
    
    public final static String LOGGER_MEM_REP 
        = ReplicationState.LOGGER_MEM_REP;    
    
    /**
     * The logger to use for logging ALL web container related messages.
     */
    private static final Logger _logger 
        = Logger.getLogger(LOGGER_MEM_REP);    
    
    // ----------------------------------------------------- Constants

    protected static final String DEFAULT_DIRECTORY 
        = getDefaultDirectoryString();

    /**
     * The extension to use for serialized session filenames.
     */
    protected static final String FILE_ACTIVE_EXT = ".active";
    
    /**
     * The extension to use for serialized replica filenames.
     */
    protected static final String FILE_REPLICA_EXT = ".replica";

    /**
     * The extension to use for serialized replica update filenames.
     */
    protected static final String FILE_REPLICA_UPDATE_EXT = ".replicaupd";
    
    /**
     * The descriptive information about this implementation.
     */
    private static final String INFO = "WebFileSync/1.0";

    /**
     * Name to register for this Store, used for logging.
     */
    private static final String STORENAME = "baseFileSync";

    /**
     * Name to register for the background thread.
     */
    private static final String THREADNAME = "BaseFileSync";    


    // ----------------------------------------------------- Instance Variables


    /**
     * The pathname of the directory in which Sessions are stored.
     * This may be an absolute pathname, or a relative path that is
     * resolved against the temporary work directory for this application.
     */
    //protected String directory = ".";
    protected String directory = DEFAULT_DIRECTORY;

    /**
     * A File representing the directory in which Sessions are stored.
     */
    protected File directoryFile = null;    
    
    /**
     * The ReplicationManager with which this FileSync is associated.
     */
    protected ReplicationManager manager;    


    // ------------------------------------------------------------- Properties
    
    /**
     * Return the directory path for this Store.
     */
    public String getDirectory() {

        return (directory);

    }


    /**
     * Set the directory path for this Store.
     *
     * @param path The new directory path
     */
    public void setDirectory(String path) {

        String oldDirectory = this.directory;
        this.directory = path;
        this.directoryFile = null;

    }
    
    /**
     * Return descriptive information about this Store implementation and
     * the corresponding version number, in the format
     * <code>&lt;description&gt;/&lt;version&gt;</code>.
     */
    public String getInfo() {

        return (INFO);

    }

    /**
     * Return the thread name for this Store.
     */
    public String getThreadName() {
        return(THREADNAME);
    }

    /**
     * Return the name for this Store, used for logging.
     */
    public String getStoreName() {
        return(STORENAME);
    }
    
    protected void writeReplicatedSessions(BaseCache replicaCache, ObjectOutputStream oos) 
        throws IOException {
        oos.writeInt(replicaCache.getEntryCount());
        Iterator it = replicaCache.values();
        while(it.hasNext()) {
            oos.writeObject((ReplicationState)it.next());
        }
    }    
    
    protected void readReplicatedSessions(BaseCache replicaCache, ObjectInputStream ois) 
        throws ClassNotFoundException, IOException {
        int count = ois.readInt();
        for(int i=0; i<count; i++) {
            ReplicationState nextState = (ReplicationState)ois.readObject();
            replicaCache.put(nextState.getId(), nextState);
        }
    }
    
    public File getFile(String fileExtension) throws IOException {    
        String fileKey = getFileKey(manager);
        File file = file(fileKey, fileExtension);
        if (file == null) {
            return null;
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("file name: " + file.getCanonicalPath());
            }
        }
        return file;
    }
    
    public ObjectOutputStream getObjectOutputStream(String fileExtension) throws IOException {    
        String fileKey = getFileKey(manager);
        File file = file(fileKey, fileExtension);
        if (file == null) {
            return null;
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("file name for oos: " + file.getCanonicalPath());
            }
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            IOUtilsCaller caller = ReplicationUtil.getWebUtilsCaller();
            if (caller != null) {
                try {
                    oos = caller.createObjectOutputStream(
                            new BufferedOutputStream(fos), true);
                } catch (Exception ex) {}
            }
            // Use normal ObjectOutputStream if there is a failure during
            // stream creation
            if(oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(fos)); 
            }             
        } catch (IOException e) {
            if (oos != null) {
                try {
                    oos.close();
                } catch (IOException f) {
                    ;
                }
            }
            throw e;
        }
        return oos;
    } 
    
    public ObjectOutputStream getObjectOutputStream(File file) throws IOException {    
        if (file == null) {
            return null;
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("file name for oos: " + file.getCanonicalPath());
            }
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file.getAbsolutePath());
            IOUtilsCaller caller = ReplicationUtil.getWebUtilsCaller();
            if (caller != null) {
                try {
                    oos = caller.createObjectOutputStream(
                            new BufferedOutputStream(fos), true);
                } catch (Exception ex) {}
            }
            // Use normal ObjectOutputStream if there is a failure during
            // stream creation
            if(oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(fos)); 
            }             
        } catch (IOException e) {
            if (oos != null) {
                try {
                    oos.close();
                } catch (IOException f) {
                    ;
                }
            }
            throw e;
        }
        return oos;
    }      
    
    protected static String getDefaultDirectoryString() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        String result = lookup.getInstallRoot() + File.separator + "rollingupgrade";
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("getDefaultDirectoryString: " + result);
        }        
        return result;
        //FIXME replace with below after testing
        //return lookup.getInstallRoot() + File.separator + "rollingupgrade";
    }
    
    protected String getFileKey(ReplicationManager mgr) {
        String applicationId = mgr.getApplicationId();
        String result1 = applicationId.replace(":/", "-");
        String result2 = result1.replace(":", "-");
        return result2;
    }
    
    /**
     * Return a File object representing the pathname to our
     * session persistence directory, if any.  The directory will be
     * created if it does not already exist.
     */
    protected abstract File directory();    


    /**
     * Return a File object representing the pathname to our
     * session persistence file, if any.
     *
     * @param id The ID of the Session to be retrieved. This is
     *    used in the file naming.
     * @param extension The extension of the file to be retrieved
     */
    protected File file(String id, String extension) {
        
        if (this.directory == null) {
            return (null);
        }
        String filename = id + extension;
        File file = new File(directory(), filename);
        return (file);

    }    

}
