/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.enterprise.ee.web.sessmgmt;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import java.util.logging.Level;
import java.util.concurrent.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 *
 * @author Larry White
 */
public class FederatedApplicationStatusRequestProcessor implements Callable, FederatedQueryProcessor {
    public final static String LOGGER_MEM_REP 
        = ReplicationState.LOGGER_MEM_REP;
    
    /**
     * The logger to use for logging ALL web container related messages.
     */
    private static final Logger _logger 
        = Logger.getLogger(LOGGER_MEM_REP);    
    private static final Logger _pipelogger = ReplicationUtil.getPipeLogger();
    private static final Logger _salogger = ReplicationUtil.getSALogger();    
    
    public final static String RETURN_BROADCAST_MSG_COMMAND 
        = ReplicationState.RETURN_BROADCAST_MSG_COMMAND;  //"broadcastResponse";    
    
    /**
     * Creates a new instance of FederatedApplicationStatusRequestProcessor
     */
    public FederatedApplicationStatusRequestProcessor(ReplicationState aSendQueryState, int numberOfRequests, long waitTime) {
        sendQueryState = aSendQueryState;
        counter = numberOfRequests;
        waitTimeMillis = waitTime;
    }
    
    public ReplicationState doFederatedQuery() {
        ReplicationState result = null;
        result = this.call();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("FederatedApplicationStatusRequestProcessor>>doFederatedQuery:result = " + result);
        }        
        if(result != null) {
            ReplicationResponseRepository.putEntry(result);
        }
        cleanup();
        return result;
    } 
    
    public ReplicationState call() {
        JxtaReplicationSender sender = null;
        synchronized(this) {
            //first send messages
            sender = JxtaReplicationSender.createInstance();
            sender.sendBroadcastQuery(sendQueryState);
            //now block and wait for time or all responses back
            try {
                wait(waitTimeMillis);
            } catch(InterruptedException ex) {
                //nothing
            }
        }
        return prepareFinalResult();
        
    }   
    
    private ReplicationState prepareFinalResult() {
        HashMap finalMap = new HashMap();
        for(int i=0; i<resultList.size(); i++) {
            ReplicationState nextState 
                = (ReplicationState)resultList.get(i);
            String nextInstanceName = (String)nextState.getExtraParam();
            String isDeployedString = (String)nextState.getQueryResult();

            //get any existing element in the map
            FederatedStatusQueryListElement existingElement 
                = (FederatedStatusQueryListElement)finalMap.get(nextInstanceName);
            if(existingElement == null) {
                finalMap.put(nextInstanceName, isDeployedString);
            }
        }
        //serialize the final map and use it as the state in the query result
        byte[] elementMapState = null;
        try {
            elementMapState = ReplicationUtil.getByteArray((HashMap)finalMap);
        } catch (IOException ex) {
            ;
        }
        if(result != null) {
            return ReplicationState.createUpdatedStateFrom(result, result.getCommand(), elementMapState);
        } else {
            return ReplicationState.createUpdatedStateFrom(sendQueryState, RETURN_BROADCAST_MSG_COMMAND, elementMapState);
        }
    }
    
    public synchronized void processQueryResponse(ReplicationState incomingState) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("FederatedApplicationStatusRequestProcessor:processQueryResponse:incomingVersion=" + incomingState.getVersion() 
                + " source_instance= " + incomingState.getInstanceName() 
                + " counter=" + counter
                + "isNack: " + isNack(incomingState));
        }
        //two main alternatives nack or not
        if(isNack(incomingState)) { //nack case
            counter--;
        } else { //non-nack case
            if(result == null) {
                result = incomingState;
            }            
            resultList.add(incomingState);
            counter--;
        }
        if(counter == 0) {
            this.notify();
        }
    } 
    
    boolean isNack(ReplicationState incomingState) {
        return incomingState.isNack();
    }    
    
    private synchronized void cleanup() {
        result = null;
        sendQueryState = null;
        counter = 0;
        waitTimeMillis = 0L;
        resultList = new ArrayList();
    }    
    
    private ReplicationState sendQueryState = null;
    private ReplicationState result = null;
    //list of ReplicationState
    private List resultList = new ArrayList();
    private int counter = 0;
    private long waitTimeMillis = 0L;

    public class FederatedStatusQueryListElement implements Serializable {

        /** Creates a new instance of FederatedStatusQueryListElement */
        public FederatedStatusQueryListElement(String instanceName, String queryResult) {
            this.instanceName = instanceName;
            this.queryResult = queryResult;
        }

        public String getInstanceName() {
            return instanceName;
        }

        public String getQueryResult() {
            return queryResult;
        }

        @Override
         public int hashCode() {
             return instanceName.hashCode();
         }

        @Override
         public boolean equals(Object obj) {
             boolean result = false;
             if (obj instanceof FederatedStatusQueryListElement) {
                 FederatedStatusQueryListElement other = (FederatedStatusQueryListElement) obj;
                 if (instanceName.equals(other.instanceName)) {
                     result = true;
                 }
             }

             return result;
         }      

        private String instanceName = null;
        private String queryResult = null;    

    }    
}
