/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.jbi.jsf.handlers;

import com.sun.jsftemplating.annotation.Handler;
import com.sun.jsftemplating.annotation.HandlerInput;
import com.sun.jsftemplating.annotation.HandlerOutput;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;

import java.lang.reflect.Method;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Provides jsftemplating handlers for showing/discarding Alerts
 */
public class JBIHookHandlers
{
    //Get Logger to log fine mesages for debugging
    private static Logger sLog = Logger.getLogger("com.sun.jbi.jsf.handlers");
    

    /**
     * <p> Decreases the number of alerts to be displayed if an alert is to be displayed
     * <p> If JBI extension jars are present, delegates to the extension implementation.
     * <p> If JBI jars are not present, no-ops.
     * <p> Input  value: "isAlertNeeded" -- Type: <code> Boolean</code></p>
     * @param  handlerCtx <code>HandlerContext</code> provides inputs and outputs.
     */
    @Handler(id="jbiDecrementAlertCountIfNeeded",
	     input={
		 @HandlerInput(name="isAlertNeeded", type=Boolean.class, required=true)} )
	
        public static void jbiDecrementAlertCountIfNeeded(HandlerContext handlerCtx)
    {
        Boolean isAlertNeeded = (Boolean)
            handlerCtx.getInputValue("isAlertNeeded");

	// TBD delegate to JBI implementation, if available
	final String IMPL_CLASS_NAME = "com.sun.jbi.jsf.handlers.AlertHandlers";
	final String IMPL_METHOD_NAME = "jbiDecrementAlertCountIfNeededImpl";
	final Class[] IMPL_METHOD_ARG_TYPES = {
	    HandlerContext.class,
	};
	final Object[] IMPL_METHOD_ARG_VALUES = {
	    handlerCtx,
	};
	final Object STATIC = null; // for invoking static methods

	// TBD delegate to JBI implementation, if available
	try
	    {
		Class handlerClass = 
		    Class.forName(IMPL_CLASS_NAME);
		Method handlerMethod = 
		    handlerClass.getMethod(IMPL_METHOD_NAME,
					   IMPL_METHOD_ARG_TYPES);
		Object ignoredForVoidResult =
		    handlerMethod.invoke(STATIC, 
					 IMPL_METHOD_ARG_VALUES);
		sLog.fine("JBIHookHandlers.jbiDecrementAlertCountIfNeeded(...)");
	    }
	catch (Exception ex)
	    {
		sLog.log(Level.FINE,
			 "JBIHookHandlers.jbiDecrementAlertCountIfNeeded(...), caught Exception",
			 ex);

	    }
	sLog.fine("JBIHookHandlers.jbiDecrementAlertCountIfNeeded(...), " +
		  " isAlertNeeded=" + isAlertNeeded);
	
    }

    /**
     * <p> Returns true if an alert still needs to be displayed
     * <p> Output  value: "isAlertNeeded" -- Type: <code> Boolean</code></p>
     * @param  handlerCtx <code>HandlerContext</code> provides inputs and outputs.
     */
    @Handler(id="jbiIsAlertNeeded",
	     output={
		 @HandlerOutput(name="isAlertNeeded", type=Boolean.class) } )
	
        public static void jbiIsAlertNeeded(HandlerContext handlerCtx)
    {
	final String IMPL_CLASS_NAME = "com.sun.jbi.jsf.handlers.AlertHandlers";
	final String IMPL_METHOD_NAME = "jbiIsAlertNeededImpl";
	final Class[] IMPL_METHOD_ARG_TYPES = {
	    HandlerContext.class,
	};
	final Object[] IMPL_METHOD_ARG_VALUES = {
	    handlerCtx,
	};
	final Object STATIC = null; // for invoking static methods

	boolean isAlertNeeded = false;

	try
	    {
		Class handlerClass = 
		    Class.forName(IMPL_CLASS_NAME);
		Method handlerMethod = 
		    handlerClass.getMethod(IMPL_METHOD_NAME,
					   IMPL_METHOD_ARG_TYPES);
		Object handlerResult =
		    handlerMethod.invoke(STATIC, 
					 IMPL_METHOD_ARG_VALUES);
		sLog.fine("JBIHookHandlers.jbiIsAlertNeeded(...), handlerResult=" + 
			  handlerResult);
		// TBD convert to boolean
	    }
	catch (Exception ex)
	    {
		sLog.log(Level.FINE,
			 "JBIHookHandlers.jbiIsAlertNeeded(...), caught Exception",
			 ex);

	    }

	handlerCtx.setOutputValue ("isAlertNeeded", isAlertNeeded);

	sLog.fine("JBIHookHandlers.jbiIsAlertNeeded(...), " +
		  " isAlertNeeded=" + isAlertNeeded);
	
    }


}
