/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sun.enterprise.ee.server.group;

import com.sun.enterprise.ee.server.group.core.CallBack;
import com.sun.enterprise.ee.server.group.core.ServerMessageRuntime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Implementation of Barrier. 
 * @author Binod.
 */
public class BarrierSupport implements Barrier {

    private List keys = null;
    private Object lock = new Object();
    private CallBack cb;
    private ServerMessageRuntime rt;
    private MessageAggregator ma;
    private Logger logger;

    private BarrierSupport
    (List keys, CallBack cb, MessageAggregator ma, ServerMessageRuntime rt) {
        this.cb = cb;
        this.keys = keys;
        this.ma = ma;
        this.rt = rt;
        this.logger = rt.getLogger();
    }

    static Barrier create
    (List keys, CallBack cb, MessageAggregator ma, ServerMessageRuntime rt) {
        return new BarrierSupport(keys, cb, ma, rt);
    }

    public void start() {
        logger.finer("In the BarrierSupport.start");
        synchronized (lock) {
            try {
                if (keys != null && !keys.isEmpty()) {
                    logger.finer("About to Wait");
                    lock.wait();
                }
            } catch (Exception e) {

            }
        }
        
        if (cb != null) {
            cb.messagingCompleted();
        }
        logger.finer("Came out of Barrier Support.start");
    }

    public void start(long timeout) {
        logger.fine("In the BarrierSupport.start");
        synchronized (lock) {
            try {
                if (keys != null && !keys.isEmpty()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("About to Wait" + timeout);
                        for (Object key : keys)
                            logger.fine("Printing key list:" + key);
                    }
                    lock.wait(timeout);
                }
            } catch (Exception e) {
                logger.log(Level.SEVERE,e.getMessage(),e);
            }
        }
        
        if (keys != null && !keys.isEmpty()) {
            if (cb != null) {
                cb.messagingTimedOut();
            }
        } else {
            if (cb != null) {
                cb.messagingCompleted();
            }
        }
        
        logger.finer("Came out of Barrier Support.start");
    }

    public void release() {
        __notify();
    }

    public void release(String key) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer
            ("Removing Key :" + key + "from Barrier: " + keys.size());
        }

        if (keys == null || keys.isEmpty()) {
            __notify();
            return;
        }

        keys.remove(key);

        if (keys.isEmpty()) {
            __notify();
        }
    }

    void __notify() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("About to notify : " + cb);
        }
        ma.release();
        synchronized (lock) {
            lock.notifyAll();
        }
 
    }
}
