/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.ee.server.group;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.Map.Entry;

/**
 * Message is little more that what is needed for deployment.
 * @author haritham
 */
public class Message {
    private String sender;
    
    private final String GROUPKEY = "GK";

    /**
     * ONETOALL: This means that message is sent from one instance to all
     *           other instances.
     * ALLTOONE: This means that message is sent from all instances to one
     *           instance.
     * NONE:     No Route. Used by subsystems to communicate with SMRT without
     *           any messaging.
     */    
    public enum Route {ONETOALL, ALLTOONE, NONE};
                
    private String msg = "";
    private Route route = Route.NONE;
    private ConcurrentHashMap<String, String> messageParts = 
    messageParts = new ConcurrentHashMap();        

    Message(String msg) {        
        this(Route.valueOf(msg));
    }
      
    /**
     *  Route of the message. This defines from where the message came
     * 
     * @param route
     */
    Message(Route route) {
        this.msg = route.toString();
        this.route = route;
    }   
    
    public Route getRoute() {
        return this.route;
    }
    
    /**
     * Return the aggregation key. This would be appname, in case of 
     * deployment.
     * 
     * @return
     */
    public String getMessageAggregationKey() {
        return messageParts.get(GROUPKEY);        
    }
    
    /**
     * Set the aggregation key. This will app name, in case of deployment.
     * @param value
     */
    public void setAggregationKey(String value) {
        messageParts.put(GROUPKEY, value);
    }
    
    String getSender() {
        return sender;
    }
    
    // Name of the server who send this message.
    void setSender(String sender) {
        this.sender = sender;
    }        
            
    String _append (String msg, String parent) {
         if (parent == null) {
            return msg;
        } else {
            return parent + MessageParser.DELIM + msg;
        }
    }        
    
    // This is virtually unused method now.
    void add(String key, String value) {
        this.messageParts.put(key, value);
    }
    
    
    @Override
    public String toString() {
        String output = this.msg;
        for (Entry<String, String> entry : messageParts.entrySet()) {
            output = 
            _append(entry.getKey() + MessageParser.ITEM_DELIM 
                    + entry.getValue(), output);
        }            
        return output;
    }
    
    // Convert the message to bytes before sending over the wire.
    public byte[] toBytes() {
        return toString().getBytes();
    }
}
