/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.ee.server.group;

import com.sun.enterprise.ee.server.group.Message.Route;
import com.sun.enterprise.ee.server.group.core.CallBack;
import com.sun.enterprise.ee.server.group.core.ServerMessageRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * A MessageAggregator. This class is responsible for aggregating the messages 
 * recieved and let the Barrier know of the arrival of the messages. The Barrior
 * is created only lazily. I.e only when the application (eg: deployment 
 * runtime) request for it.
 * 
 * So, when Barrier is created, the messages will be transferred to the Barrier
 * to check whether it need to be started. Some times all the messages might 
 * have already reached the server, before the Barrier is created. That case is
 * handled inside the Barrier.
 * 
 * @author Binod.
 */
public class MessageAggregator {
    private String groupKey;
    private Barrier barrier;
    private List<Message> messages = null;
    private List servers = null;
    private CallBack cb = null;
    private ServerMessageRuntime rt;
    private Route route;
    private Logger logger;
    
    public MessageAggregator
    (String groupKey, List<String> servers, ServerMessageRuntime rt) {        
        this.groupKey = groupKey;                
        this.servers = servers;
        this.messages = new ArrayList();
        this.rt = rt;
        this.logger = rt.getLogger();
    }
    
    /**
     * Return a Barrier instance.
     * 
     * @return Barrier
     */
    public Barrier getBarrier() {
        if (this.barrier == null) {
            synchronized (messages) {
                // Create the barrier, only when the caller asks
                // for it. It also means that there is a caller.
                this.barrier = 
                BarrierSupport.create(this.servers, cb, this, this.rt);                
                for (Message msg: messages) {
                    barrier.release(msg.getSender());
                }
                messages.clear();
            }
        }
        return this.barrier;
    }
    
    /**
     * Messages will be added to the aggregator using this method. If the 
     * Barrier is present, send it to the Barrier.
     */
    public void addMessage(Message msg) {        
        synchronized (messages) {
            if (this.barrier == null) {
                messages.add(msg);
            } else {
                this.barrier.release(msg.getSender());
            }
        }
    }

    // The callback interface where the callback need to be executed when
    // the Barrier is removed.
    public void setCallBack(CallBack cb) {
        this.cb = cb;
    }
    
    // The route in which this aggregator will aggegate the messages.
    public void setRoute(Route route) {
        this.route = route;
    }

    void release() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer
            ("Releasing the aggregator for " + groupKey + " on " + this.route);
        }
        rt.release(this.groupKey, this.route);
    }
    
}
