/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.ee.server.group.core;

import com.sun.enterprise.ee.cms.core.GroupManagementService;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Default elector implementation.
 * 
 * @author Binod.
 */
public class ElectorImpl implements Elector {
    private GroupManagementService gms;
    private ServerMessageRuntime rt;
    private Logger logger;
        

    ElectorImpl(GroupManagementService gms, ServerMessageRuntime rt) {
        this.gms = gms;
        this.rt = rt;
        this.logger = rt.getLogger();                
    }

    /**
     * Select the instance that first joined the 
     * cluster as the elected instance.
     * So, if the elected instance gets restarted
     * it will not get any notification.
     */
    public String getElectedInstance() {
         List<String> members = 
         gms.getGroupHandle().getCurrentCoreMembersWithStartTimes();
         
         SortedMap map = new TreeMap();
         for (String member : members) {
             //GMS defines that the :: is the separator.
             String[] serverAndTime = member.split("::");
             
             String server = serverAndTime[0];
             String startTime = serverAndTime[1];
             
             if (logger.isLoggable(Level.FINER)) {             
                 logger.finer(" Instance "+ server +" started at :"+ startTime);
             }
             map.put(startTime, server);
         }
         return (String) map.get(map.firstKey());
    }        
}
