/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.ee.web.sessmgmt;

/**
 *
 * @author bhavanishankar@dev.java.net
 */
public final class ObjectUtil {

    private static final java.util.List<String> IMMUTABLE_CLASSES =
            java.util.Arrays.asList(new String[]{
        java.lang.String.class.getName(),
        java.lang.Character.class.getName(),
        java.lang.Number.class.getName(),
        java.lang.Boolean.class.getName(),
        java.util.concurrent.atomic.AtomicBoolean.class.getName(),
        java.util.concurrent.atomic.AtomicInteger.class.getName(),
        java.util.concurrent.atomic.AtomicLong.class.getName(),
        java.math.BigDecimal.class.getName(),
        java.math.BigInteger.class.getName(),
        java.lang.Byte.class.getName(),
        java.lang.Double.class.getName(),
        java.lang.Float.class.getName(),
        java.lang.Integer.class.getName(),
        java.lang.Long.class.getName(),
        java.lang.Short.class.getName()
    });

    public static boolean isImmutable(Object obj) {
        if (obj == null ||
                IMMUTABLE_CLASSES.contains(obj.getClass().getName())) {
            return true;
        }
        return false;
    }
}
