/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.res;

import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class XSLMessages {
    private Locale fLocale = Locale.getDefault();
    private static ListResourceBundle XSLTBundle = null;
    private static ListResourceBundle XPATHBundle = null;
    private static final String XSLT_ERROR_RESOURCES = "org.apache.xalan.res.XSLTErrorResources";
    private static final String XPATH_ERROR_RESOURCES = "org.apache.xpath.res.XPATHErrorResources";
    private static String BAD_CODE = "BAD_CODE";
    private static String FORMAT_FAILED = "FORMAT_FAILED";

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public static final String createXPATHWarning(String msgKey, Object[] args) {
        if (XPATHBundle == null) {
            XPATHBundle = XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if (XPATHBundle != null) {
            return XSLMessages.createXPATHMsg(XPATHBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMessage(String msgKey, Object[] args) {
        if (XPATHBundle == null) {
            XPATHBundle = XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if (XPATHBundle != null) {
            return XSLMessages.createXPATHMsg(XPATHBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMsg(ListResourceBundle fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString("BAD_CODE");
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                int i = 0;
                while (i < n) {
                    if (null == args[i]) {
                        args[i] = "";
                    }
                    ++i;
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = fResourceBundle.getString("FORMAT_FAILED");
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final String createMessage(String msgKey, Object[] args) {
        if (XSLTBundle == null) {
            XSLTBundle = XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if (XSLTBundle != null) {
            return XSLMessages.createMsg(XSLTBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createWarning(String msgKey, Object[] args) {
        if (XSLTBundle == null) {
            XSLTBundle = XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if (XSLTBundle != null) {
            return XSLMessages.createMsg(XSLTBundle, msgKey, args);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMsg(ListResourceBundle fResourceBundle, String msgKey, Object[] args) {
        String fmsg = null;
        boolean throwex = false;
        String msg = null;
        if (msgKey != null) {
            msg = fResourceBundle.getString(msgKey);
        }
        if (msg == null) {
            msg = fResourceBundle.getString(BAD_CODE);
            throwex = true;
        }
        if (args != null) {
            try {
                int n = args.length;
                int i = 0;
                while (i < n) {
                    if (null == args[i]) {
                        args[i] = "";
                    }
                    ++i;
                }
                fmsg = MessageFormat.format(msg, args);
            }
            catch (Exception e) {
                fmsg = fResourceBundle.getString(FORMAT_FAILED);
                fmsg = fmsg + " " + msg;
            }
        } else {
            fmsg = msg;
        }
        if (throwex) {
            throw new RuntimeException(fmsg);
        }
        return fmsg;
    }

    public static final ListResourceBundle loadResourceBundle(String className) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        try {
            return (ListResourceBundle)ResourceBundle.getBundle(className, locale);
        }
        catch (MissingResourceException e) {
            try {
                return (ListResourceBundle)ResourceBundle.getBundle(XSLT_ERROR_RESOURCES, new Locale("en", "US"));
            }
            catch (MissingResourceException e2) {
                throw new MissingResourceException("Could not load any resource bundles." + className, className, "");
            }
        }
    }

    private static final String getResourceSuffix(Locale locale) {
        String suffix = "_" + locale.getLanguage();
        String country = locale.getCountry();
        if (country.equals("TW")) {
            suffix = suffix + "_" + country;
        }
        return suffix;
    }
}

