/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CheckBundles
extends Task {
    private static HashSet knownKeys;
    private static String[] moduleKeys;
    private File srcdir;

    public void setSrcdir(File f) {
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("srcdir must be a directory");
        }
        this.srcdir = f;
    }

    public void execute() throws BuildException {
        this.log("Scanning " + this.srcdir.getAbsolutePath(), 3);
        Map knownNames = this.parseManifest(this.srcdir);
        ArrayList bundles = new ArrayList();
        TreeMap sources = new TreeMap();
        try {
            File dir = new File(this.srcdir, "src");
            if (dir.exists()) {
                this.scanSubdirs(dir, bundles, sources);
            }
            if ((dir = new File(this.srcdir, "libsrc")).exists()) {
                this.scanSubdirs(dir, bundles, sources);
            }
            this.check(bundles, sources, knownNames);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void scan(File file, Collection bundles, Map sources) throws Exception {
        File bundle = new File(file, "Bundle.properties");
        if (!bundle.exists()) {
            this.log("No bundle in " + file.getAbsolutePath() + ". OK", 3);
        } else {
            bundles.add(bundle);
        }
        this.addSources(file, sources);
    }

    private void check(Collection bundles, Map files, Map knownNames) {
        try {
            Iterator bIt = bundles.iterator();
            while (bIt.hasNext()) {
                File bundle = (File)bIt.next();
                Iterator it = this.entries(bundle).iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    this.log("Looking for " + key, 4);
                    boolean found = false;
                    if (bundle.equals(knownNames.get(key))) {
                        this.log("Checked name " + key + " OK", 3);
                        found = true;
                    } else {
                        Object o = files.get(bundle.getParentFile());
                        this.log(" in " + o, 4);
                        String[] srcs = (String[])o;
                        int i = 0;
                        while (i < srcs.length) {
                            if (srcs[i].indexOf("\"" + key + "\"") >= 0) {
                                this.log("Checking " + key + " OK", 3);
                                found = true;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (found) continue;
                    Iterator fIt = files.keySet().iterator();
                    block5: while (fIt.hasNext()) {
                        File dir = (File)fIt.next();
                        String[] srcs = (String[])files.get(dir);
                        int i = 0;
                        while (i < srcs.length) {
                            if (srcs[i].indexOf("\"" + key + "\"") >= 0) {
                                this.log(bundle.getPath() + ": " + key + " used from " + dir.getPath(), 1);
                                found = true;
                                continue block5;
                            }
                            ++i;
                        }
                    }
                    if (found) continue;
                    this.log(bundle.getPath() + ": " + key + " NOT FOUND");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void scanSubdirs(File file, Collection bundles, Map srcs) throws Exception {
        this.log("scanSubdirs " + file, 4);
        File[] subdirs = file.listFiles(new FilenameFilter(){

            public boolean accept(File f, String name) {
                return new File(f, name).isDirectory();
            }
        });
        int i = 0;
        while (i < subdirs.length) {
            this.scan(subdirs[i], bundles, srcs);
            this.scanSubdirs(subdirs[i], bundles, srcs);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addSources(File dir, Map map) throws Exception {
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        String[] srcs = new String[files.length];
        int i = 0;
        while (i < files.length) {
            int len;
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(files[i]));
            byte[] arr = new byte[2048];
            srcs[i] = "";
            while ((len = ((InputStream)is).read(arr)) != -1) {
                void var8_8;
                srcs[i] = srcs[i] + new String(arr, 0, (int)var8_8);
            }
            ++i;
        }
        map.put(dir, srcs);
    }

    /*
     * WARNING - void declaration
     */
    private Collection entries(File bundle) throws IOException {
        String l;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new FileReader(bundle));
        boolean multi = false;
        while ((l = r.readLine()) != null) {
            void var4_5;
            if (var4_5.startsWith("#")) continue;
            int i = var4_5.indexOf(61);
            if (i > 0 && !multi) {
                String key = var4_5.substring(0, i).trim();
                list.add(key);
            }
            multi = var4_5.endsWith("\\");
        }
        return list;
    }

    private Map parseManifest(File dir) {
        HashMap<String, File> files = new HashMap<String, File>(10);
        try {
            String lb;
            File mf = new File(this.srcdir, "manifest-subst.mf");
            if (!mf.exists()) {
                return files;
            }
            this.log("Found manifest", 3);
            Manifest m = new Manifest(new FileInputStream(mf));
            Attributes attr = m.getMainAttributes();
            String string = lb = attr == null ? null : attr.getValue("OpenIDE-Module-Localizing-Bundle");
            if (lb != null) {
                File lbundle = new File(this.srcdir.getAbsolutePath() + File.separator + "src" + File.separatorChar + lb);
                this.log("Recognized localizing bundle " + lbundle, 3);
                int i = 0;
                while (i < moduleKeys.length) {
                    files.put(moduleKeys[i], lbundle);
                    ++i;
                }
            }
            String xml = attr == null ? null : attr.getValue("OpenIDE-Module-Layer");
            File xmlFile = null;
            if (xml != null) {
                xmlFile = new File(this.srcdir.getAbsolutePath() + File.separator + "src" + File.separator + xml);
            }
            if (xmlFile != null && xmlFile.exists()) {
                SAXParserFactory f = SAXParserFactory.newInstance();
                f.setValidating(false);
                SAXParser p = f.newSAXParser();
                XMLReader reader = p.getXMLReader();
                reader.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String publicId, String systemId) {
                        CheckBundles.this.log("resolveEntity " + publicId + ", " + systemId, 4);
                        return new InputSource(new ByteArrayInputStream(new byte[0]));
                    }
                });
                reader.setContentHandler(new SAXHandler(files));
                reader.parse(new InputSource(xmlFile.toURL().toExternalForm()));
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        return files;
    }

    static {
        moduleKeys = new String[]{"OpenIDE-Module-Name", "OpenIDE-Module-Display-Category", "OpenIDE-Module-Long-Description", "OpenIDE-Module-Short-Description"};
    }

    private class SAXHandler
    extends DefaultHandler {
        private String path;
        private Map map;

        public SAXHandler(Map map) {
            this.map = map;
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            this.path = "";
        }

        public void endElement(String uri, String lname, String name) throws SAXException {
            super.endElement(uri, lname, name);
            if ("folder".equals(name) || "file".equals(name)) {
                int i = this.path.lastIndexOf(47);
                this.path = i > 0 ? this.path.substring(0, i) : "";
            }
        }

        public void startElement(String uri, String lname, String name, org.xml.sax.Attributes attributes) throws SAXException {
            String a;
            super.startElement(uri, lname, name, attributes);
            if ("folder".equals(name) || "file".equals(name)) {
                String f = attributes.getValue("name");
                if (name != null) {
                    this.path = this.path + (this.path.length() == 0 ? f : "/" + f);
                }
            } else if ("attr".equals(name) && "SystemFileSystem.localizingBundle".equals(a = attributes.getValue("name"))) {
                String val = attributes.getValue("stringvalue");
                String lfilename = CheckBundles.this.srcdir.getAbsolutePath() + File.separator + "src" + File.separator + val.replace('.', File.separatorChar) + ".properties";
                File lfile = new File(lfilename);
                CheckBundles.this.log("Recognized file " + this.path + " with name localized in " + lfile, 3);
                int i = 0;
                while (i < moduleKeys.length) {
                    this.map.put(this.path, lfile);
                    ++i;
                }
            }
        }
    }
}

