/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.nbbuild.Issue;
import org.netbeans.nbbuild.IssuezillaXMLHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public final class Issuezilla {
    private URL urlBase;
    private SAXParser saxParser;
    private int maxIOFailures = 15;
    private Vector proxyServer = null;
    private int lastProxy = -1;

    public void setProxyPool(String proxyPool) {
        StringTokenizer tokens = new StringTokenizer(proxyPool, ",");
        this.proxyServer = new Vector();
        while (tokens.hasMoreTokens()) {
            this.proxyServer.add(tokens.nextToken());
        }
        this.rotateProxy();
    }

    private void rotateProxy() {
        if (this.proxyServer == null) {
            return;
        }
        if (this.proxyServer.size() == 0) {
            return;
        }
        this.lastProxy = this.lastProxy + 2 > this.proxyServer.size() ? 0 : ++this.lastProxy;
        String proxyString = (String)this.proxyServer.get(this.lastProxy);
        String host = proxyString.substring(0, proxyString.indexOf(58));
        String port = proxyString.substring(proxyString.indexOf(58) + 1);
        System.out.println("Rotating http proxy server to " + host + ":" + port);
        if (!port.equals("")) {
            ((Hashtable)System.getProperties()).put("http.proxyPort", port);
        }
        if (!host.equals("")) {
            ((Hashtable)System.getProperties()).put("http.proxyHost", host);
        }
    }

    public Issue getBug(int number) throws SAXException, IOException {
        Issue[] arr = this.getBugs(new int[]{number});
        if (arr.length != 1) {
            throw new InvalidObjectException("Issue not read");
        }
        return arr[0];
    }

    /*
     * WARNING - void declaration
     */
    public Issue[] getBugs(int[] numbers) throws SAXException, IOException {
        int maxIssuesAtOnce = 10;
        Issue[] result = new Issue[numbers.length];
        int issueToProcess = 0;
        block10: while (issueToProcess < numbers.length) {
            int lastIssueRightNow = Math.min(numbers.length, issueToProcess + maxIssuesAtOnce);
            StringBuffer sb = new StringBuffer(numbers.length * 8);
            String sep = "xml.cgi?id=";
            IOException lastEx = null;
            int i = issueToProcess;
            while (i < lastIssueRightNow) {
                sb.append(sep);
                sb.append(numbers[i]);
                sep = ",";
                ++i;
            }
            sb.append("&show_attachments=false");
            int iterate = 0;
            while (iterate < this.maxIOFailures) {
                Issue[] issueArray;
                URL u = null;
                try {
                    void arr;
                    u = new URL(this.urlBase, sb.toString());
                    InputStream is = u.openStream();
                    try {
                        issueArray = this.getBugs(is);
                    }
                    finally {
                        Object var14_14 = null;
                        is.close();
                    }
                    int i2 = 0;
                    while (i2 < ((void)arr).length) {
                        result[issueToProcess++] = arr[i2++];
                    }
                    continue block10;
                }
                catch (IOException ex) {
                    issueArray = this;
                    synchronized (issueArray) {
                        try {
                            System.out.println(new Date().toString() + ": Can't get URL : " + u.toString());
                            super.rotateProxy();
                            this.wait(5000L);
                        }
                        catch (InterruptedException ex1) {
                            // empty catch block
                        }
                    }
                    lastEx = ex;
                    ++iterate;
                }
            }
            throw lastEx;
        }
        return result;
    }

    public int[] query(String query) throws SAXException, IOException {
        String line;
        URL u = new URL(this.urlBase, "buglist.cgi?" + query);
        IOException lastEx = null;
        BufferedReader reader = null;
        int iterate = 0;
        while (iterate < this.maxIOFailures) {
            try {
                reader = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
            }
            catch (IOException ex) {
                Issuezilla issuezilla = this;
                synchronized (issuezilla) {
                    try {
                        System.out.println(new Date().toString() + ": Can't get URL : " + u.toString());
                        this.rotateProxy();
                        this.wait(5000L);
                    }
                    catch (InterruptedException ex1) {
                        // empty catch block
                    }
                }
                lastEx = ex;
            }
            ++iterate;
        }
        if (reader == null) {
            if (lastEx != null) {
                throw lastEx;
            }
            throw new IOException("Can't get connection to " + u.toString() + " for " + this.maxIOFailures + "times.");
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        String magic = "show_bug.cgi?id=";
        while ((line = reader.readLine()) != null) {
            int index = line.indexOf(magic);
            if (index == -1) continue;
            int end = line.indexOf(34, index += magic.length());
            if (end == -1) {
                throw new IOException("No ending \" from index " + index + " in " + line);
            }
            String number = line.substring(index, end);
            result.add(Integer.valueOf(number));
        }
        int[] arr = new int[result.size()];
        Iterator it = ((AbstractList)result).iterator();
        int i = 0;
        while (i < arr.length) {
            arr[i] = (Integer)it.next();
            ++i;
        }
        return arr;
    }

    private Issue[] getBugs(InputStream in) throws SAXException, IOException {
        IssuezillaXMLHandler handler = new IssuezillaXMLHandler();
        this.saxParser.parse(in, (HandlerBase)handler);
        return this.getBugsFromHandler(handler);
    }

    private Issue[] getBugsFromHandler(IssuezillaXMLHandler handler) {
        List bugList = handler.getBugList();
        if (bugList == null) {
            return null;
        }
        Issue[] bugs = new Issue[bugList.size()];
        int i = 0;
        while (i < bugList.size()) {
            Issue bug = new Issue();
            Map atts = (Map)bugList.get(i);
            Iterator it = atts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                bug.setAttribute((String)entry.getKey(), entry.getValue());
            }
            bugs[i] = bug;
            ++i;
        }
        return bugs;
    }

    public Issuezilla(URL urlBase) {
        this.urlBase = urlBase;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            this.saxParser = factory.newSAXParser();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalStateException("Cannot initialize parser");
        }
    }
}

