/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class UpdateTracking {
    private static final String ELEMENT_MODULE = "module";
    private static final String ATTR_CODENAME = "codename";
    private static final String ELEMENT_VERSION = "module_version";
    private static final String ATTR_VERSION = "specification_version";
    private static final String ATTR_ORIGIN = "origin";
    private static final String ATTR_LAST = "last";
    private static final String ATTR_INSTALL = "install_time";
    private static final String ELEMENT_FILE = "file";
    private static final String ATTR_FILE_NAME = "name";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    private static final String INST_ORIGIN = "installer";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String TRACKING_DIRECTORY = "update_tracking";
    private boolean pError = false;
    private File trackingFile = null;
    private String origin = "nbm";
    private String nbPath = null;
    private Module module = null;

    public UpdateTracking(String string) {
        this.nbPath = string;
        this.origin = INST_ORIGIN;
    }

    public Version addNewModuleVersion(String string, String string2) {
        this.module = new Module();
        this.module.setCodename(string);
        Version version = new Version();
        version.setVersion(string2);
        version.setOrigin(this.origin);
        version.setLast(true);
        version.setInstall_time(System.currentTimeMillis());
        this.module.setVersion(version);
        return version;
    }

    public void removeLocalized(String string) {
        File file = new File(this.nbPath, TRACKING_DIRECTORY);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".xml");
            }
        });
        if (fileArray != null) {
            int n = fileArray.length - 1;
            while (n >= 0) {
                this.trackingFile = fileArray[n];
                this.read();
                this.module.removeLocalized(string);
                this.write();
                --n;
            }
        }
    }

    void write() {
        Object object;
        Object object2;
        Object object3;
        Document document = XMLUtil.createDocument(ELEMENT_MODULE);
        Element element = null;
        Element element2 = null;
        Element element3 = null;
        element = document.createElement(ELEMENT_MODULE);
        element.setAttribute(ATTR_CODENAME, this.module.getCodename());
        document.appendChild(element);
        Iterator iterator = this.module.getVersions().iterator();
        while (iterator.hasNext()) {
            object3 = (Version)iterator.next();
            element2 = document.createElement(ELEMENT_VERSION);
            element2.setAttribute(ATTR_VERSION, ((Version)object3).getVersion());
            element2.setAttribute(ATTR_ORIGIN, ((Version)object3).getOrigin());
            element2.setAttribute(ATTR_LAST, "true");
            element2.setAttribute(ATTR_INSTALL, Long.toString(((Version)object3).getInstall_time()));
            element.appendChild(element2);
            object2 = ((Version)object3).getFiles().iterator();
            while (object2.hasNext()) {
                object = (ModuleFile)object2.next();
                element3 = document.createElement(ELEMENT_FILE);
                element3.setAttribute(ATTR_FILE_NAME, ((ModuleFile)object).getName());
                element3.setAttribute(ATTR_CRC, ((ModuleFile)object).getCrc());
                element2.appendChild(element3);
            }
        }
        object3 = this.module.getCodenamebase();
        object3 = ((String)object3).replace('.', '-') + ".xml";
        object2 = new File(this.nbPath + FILE_SEPARATOR + TRACKING_DIRECTORY);
        if (!((File)object2).exists()) {
            ((File)object2).mkdirs();
        }
        this.trackingFile = new File((File)object2, (String)object3);
        try {
            object = new FileOutputStream(this.trackingFile);
            XMLUtil.write(document, (OutputStream)object);
            ((OutputStream)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.trackingFile.delete();
            throw new BuildException("Could not write update tracking file", (Throwable)exception);
        }
    }

    private void read() {
        if (this.trackingFile.exists()) {
            Document document;
            Object object;
            try {
                FileInputStream fileInputStream = new FileInputStream(this.trackingFile);
                object = new InputSource(fileInputStream);
                document = XMLUtil.parse((InputSource)object, false, false, new ErrorCatcher(), null);
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (SAXException sAXException) {
                System.out.println("Bad update_tracking");
                sAXException.printStackTrace();
                return;
            }
            catch (IOException iOException) {
                System.out.println("Missing update_tracking");
                iOException.printStackTrace();
                return;
            }
            object = document.getDocumentElement();
            if (object != null && object.getTagName().equals(ELEMENT_MODULE)) {
                this.scanElement_module((Element)object);
            }
        }
    }

    void scanElement_module(Element element) {
        Object object;
        this.module = new Module();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            object = (Attr)namedNodeMap.item(n);
            if (object.getName().equals(ATTR_CODENAME)) {
                this.module.setCodename(object.getValue());
            }
            ++n;
        }
        object = element.getChildNodes();
        int n2 = 0;
        while (n2 < object.getLength()) {
            Element element2;
            Node node = object.item(n2);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getTagName().equals(ELEMENT_VERSION)) {
                this.scanElement_module_version(element2, this.module);
            }
            ++n2;
        }
    }

    void scanElement_module_version(Element element, Module module) {
        Object object;
        Version version = new Version();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            object = (Attr)namedNodeMap.item(n);
            if (object.getName().equals(ATTR_VERSION)) {
                version.setVersion(object.getValue());
            }
            if (object.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(object.getValue());
            }
            if (object.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.getBoolean(object.getValue()));
            }
            if (object.getName().equals(ATTR_INSTALL)) {
                long l = 0L;
                try {
                    l = Long.parseLong(object.getValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                version.setInstall_time(l);
            }
            ++n;
        }
        object = element.getChildNodes();
        int n2 = 0;
        while (n2 < object.getLength()) {
            Element element2;
            Node node = object.item(n2);
            if (node.getNodeType() == 1 && (element2 = (Element)node).getTagName().equals(ELEMENT_FILE)) {
                this.scanElement_file(element2, version);
            }
            ++n2;
        }
        module.addVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile moduleFile = new ModuleFile();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                moduleFile.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CRC)) {
                moduleFile.setCrc(attr.getValue());
            }
            ++n;
        }
        version.addFile(moduleFile);
    }

    class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }

        public void error(SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
            UpdateTracking.this.pError = true;
        }
    }

    class ModuleFile {
        private String name;
        private String crc;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String string) {
            this.crc = string;
        }
    }

    public class Version {
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List files = new ArrayList();

        String getVersion() {
            return this.version;
        }

        void setVersion(String string) {
            this.version = string;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String string) {
            this.origin = string;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean bl) {
            this.last = bl;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long l) {
            this.install_time = l;
        }

        List getFiles() {
            return this.files;
        }

        void setFiles(List list) {
            this.files = list;
        }

        void addFile(ModuleFile moduleFile) {
            this.files.add(moduleFile);
        }

        public void addFileWithCrc(String string, String string2) {
            ModuleFile moduleFile = new ModuleFile();
            moduleFile.setName(string);
            moduleFile.setCrc(string2);
            this.files.add(moduleFile);
        }

        public void removeLocalized(String string) {
            ArrayList<ModuleFile> arrayList = new ArrayList<ModuleFile>();
            Iterator iterator = this.files.iterator();
            while (iterator.hasNext()) {
                ModuleFile moduleFile = (ModuleFile)iterator.next();
                if (moduleFile.getName().indexOf("_" + string + ".") != -1 || moduleFile.getName().indexOf("_" + string + "/") != -1 || moduleFile.getName().endsWith("_" + string)) continue;
                arrayList.add(moduleFile);
            }
            this.files = arrayList;
        }
    }

    class Module {
        private String codename;
        private List versions = new ArrayList();

        Module() {
        }

        String getCodenamebase() {
            String string = new String(this.codename);
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(0, n);
            }
            return string;
        }

        String getCodename() {
            return this.codename;
        }

        void setCodename(String string) {
            this.codename = string;
        }

        List getVersions() {
            return this.versions;
        }

        void setVersions(List list) {
            this.versions = list;
        }

        void addVersion(Version version) {
            this.versions = new ArrayList();
            this.versions.add(version);
        }

        void setVersion(Version version) {
            this.versions = new ArrayList();
            this.versions.add(version);
        }

        void removeLocalized(String string) {
            Iterator iterator = this.versions.iterator();
            while (iterator.hasNext()) {
                Version version = (Version)iterator.next();
                version.removeLocalized(string);
            }
        }
    }
}

