/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/CLISupport.java,v 1.3 2005/12/25 03:45:45 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:45 $
 */
 

 
package com.sun.cli.jmx.support;
 
import javax.management.*;
import java.io.IOException;


public final class CLISupport implements CLISupportMBean
{
	private CLISupportMBeanImpl		mImpl;
    

	/*
		Constructor takes the MBeanServerConnection which should be used to implement
		its functionality.  This *need not be* the same MBeanServerConnection as the
		one in which this MBean itself is registered.
	 */
		public
	CLISupport( MBeanServerConnection conn, AliasMgrMBean aliasMgr )
		throws Exception
	{
		mImpl	= new CLISupportMBeanImpl( conn, aliasMgr );
	}
	
		public ResultsForGetSet []
	mbeanGet( String attrs, String [] targets) throws Exception
	{
		final ResultsForGetSet []	result	= mImpl.mbeanGet( attrs, targets );
		
		return( result );
	}
	

		public ResultsForGetSet []
	mbeanSet( String attrs, String [] targets ) throws Exception
	{
		final ResultsForGetSet []	result	= mImpl.mbeanSet( attrs, targets );
		
		return( result );
	}
	
	 
		public InvokeResult []
	mbeanInvoke( String operationName, String args, String [] targets )
		throws Exception
	{
		final InvokeResult []	result	= mImpl.mbeanInvoke( operationName, args, targets );
		
		return( result );
	}


		public InspectResult
	mbeanInspect( InspectRequest request, ObjectName name )
		throws Exception
	{
		final InspectResult	result	= (InspectResult)mImpl.mbeanInspect( request, name );
		
		return( result );
	}
	
		public InspectResult []
	mbeanInspect( InspectRequest request, String [] targets )
		throws Exception
	{
		final InspectResult []	result	= mImpl.mbeanInspect( request, targets );
		
		return( result );
	}
	
		public ObjectName []
	mbeanFind( String [] patterns  )
		throws Exception
	{
		final ObjectName []	result	= mImpl.mbeanFind( patterns );
		
		return( result );
	}
	
	
		public ObjectName []
	mbeanFind( String [] patterns, String regexList)
		throws Exception
	{
		final ObjectName []	result	= mImpl.mbeanFind( patterns, regexList );
		
		return( result );
	}
	
	
		public ObjectName []
	resolveTargets( final String [] targets ) throws Exception
	{
		final ObjectName []	resolved	= mImpl.resolveTargets( targets );
		
		return( resolved );
	}
	
		public void
	mbeanCreate( String name, String theClass, String args ) throws Exception
	{
		mImpl.mbeanCreate( name, theClass, args );
	}
	
		public void
	mbeanUnregister( String name ) throws Exception
	{
		mImpl.mbeanUnregister( name );
	}
	
		public int
	mbeanCount( ) throws Exception
	{
		return( mImpl.mbeanCount( ) );
	}
	
		public String []
	mbeanDomains( ) throws Exception
	{
		return( mImpl.mbeanDomains( ) );
	}
	
		public void
	mbeanListen(
		boolean	start,
		String [] targets,
		NotificationListener listener,
		NotificationFilter filter,
		Object handback ) throws Exception
	{
		mImpl.mbeanListen( start, targets, listener, filter, handback );
	}
	
}

