/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/support/CLISupportMBean.java,v 1.3 2005/12/25 03:45:46 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:46 $
 */
 

/*
	The MBean interface for CLI support.
 */
 
package com.sun.cli.jmx.support;

import javax.management.*;
import java.io.IOException;



public interface CLISupportMBean
{
	
	/*
		Supports the get CLI command
		
		@param attrs	comma-separated list of attributes
		@param targets	space-separated list of targets
	 */
		public ResultsForGetSet []
	mbeanGet( String attrs, String [] targets) throws Exception;
	

	/*
		Supports the set CLI command
		
		@param attrs	comma-separated list of attributes/value pairs
		@param targets	space-separated list of targets
	 */
		public ResultsForGetSet []
	mbeanSet( String attrs, String [] targets ) throws Exception;

	 
	/*
		Supports the invoke CLI command
		
		@param operationName	name of operation to invoke
		@param argList			comma-separated list of operation arguments
		@param namedInvocation	true if the arguments are named, false otherwise
		@param targets			space-separated list of targets
		
		@returns array of InvokeResult[], one for each resolved target
	 */
		public InvokeResult []
	mbeanInvoke( String operationName, String args, String [] targets ) throws Exception;
	
	
	
	/*
		Supports the find CLI command
		
		@param patterns	space-separated list of ObjectName patterns
		@returns	array of ObjectName which match the pattern(s)
	 */
		public ObjectName []
	mbeanFind( String [] patterns )
		throws Exception;
		
	/*
		Supports the find CLI command with regular expressions
		
		@param patterns	space-separated list of ObjectName patterns
		@param regexList comma-separate list of name/value regular expressions (eg nameexp=valueexp)
		@returns	array of ObjectName which match the pattern(s)
	 */
		public ObjectName []
	mbeanFind( String [] patterns, String regexList )
		throws Exception;


	/*
		Supports the inspect CLI command
		
		@param name	ObjectName which must resolve to single MBean ObjectName
	 */
		public InspectResult
	mbeanInspect( InspectRequest request, ObjectName name ) throws Exception;
	
	/*
		Supports the list CLI command
		
		@param patterns	space-separated list of ObjectName patterns
	 */
		public InspectResult []
	mbeanInspect( InspectRequest request, String [] targets ) throws Exception;
	
	
	/*
		Supports the create CLI command
		
		@param name		the ObjectName for the newly created MBean
		@param theClass	the class of the MBean to instantiate
		@param args		optional argument list to choose a constructor
	 */
		public void
	mbeanCreate( String name, String theClass, String args ) throws Exception;
	
	/*
		Supports the delete CLI command
		
		@param name		the ObjectName for the MBean to unregister
	 */
		public void
	mbeanUnregister( String name ) throws Exception;
	
	/*
		Supports the count CLI command
	 */
		public int
	mbeanCount(  ) throws Exception;
	
	/*
		Supports the domains CLI command
	 */
		public String []
	mbeanDomains(  ) throws Exception;
	
	/*
		Supports the delete CLI command
		
		@param name		the ObjectName for the MBean to unregister
	 */
		public void
	mbeanListen(
		boolean	start,
		String [] targets,
		NotificationListener listener,
		NotificationFilter filter,
		Object handback ) throws Exception;
	
	
	/*
		Resolve a set of targets to their underlying ObjectNames.  Targets may
		be fully qualified, partially qualified or aliases.  Targets that can't be
		resolved are ignored.
		
		@param targets	array of targets to be resolved.
	 */
		public ObjectName []
	resolveTargets( final String [] targets) throws Exception;
}

