/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import java.io.File;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import com.sun.enterprise.util.SystemPropertyConstants;

/**
 *  This is a control class that invoke AddonFacade using
 *  reflection. 
 *
 *  @author binod@dev.java.net
 */
final class AddonControl {

    private final String PACKAGE = "com.sun.enterprise.cli.framework";
    private final String ADDONFACADE = "com.sun.enterprise.addons.AddonFacade";
    private File installRoot = null;
    private Logger logger = null;
    private Class addonFacade = null;

    AddonControl() throws Exception {
        String installDir =
        System.getProperty(SystemPropertyConstants.INSTALL_ROOT_PROPERTY);
        this.installRoot = new File(installDir);
        this.logger = Logger.getLogger(PACKAGE, null);
        this.addonFacade = Class.forName(ADDONFACADE);
    } 

    /**
     * Invoke the install method.
     */
    void install(File jarFile) throws Throwable {
        try {
            Class[] args = new Class[] {File.class, File.class, Logger.class};
            Method m = addonFacade.getMethod("install", args);
            m.invoke(null, new Object[] {installRoot, jarFile, logger});
        } catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    /**
     * Invoke the uninstall method.
     */
    void uninstall(String addon) throws Throwable {
        try {
            Class[] args = new Class[] {File.class, String.class, Logger.class};
            Method m = addonFacade.getMethod("uninstall", args);
            m.invoke(null, new Object[] {installRoot, addon, logger});
        } catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    /**
     * Invoke configureDAS method. 
     */
    void configureDAS(File domainRoot) throws Throwable {
        try {
            Class[] args = new Class[] {File.class, File.class, Logger.class};
            Method m = addonFacade.getMethod("configureDAS", args);
            m.invoke(null, new Object[] {installRoot, domainRoot, logger});
        } catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    /**
     * Invoke unconfigureDAS method. 
     */
    void unconfigureDAS(File domainRoot) throws Throwable {
        try {
            Class[] args = new Class[] {File.class, File.class, Logger.class};
            Method m = addonFacade.getMethod("unconfigureDAS", args);
            m.invoke(null, new Object[] {installRoot, domainRoot, logger});
        } catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

}
    
