/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import javax.management.ObjectName;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import com.sun.enterprise.admin.common.ObjectNames;


// jdk imports
import java.io.File;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CreateSecurityMapCommand extends SecurityMapCommand{
    
    
    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand()throws CommandException, CommandValidationException
    {
        if (!validateOptions())
            throw new CommandValidationException("Validation failed");
        
        
           String objectName = getObjectName();
            Object[] params = getParamsInfo();
            String operationName = getOperationName();
            String[] types = getTypesInfo();    
            String[] map = null;            
            String[] principals = null;
            String[] usergroups = null;
            AttributeList list = null;
    
             list =(AttributeList) params[0];
             if(list != null){
                int s = list.size();
                int i = 0 ;
                for(i=0;i<s;i++)
                {
                    Attribute attribute =(Attribute)list.get(i);
                    if(attribute.getName().equalsIgnoreCase("principal"))
                    {
                        String principal = (String)attribute.getValue();
                        principals  =((String[]) getListOfValues(principal));
                        list.set(i,new Attribute("principal",principals));
                     }
                     if ((attribute.getName().equalsIgnoreCase("user_group")))
                     {
                         String usergroup = (String)attribute.getValue();
                         usergroups = ((String[])getListOfValues(usergroup));
                         list.set(i,new Attribute("user_group",usergroups));
                    }
                       
                }    
            }
               
             
           MBeanServerConnection mbsc = getMBeanServerConnection(getHost(), getPort(), 
                                    getUser(), getPassword());
        try 
        { 
	     ObjectName object  =(ObjectName)mbsc.invoke(new ObjectName(objectName), 
				     operationName, params, types);
             CLILogger.getInstance().printDetailMessage(getLocalizedString(
						       "CommandSuccessful",
            					       new Object[] {name}));
        }
        catch(Exception e)
        { 
    
	    if (e.getLocalizedMessage() != null)
		CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(getLocalizedString("CommandUnSuccessful",
						     new Object[] {name} ), e);
        }        
    }
    
                
        
    private String[] getListOfValues(String sOptions){
        StringTokenizer optionTokenizer   = new StringTokenizer(sOptions,",");
        int             size            = optionTokenizer.countTokens();
        String []       sOptionsList = new String[size];
        for (int ii=0; ii<size; ii++){
            sOptionsList[ii] = optionTokenizer.nextToken();
        } 
        return sOptionsList;
   }
    
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }
}
